/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.datasource;

import com.openexchange.java.ExceptionAwarePipedInputStream;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.AbortBehavior;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataContentHandlerDataSource
implements DataSource {
    static final Logger LOG = LoggerFactory.getLogger(DataContentHandlerDataSource.class);
    private final DataContentHandler dch;
    private final Object object;
    private final String objectMimeType;

    public DataContentHandlerDataSource(Object object, String objectMimeType, DataContentHandler dch) {
        this.object = object;
        this.objectMimeType = objectMimeType;
        this.dch = dch;
    }

    public InputStream getInputStream() throws IOException {
        final PipedOutputStream pos = new PipedOutputStream();
        final ExceptionAwarePipedInputStream pin = new ExceptionAwarePipedInputStream(pos, 65536);
        final DataContentHandler dch = this.dch;
        final Object object = this.object;
        final String objectMimeType = this.objectMimeType;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    dch.writeTo(object, objectMimeType, (OutputStream)pos);
                }
                catch (Exception e) {
                    pin.setException(e);
                }
                finally {
                    try {
                        pos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        ThreadPoolService threadPool = ThreadPools.getThreadPool();
        if (null == threadPool) {
            new Thread(r, "DataContentHandlerDataSource.getInputStream").start();
        } else {
            threadPool.submit(ThreadPools.task((Runnable)r), AbortBehavior.getInstance());
        }
        return pin;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public String getContentType() {
        return this.objectMimeType;
    }

    public String getName() {
        return null;
    }
}

