/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.loginhandler;

import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginResult;
import com.openexchange.mail.attachment.storage.DefaultMailAttachmentStorageRegistry;
import com.openexchange.mail.attachment.storage.MailAttachmentStorage;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;

public final class TransportLoginHandler
implements LoginHandlerService {
    @Override
    public void handleLogin(LoginResult login) throws OXException {
        try {
            Context ctx = login.getContext();
            ServerSession serverSession = TransportLoginHandler.getServerSessionFrom(login.getSession(), ctx);
            UserPermissionBits permissionBits = serverSession.getUserPermissionBits();
            if (permissionBits.hasWebMail() && TransportProperties.getInstance().isPublishOnExceededQuota() && permissionBits.hasInfostore()) {
                MailAttachmentStorage attachmentStorage = DefaultMailAttachmentStorageRegistry.getInstance().getMailAttachmentStorage();
                String name = TransportProperties.getInstance().getPublishingInfostoreFolder();
                if ("i18n-defined".equals(name)) {
                    name = "E-Mail attachments";
                }
                boolean checkForExpiredAttachments = TransportProperties.getInstance().publishedDocumentsExpire();
                long timeToLive = TransportProperties.getInstance().getPublishedDocumentTimeToLive();
                attachmentStorage.prepareStorage(name, checkForExpiredAttachments, timeToLive, serverSession);
            }
        }
        catch (RuntimeException e) {
            throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public void handleLogout(LoginResult logout) throws OXException {
    }

    private static ServerSession getServerSessionFrom(Session session, Context context) {
        if (session instanceof ServerSession) {
            return (ServerSession)session;
        }
        return ServerSessionAdapter.valueOf(session, context);
    }
}

