/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.attachment.storage;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.attachment.storage.DownloadUri;
import com.openexchange.mail.attachment.storage.MailAttachmentInfo;
import com.openexchange.mail.attachment.storage.MailAttachmentStorage;
import com.openexchange.mail.attachment.storage.StoreOperation;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.datasource.DocumentDataSource;
import com.openexchange.mail.mime.processing.MimeProcessingUtility;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationService;
import com.openexchange.publish.PublicationTarget;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.Closeable;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMailAttachmentStorage
implements MailAttachmentStorage {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMailAttachmentStorage.class);
    private static final List<File.Field> FIELDS = Collections.unmodifiableList(new ArrayList<File.Field>(Arrays.asList(File.Field.ID, File.Field.CREATED, File.Field.CREATED_BY)));

    private PublicationRefs getPublicationRefs() throws OXException {
        PublicationTargetDiscoveryService discoveryService = ServerServiceRegistry.getInstance().getService(PublicationTargetDiscoveryService.class, true);
        PublicationTarget target = discoveryService.getTarget("com.openexchange.publish.online.infostore.document");
        if (null == target) {
            LOG.warn("Missing publication target for ID \"com.openexchange.publish.online.infostore.document\".\nThrowing quota-exceeded exception instead.");
            throw ServiceExceptionCode.absentService(PublicationTarget.class);
        }
        PublicationService publisher = target.getPublicationService();
        return new PublicationRefs(target, publisher);
    }

    private Context getContext(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getContext();
        }
        return ContextStorage.getStorageContext(session.getContextId());
    }

    private Locale getSessionUserLocale(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser().getLocale();
        }
        Context context = ContextStorage.getStorageContext(session.getContextId());
        return UserStorage.getInstance().getUser(session.getUserId(), context).getLocale();
    }

    private static ServerSession getServerSessionFrom(Session session, Context context) {
        if (session instanceof ServerSession) {
            return (ServerSession)session;
        }
        return ServerSessionAdapter.valueOf(session, context);
    }

    @Override
    public void prepareStorage(String folderName, boolean checkForExpiredAttachments, long timeToLive, Session session) throws OXException {
        this.prepareStorage0(folderName, checkForExpiredAttachments, timeToLive, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareStorage0(String folderName, boolean checkForExpiredAttachments, long timeToLive, Session session) throws OXException {
        try {
            int folderId;
            Context ctx = this.getContext(session);
            ServerSession serverSession = DefaultMailAttachmentStorage.getServerSessionFrom(session, ctx);
            UserPermissionBits permissionBits = serverSession.getUserPermissionBits();
            OXFolderAccess folderAccess = new OXFolderAccess(ctx);
            FolderObject defaultInfoStoreFolder = folderAccess.getDefaultFolder(serverSession.getUserId(), 8);
            if (!defaultInfoStoreFolder.getEffectiveUserPermission(serverSession.getUserId(), permissionBits).canCreateSubfolders()) {
                throw OXFolderExceptionCode.NO_CREATE_SUBFOLDER_PERMISSION.create(session.getUserId(), defaultInfoStoreFolder.getObjectID(), ctx.getContextId());
            }
            String name = folderName;
            int lookUpFolder = OXFolderSQL.lookUpFolder(defaultInfoStoreFolder.getObjectID(), name, 8, null, ctx);
            if (-1 == lookUpFolder) {
                Class<DefaultMailAttachmentStorage> clazz = DefaultMailAttachmentStorage.class;
                synchronized (DefaultMailAttachmentStorage.class) {
                    folderId = this.createIfAbsent(serverSession, ctx, name, defaultInfoStoreFolder);
                    // ** MonitorExit[var14_13] (shouldn't be in output)
                }
            } else {
                folderId = lookUpFolder;
            }
            {
                long now;
                IDBasedFileAccess fileAccess;
                List<String> toRemove;
                serverSession.setParameter(MailSessionParameterNames.getParamPublishingInfostoreFolderID(), folderId);
                if (checkForExpiredAttachments && !(toRemove = this.getElapsedDocuments(folderId, fileAccess = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class).createAccess((Session)serverSession), serverSession, now = System.currentTimeMillis(), timeToLive)).isEmpty()) {
                    fileAccess.startTransaction();
                    try {
                        fileAccess.removeDocument(toRemove, now);
                        fileAccess.commit();
                    }
                    finally {
                        DefaultMailAttachmentStorage.finishSafe(fileAccess);
                    }
                }
                return folderId;
            }
        }
        catch (SQLException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String storeAttachment(MailPart attachment, StoreOperation op, Map<String, Object> storeProps, Session session) throws OXException {
        String folderId;
        String sFolderId;
        IDBasedFileAccessFactory fileAccessFactory = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class, true);
        boolean publishStore = StoreOperation.PUBLISH_STORE.equals((Object)op);
        String string = sFolderId = null == storeProps ? null : (String)storeProps.get("folder");
        if (null != sFolderId) {
            folderId = sFolderId;
        } else if (publishStore) {
            String key = MailSessionParameterNames.getParamPublishingInfostoreFolderID();
            if (session.containsParameter(key)) {
                folderId = ((Integer)session.getParameter(key)).toString();
            } else {
                String name = TransportProperties.getInstance().getPublishingInfostoreFolder();
                if ("i18n-defined".equals(name)) {
                    name = "E-Mail attachments";
                }
                int fuid = this.prepareStorage0(name, false, 0L, session);
                folderId = Integer.toString(fuid);
                session.setParameter(MailSessionParameterNames.getParamPublishingInfostoreFolderID(), (Object)fuid);
            }
        } else {
            throw MailExceptionCode.MISSING_PARAM.create("folder");
        }
        String name = attachment.getFileName();
        if (name == null) {
            name = "attachment";
        }
        DefaultFile file = new DefaultFile();
        file.setId(FileStorageFileAccess.NEW);
        file.setFolderId(folderId);
        file.setFileName(name);
        file.setFileMIMEType(attachment.getContentType().getBaseType());
        file.setTitle(name);
        file.setFileSize(attachment.getSize());
        if (null != storeProps) {
            String description = (String)storeProps.get("description");
            if (null != description) {
                file.setDescription(description);
            } else if (publishStore) {
                Locale locale = (Locale)storeProps.get("externalLocale");
                if (null == locale) {
                    locale = this.getSessionUserLocale(session);
                }
                StringHelper stringHelper = StringHelper.valueOf(locale);
                String desc = stringHelper.getString("This file has been published for E-Mail \"#SUBJECT#\" sent on #DATE# to #TO#");
                String subject = (String)storeProps.get("subject");
                desc = desc.replaceFirst("#SUBJECT#", Strings.quoteReplacement((String)(null == subject ? stringHelper.getString("[No Subject]") : subject)));
                Date date = (Date)storeProps.get("date");
                String repl = date == null ? "" : Strings.quoteReplacement((String)MimeProcessingUtility.getFormattedDate(date, 1, locale, TimeZone.getDefault()));
                desc = desc.replaceFirst("#DATE#", repl);
                InternetAddress[] to = (InternetAddress[])storeProps.get("to");
                desc = desc.replaceFirst("#TO#", Strings.quoteReplacement((String)(to == null || to.length == 0 ? "" : Strings.quoteReplacement((String)MimeProcessingUtility.addrs2String(to)))));
                file.setDescription(desc);
            }
        }
        IDBasedFileAccess fileAccess = fileAccessFactory.createAccess(session);
        boolean retry = true;
        int count = 1;
        StringBuilder hlp = new StringBuilder(16);
        while (retry) {
            InputStream in = attachment.getInputStream();
            boolean rollbackNeeded = false;
            try {
                fileAccess.startTransaction();
                rollbackNeeded = true;
                try {
                    fileAccess.saveDocument((File)file, in, Long.MAX_VALUE);
                    fileAccess.commit();
                    rollbackNeeded = false;
                    retry = false;
                }
                catch (OXException x) {
                    fileAccess.rollback();
                    rollbackNeeded = false;
                    if (!x.isPrefix("IFO")) {
                        throw x;
                    }
                    if (441 != x.getCode()) {
                        throw x;
                    }
                    hlp.setLength(0);
                    int pos = name.lastIndexOf(46);
                    String newName = pos >= 0 ? hlp.append(name.substring(0, pos)).append("_(").append(++count).append(')').append(name.substring(pos)).toString() : hlp.append(name).append("_(").append(++count).append(')').toString();
                    file.setFileName(newName);
                    file.setTitle(newName);
                }
                catch (RuntimeException e) {
                    throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
                }
                finally {
                    if (rollbackNeeded) {
                        fileAccess.rollback();
                    }
                    DefaultMailAttachmentStorage.finishSafe(fileAccess);
                }
            }
            finally {
                Streams.close((Closeable)in);
            }
        }
        return file.getId();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MailPart getAttachment(String id, Session session) throws OXException {
        MailPart mailPart;
        IDBasedFileAccess fileAccess = null;
        try {
            IDBasedFileAccessFactory fileAccessFactory = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class, true);
            fileAccess = fileAccessFactory.createAccess(session);
            File fileMetadata = fileAccess.getFileMetadata(id, FileStorageFileAccess.CURRENT_VERSION);
            String fileName = fileMetadata.getFileName();
            String fileMIMEType = fileMetadata.getFileMIMEType();
            if (Strings.isEmpty((String)fileMIMEType) || "application/octet-stream".equalsIgnoreCase(fileMIMEType)) {
                fileMIMEType = MimeType2ExtMap.getContentType(fileName, "application/octet-stream");
            }
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)new DocumentDataSource(id, fileMIMEType, fileName, session)));
            mimeBodyPart.setFileName(fileName);
            mimeBodyPart.setHeader("Content-Type", fileMIMEType);
            MailPart mailPart2 = MimeMessageConverter.convertPart((Part)mimeBodyPart, false);
            mailPart2.setSize(fileMetadata.getFileSize());
            mailPart = mailPart2;
        }
        catch (MessagingException e) {
            try {
                throw MimeMailException.handleMessagingException(e);
                catch (RuntimeException e2) {
                    throw MailExceptionCode.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DefaultMailAttachmentStorage.finishSafe(fileAccess);
                throw throwable;
            }
        }
        DefaultMailAttachmentStorage.finishSafe(fileAccess);
        return mailPart;
    }

    @Override
    public MailAttachmentInfo getAttachmentInfo(String id, Session session) throws OXException {
        MailAttachmentInfo mailAttachmentInfo;
        IDBasedFileAccess fileAccess = null;
        try {
            IDBasedFileAccessFactory fileAccessFactory = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class, true);
            fileAccess = fileAccessFactory.createAccess(session);
            File fileMetadata = fileAccess.getFileMetadata(id, FileStorageFileAccess.CURRENT_VERSION);
            String fileName = fileMetadata.getFileName();
            String fileMIMEType = fileMetadata.getFileMIMEType();
            if (Strings.isEmpty((String)fileMIMEType) || "application/octet-stream".equalsIgnoreCase(fileMIMEType)) {
                fileMIMEType = MimeType2ExtMap.getContentType(fileName, "application/octet-stream");
            }
            mailAttachmentInfo = new MailAttachmentInfo(id, fileMIMEType, fileName, fileMetadata.getFileSize());
        }
        catch (RuntimeException e) {
            try {
                throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DefaultMailAttachmentStorage.finishSafe(fileAccess);
                throw throwable;
            }
        }
        DefaultMailAttachmentStorage.finishSafe(fileAccess);
        return mailAttachmentInfo;
    }

    @Override
    public InputStream getAttachmentStream(String id, Session session) throws OXException {
        InputStream inputStream;
        IDBasedFileAccess fileAccess = null;
        try {
            IDBasedFileAccessFactory fileAccessFactory = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class, true);
            fileAccess = fileAccessFactory.createAccess(session);
            inputStream = fileAccess.getDocument(id, FileStorageFileAccess.CURRENT_VERSION);
        }
        catch (RuntimeException e) {
            try {
                throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DefaultMailAttachmentStorage.finishSafe(fileAccess);
                throw throwable;
            }
        }
        DefaultMailAttachmentStorage.finishSafe(fileAccess);
        return inputStream;
    }

    @Override
    public void removeAttachment(String id, Session session) throws OXException {
        IDBasedFileAccessFactory fileAccessFactory = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class, true);
        IDBasedFileAccess fileAccess = fileAccessFactory.createAccess(session);
        long timestamp = System.currentTimeMillis();
        fileAccess.startTransaction();
        try {
            fileAccess.removeDocument(Collections.singletonList(id), timestamp);
            fileAccess.commit();
        }
        catch (OXException x) {
            fileAccess.rollback();
            throw x;
        }
        finally {
            DefaultMailAttachmentStorage.finishSafe(fileAccess);
        }
    }

    @Override
    public DownloadUri getDownloadUri(String id, Session session) throws OXException {
        PublicationRefs publicationRefs = this.getPublicationRefs();
        Publication publication = new Publication();
        publication.setModule("infostore/object");
        publication.setEntityId(new FileID(id).getFileId());
        publication.setContext(this.getContext(session));
        publication.setUserId(session.getUserId());
        publication.setTarget(publicationRefs.target);
        publicationRefs.publisher.create(publication);
        String url = (String)publication.getConfiguration().get("url");
        return new DownloadUri(url, Integer.toString(publication.getId()));
    }

    @Override
    public void discard(String id, DownloadUri downloadUri, Session session) throws OXException {
        IDBasedFileAccessFactory fileAccessFactory = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class, true);
        PublicationRefs publicationRefs = this.getPublicationRefs();
        long timestamp = System.currentTimeMillis();
        try {
            publicationRefs.publisher.delete(this.getContext(session), Strings.parsePositiveInt((String)downloadUri.getDownloadInfo()));
        }
        catch (OXException e) {
            LOG.error("Publication with ID \"{} could not be roll-backed.", (Object)downloadUri.getDownloadInfo(), (Object)e);
        }
        try {
            IDBasedFileAccess fileAccess = fileAccessFactory.createAccess(session);
            fileAccess.startTransaction();
            try {
                fileAccess.removeDocument(Collections.singletonList(id), timestamp);
                fileAccess.commit();
            }
            catch (OXException x) {
                fileAccess.rollback();
                throw x;
            }
            finally {
                DefaultMailAttachmentStorage.finishSafe(fileAccess);
            }
        }
        catch (OXException e) {
            LOG.error("Transaction error while deleting file with ID \"{}\" failed.", (Object)id, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getElapsedDocuments(int folderId, IDBasedFileAccess fileAccess, ServerSession serverSession, long now, long timeToLive) throws OXException {
        SearchIterator searchIterator = fileAccess.getDocuments(String.valueOf(folderId), FIELDS).results();
        try {
            LinkedList<String> ret;
            int userId = serverSession.getUserId();
            if (searchIterator.size() != -1) {
                int size = searchIterator.size();
                ret = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    File file = (File)searchIterator.next();
                    if (!DefaultMailAttachmentStorage.isOwner(userId, file.getCreatedBy()) || !DefaultMailAttachmentStorage.isElapsed(now, file.getCreated().getTime(), timeToLive)) continue;
                    ret.add(file.getId());
                }
            } else {
                ret = new LinkedList();
                while (searchIterator.hasNext()) {
                    File file = (File)searchIterator.next();
                    if (!DefaultMailAttachmentStorage.isOwner(userId, file.getCreatedBy()) || !DefaultMailAttachmentStorage.isElapsed(now, file.getCreated().getTime(), timeToLive)) continue;
                    ret.add(file.getId());
                }
            }
            LinkedList<String> linkedList = ret;
            return linkedList;
        }
        finally {
            SearchIterators.close((SearchIterator)searchIterator);
        }
    }

    private static boolean isOwner(int sessionUser, int createdBy) {
        return sessionUser == createdBy;
    }

    private static boolean isElapsed(long now, long creationDate, long ttl) {
        return now - creationDate > ttl;
    }

    private int createIfAbsent(Session session, Context ctx, String name, FolderObject defaultInfoStoreFolder) throws SQLException, OXException {
        int lookUpFolder = OXFolderSQL.lookUpFolder(defaultInfoStoreFolder.getObjectID(), name, 8, null, ctx);
        if (-1 == lookUpFolder) {
            FolderObject fo = this.createNewInfostoreFolder(session.getUserId(), name, defaultInfoStoreFolder.getObjectID());
            return OXFolderManager.getInstance(session).createFolder(fo, true, System.currentTimeMillis()).getObjectID();
        }
        return lookUpFolder;
    }

    private FolderObject createNewInfostoreFolder(int adminId, String name, int parent) {
        FolderObject newFolder = new FolderObject();
        newFolder.setFolderName(name);
        newFolder.setParentFolderID(parent);
        newFolder.setType(2);
        newFolder.setModule(8);
        OCLPermission perm = new OCLPermission();
        perm.setEntity(adminId);
        perm.setFolderAdmin(true);
        perm.setFolderPermission(128);
        perm.setReadObjectPermission(128);
        perm.setWriteObjectPermission(128);
        perm.setDeleteObjectPermission(128);
        perm.setGroupPermission(false);
        newFolder.setPermissions(Collections.singletonList(perm));
        return newFolder;
    }

    private static void finishSafe(IDBasedFileAccess fileAccess) {
        if (fileAccess != null) {
            try {
                fileAccess.finish();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class PublicationRefs {
        final PublicationTarget target;
        final PublicationService publisher;

        PublicationRefs(PublicationTarget target, PublicationService publisher) {
            this.target = target;
            this.publisher = publisher;
        }
    }
}

