/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.json.cache.impl.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteFailedExceptionCodes;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class JsonCacheDeleteListener
implements DeleteListener {
    @Override
    public void deletePerformed(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        if (event.getType() == 1) {
            this.deleteUserEntriesFromDB(event, writeCon);
        } else if (event.getType() == 5) {
            this.deleteContextEntriesFromDB(event, writeCon);
        } else {
            return;
        }
    }

    private void deleteContextEntriesFromDB(DeleteEvent event, Connection writeCon) throws OXException {
        int contextId = event.getContext().getContextId();
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement("DELETE FROM jsonCache WHERE cid=?");
            stmt.setInt(1, contextId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw DeleteFailedExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Exception e) {
            throw DeleteFailedExceptionCodes.ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private void deleteUserEntriesFromDB(DeleteEvent event, Connection writeCon) throws OXException {
        int contextId = event.getContext().getContextId();
        PreparedStatement stmt = null;
        try {
            int userId = event.getId();
            int admin = event.getContext().getMailadmin();
            if (userId == admin) {
                this.deleteContextEntriesFromDB(event, writeCon);
                return;
            }
            int pos = 1;
            stmt = writeCon.prepareStatement("DELETE FROM jsonCache WHERE cid=? AND user=?");
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos, userId);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(stmt);
        }
        catch (OXException e) {
            throw e;
        }
        catch (SQLException e) {
            throw DeleteFailedExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Exception e) {
            throw DeleteFailedExceptionCodes.ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }
}

