/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.i18n.tools.TemplateToken;
import com.openexchange.i18n.tools.replacement.FormatLocalizedStringReplacement;

public final class TaskStatusReplacement
extends FormatLocalizedStringReplacement {
    private static final String[] STATUSES = new String[]{"Not started", "In progress", "Done", "Waiting", "Deferred"};
    public static final int STATUS_NOT_STARTED = 1;
    public static final int STATUS_IN_PROGRESS = 2;
    public static final int STATUS_DONE = 3;
    public static final int STATUS_WAITING = 4;
    public static final int STATUS_DEFERRED = 5;
    private int taskStatus;
    private int percentComplete;

    public static TaskStatusReplacement emptyTaskStatusReplacement() {
        return new TaskStatusReplacement();
    }

    private TaskStatusReplacement() {
        super(TemplateToken.TASK_STATUS, null, "");
        this.taskStatus = 0;
        this.percentComplete = 0;
    }

    public TaskStatusReplacement(int taskStatus, int percentComplete) {
        super(TemplateToken.TASK_STATUS, "Status: %1$s", STATUSES[TaskStatusReplacement.checkDecrStatus(taskStatus - 1)]);
        this.taskStatus = taskStatus;
        this.percentComplete = percentComplete;
    }

    private static int checkDecrStatus(int taskStatus) {
        if (taskStatus < 0 || taskStatus >= STATUSES.length) {
            throw new IllegalArgumentException("Invalid task status specified: " + (taskStatus + 1));
        }
        return taskStatus;
    }

    @Override
    public String getReplacement() {
        StringHelper sh = this.getStringHelper();
        if (this.taskStatus < 1 || this.taskStatus > 5) {
            return String.format(sh.getString("Status: %1$s"), sh.getString("Not set"));
        }
        String result = String.format(sh.getString("Status: %1$s"), sh.getString(STATUSES[this.taskStatus - 1]));
        StringBuilder b = new StringBuilder(result.length() + 16);
        if (this.changed()) {
            b.append("* ");
        }
        b.append(result);
        b.append(" (").append(this.percentComplete).append("%)");
        return b.toString();
    }

    @Override
    public boolean merge(TemplateReplacement other) {
        if (!TaskStatusReplacement.class.isInstance(other)) {
            return false;
        }
        if (super.merge(other)) {
            TaskStatusReplacement o = (TaskStatusReplacement)other;
            this.taskStatus = o.taskStatus;
            this.percentComplete = o.percentComplete;
            return true;
        }
        return false;
    }
}

