/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SubscriptionRemoverTask
implements UpdateTaskV2 {
    private final String subscriptionSourceId;

    public SubscriptionRemoverTask(String subscriptionSourceId) {
        this.subscriptionSourceId = subscriptionSourceId;
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND);
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        this.perform(params.getSchema(), params.getContextId());
    }

    @Override
    public int addedWithVersion() {
        return -1;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        DatabaseService ds = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = ds.getForUpdateTask(contextId);
        PreparedStatement stmt = null;
        try {
            if (!DBUtils.tablesExist(con, "subscriptions", "genconf_attributes_strings", "genconf_attributes_bools")) {
                return;
            }
            stmt = con.prepareStatement("DELETE subscriptions, genconf_attributes_strings, genconf_attributes_bools FROM subscriptions, genconf_attributes_strings, genconf_attributes_bools WHERE subscriptions.source_id = ? AND genconf_attributes_strings.id = subscriptions.configuration_id AND genconf_attributes_bools.id = subscriptions.configuration_id AND genconf_attributes_strings.cid = subscriptions.cid AND genconf_attributes_bools.cid = subscriptions.cid;");
            stmt.setString(1, this.subscriptionSourceId);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(stmt);
            if (con == null) return;
        }
        catch (SQLException x) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(x, x.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            if (con != null) {
                ds.backForUpdateTask(contextId, con);
            }
        }
        ds.backForUpdateTask(contextId, con);
        return;
    }
}

