/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarCache;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.MailAccountAddPersonalTask;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DuplicateContactCollectFolderRemoverTask
extends UpdateTaskAdapter {
    private static final String[] DEPENDENCIES = new String[]{MailAccountAddPersonalTask.class.getName()};

    @Override
    public int addedWithVersion() {
        return 98;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGH.priority;
    }

    @Override
    public String[] getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        final Logger log = LoggerFactory.getLogger(DuplicateContactCollectFolderRemoverTask.class);
        final ProgressState status = params.getProgressState();
        TIntObjectHashMap m = new TIntObjectHashMap();
        int total = DuplicateContactCollectFolderRemoverTask.getAllUsers(params.getContextId(), (TIntObjectMap<List<Integer>>)m);
        status.setTotal(total);
        final HashMap names = new HashMap(4);
        m.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<List<Integer>>(){

            public boolean execute(int currentContextId, List<Integer> list) {
                try {
                    DuplicateContactCollectFolderRemoverTask.iterateUsersPerContext(list, names, currentContextId, status, log);
                }
                catch (OXException e) {
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("DuplicateContactCollectFolderRemoverTask experienced an error while removing duplicate contact collect folders for users in context ");
                    sb.append(currentContextId);
                    sb.append(":\n");
                    sb.append(e.getMessage());
                    log.error(sb.toString(), (Throwable)e);
                }
                return true;
            }
        });
    }

    private static int getAllUsers(int contextId, TIntObjectMap<List<Integer>> m) throws OXException {
        int n;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block8: {
            con = Database.getNoTimeout(contextId, true);
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT cid, id FROM user");
            rs = stmt.executeQuery();
            if (rs.next()) break block8;
            int n2 = 0;
            DBUtils.closeSQLStuff(rs, stmt);
            Database.backNoTimeout(contextId, true, con);
            return n2;
        }
        try {
            int total = 0;
            do {
                List<Integer> l;
                int cid = rs.getInt(1);
                Integer user = rs.getInt(2);
                if (!m.containsKey(cid)) {
                    l = new ArrayList();
                    m.put(cid, l);
                } else {
                    l = (List)m.get(cid);
                }
                l.add(user);
                ++total;
            } while (rs.next());
            n = total;
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.backNoTimeout(contextId, true, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.backNoTimeout(contextId, true, con);
        return n;
    }

    static void iterateUsersPerContext(List<Integer> users, Map<Locale, String> names, int contextId, ProgressState status, Logger log) throws OXException {
        ContextImpl ctxi = new ContextImpl(contextId);
        ctxi.setMailadmin(DuplicateContactCollectFolderRemoverTask.getContextMailAdmin(contextId));
        ContextImpl ctx = ctxi;
        for (Integer user : users) {
            Connection writeCon;
            try {
                writeCon = Database.getNoTimeout(contextId, true);
                writeCon.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            try {
                DuplicateContactCollectFolderRemoverTask.checkDuplicates4User(user, ctx, names, writeCon, log);
                status.incrementState();
                writeCon.commit();
            }
            catch (SQLException e) {
                DBUtils.rollback(writeCon);
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Exception e) {
                DBUtils.rollback(writeCon);
                throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            finally {
                DBUtils.autocommit(writeCon);
                Database.backNoTimeout(contextId, true, writeCon);
            }
        }
    }

    private static void checkDuplicates4User(Integer user, Context ctx, Map<Locale, String> names, Connection writeCon, Logger log) {
        int contextId = ctx.getContextId();
        try {
            int userId = user;
            int parent = new OXFolderAccess(writeCon, ctx).getDefaultFolder(userId, 3).getObjectID();
            String name = DuplicateContactCollectFolderRemoverTask.getLocalizedName(names, userId, contextId, writeCon);
            int[] duplicateIDs = DuplicateContactCollectFolderRemoverTask.getExistingContactCollectorFolderIDs(name, parent, userId, contextId, writeCon);
            if (duplicateIDs.length > 1) {
                Arrays.sort(duplicateIDs);
                int contactCollectorID = DuplicateContactCollectFolderRemoverTask.getContactCollectorFolderID(userId, contextId, writeCon);
                if (contactCollectorID <= 0) {
                    contactCollectorID = duplicateIDs[0];
                    DuplicateContactCollectFolderRemoverTask.setContactCollectorFolderID(contactCollectorID, userId, contextId, writeCon);
                    int[] temp = duplicateIDs;
                    duplicateIDs = new int[temp.length - 1];
                    System.arraycopy(temp, 1, duplicateIDs, 0, duplicateIDs.length);
                } else {
                    int index = -1;
                    for (int i = 0; -1 == index && i < duplicateIDs.length; ++i) {
                        if (duplicateIDs[i] != contactCollectorID) continue;
                        index = i;
                    }
                    if (index >= 0) {
                        int[] temp = duplicateIDs;
                        int mlen = temp.length - 1;
                        duplicateIDs = new int[mlen];
                        System.arraycopy(temp, 0, duplicateIDs, 0, index);
                        if (index < mlen) {
                            System.arraycopy(temp, index + 1, duplicateIDs, index, mlen - index);
                        }
                    }
                }
                long now = System.currentTimeMillis();
                for (int i = 0; i < duplicateIDs.length; ++i) {
                    int duplicateID = duplicateIDs[i];
                    if (DuplicateContactCollectFolderRemoverTask.containsAnyObjectInFolder(duplicateID, writeCon, ctx.getContextId())) {
                        DuplicateContactCollectFolderRemoverTask.moveContacts(duplicateID, contactCollectorID, now, userId, ctx, writeCon);
                    }
                    DuplicateContactCollectFolderRemoverTask.deleteFolder(duplicateID, parent, now, userId, ctx, writeCon, log);
                }
            }
        }
        catch (SQLException e) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("DuplicateContactCollectFolderRemoverTask experienced an error while removing duplicate contact collect folders for user ");
            sb.append(user).append(" in context ");
            sb.append(contextId);
            sb.append(":\n");
            sb.append(e.getMessage());
            log.error(sb.toString(), (Throwable)e);
        }
        catch (OXException e) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("DuplicateContactCollectFolderRemoverTask experienced an error while removing duplicate contact collect folders for user ");
            sb.append(user).append(" in context ");
            sb.append(contextId);
            sb.append(":\n");
            sb.append(e.getMessage());
            log.error(sb.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean containsAnyObjectInFolder(int fid, Connection con, int cid) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT intfield01 FROM prg_contacts WHERE cid = ? AND fid = ? LIMIT 1;");
            stmt.setInt(1, cid);
            stmt.setInt(2, fid);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return bl;
    }

    private static String getLocalizedName(Map<Locale, String> names, int userId, int contextId, Connection writeCon) throws SQLException {
        Locale userLocale = DuplicateContactCollectFolderRemoverTask.getUserLocale(userId, contextId, writeCon);
        Locale l = userLocale == null ? Locale.ENGLISH : userLocale;
        String name = names.get(l);
        if (null == name) {
            name = StringHelper.valueOf(l).getString("Collected addresses");
            names.put(l, name);
        }
        return name;
    }

    private static int getContextMailAdmin(int cid) throws OXException {
        Connection writeCon = Database.getNoTimeout(cid, true);
        try {
            int n;
            ResultSet rs;
            PreparedStatement stmt;
            block10: {
                stmt = null;
                rs = null;
                stmt = writeCon.prepareStatement("SELECT user FROM user_setting_admin WHERE cid = ?");
                stmt.setInt(1, cid);
                rs = stmt.executeQuery();
                if (!rs.next()) break block10;
                int n2 = rs.getInt(1);
                DBUtils.closeSQLStuff(rs, stmt);
                return n2;
            }
            try {
                n = -1;
            }
            catch (SQLException e) {
                try {
                    throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(rs, stmt);
            return n;
        }
        finally {
            Database.backNoTimeout(cid, true, writeCon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Locale getUserLocale(int userId, int cid, Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block3: {
            Locale locale;
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement("SELECT preferredLanguage FROM user WHERE cid = ? AND id = ?");
                stmt.setInt(1, cid);
                stmt.setInt(2, userId);
                rs = stmt.executeQuery();
                if (rs.next()) break block3;
                locale = null;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            return locale;
        }
        Locale locale = LocaleTools.getLocale((String)rs.getString(1));
        DBUtils.closeSQLStuff(rs, stmt);
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getExistingContactCollectorFolderIDs(String name, int parent, int userId, int cid, Connection con) throws SQLException {
        int[] nArray;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid = ? AND parent = ? AND created_from = ? AND fname = ?");
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, parent);
            stmt.setInt(pos++, userId);
            stmt.setString(pos++, name);
            rs = stmt.executeQuery();
            TIntArrayList sia = new TIntArrayList(16);
            while (rs.next()) {
                sia.add(rs.getInt(1));
            }
            nArray = sia.toArray();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getContactCollectorFolderID(int userId, int cid, Connection con) throws SQLException {
        int id;
        ResultSet rs;
        PreparedStatement stmt;
        block5: {
            block4: {
                int n;
                stmt = null;
                rs = null;
                try {
                    stmt = con.prepareStatement("SELECT contact_collect_folder FROM user_setting_server WHERE cid = ? AND user = ?");
                    stmt.setInt(1, cid);
                    stmt.setInt(2, userId);
                    rs = stmt.executeQuery();
                    if (rs.next()) break block4;
                    n = -1;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(rs, stmt);
                return n;
            }
            id = rs.getInt(1);
            if (!rs.wasNull()) break block5;
            int n = -1;
            DBUtils.closeSQLStuff(rs, stmt);
            return n;
        }
        int n = id;
        DBUtils.closeSQLStuff(rs, stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setContactCollectorFolderID(int id, int userId, int cid, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE user_setting_server SET contact_collect_folder = ? WHERE cid = ? AND user = ?");
            stmt.setInt(1, id);
            stmt.setInt(2, cid);
            stmt.setInt(3, userId);
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveContacts(int from, int to, long now, int userId, Context ctx, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE prg_contacts SET fid = ?, changing_date = ?, changed_from = ? WHERE cid = ? AND fid = ?");
            int pos = 1;
            stmt.setInt(pos++, to);
            stmt.setLong(pos++, now);
            int admin = ctx.getMailadmin();
            stmt.setInt(pos++, admin > 0 ? admin : userId);
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, from);
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFolder(int id, int parent, long now, int userId, Context ctx, Connection con, Logger log) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM oxfolder_permissions WHERE cid = ? AND fuid = ?");
            int cid = ctx.getContextId();
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setLong(pos++, id);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(stmt);
            stmt = con.prepareStatement("DELETE FROM oxfolder_tree WHERE cid = ? AND fuid = ?");
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setLong(pos++, id);
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        int admin = ctx.getMailadmin();
        OXFolderSQL.updateLastModified(parent, now, admin > 0 ? admin : userId, con, ctx);
        ConditionTreeMapManagement.dropFor(ctx.getContextId());
        try {
            if (FolderCacheManager.isEnabled()) {
                FolderCacheManager.getInstance().removeFolderObject(id, ctx);
                FolderCacheManager.getInstance().removeFolderObject(parent, ctx);
            }
            DuplicateContactCollectFolderRemoverTask.broadcastEvent(id, true, userId, ctx.getContextId(), ServerServiceRegistry.getInstance().getService(EventAdmin.class));
            DuplicateContactCollectFolderRemoverTask.broadcastEvent(parent, true, userId, ctx.getContextId(), ServerServiceRegistry.getInstance().getService(EventAdmin.class));
            if (CalendarCache.isInitialized()) {
                CalendarCache.getInstance().invalidateGroup(ctx.getContextId());
            }
        }
        catch (OXException e) {
            log.error("", (Throwable)e);
        }
    }

    private static void broadcastEvent(int fuid, boolean deleted, int entity, int contextId, EventAdmin eventAdmin) {
        if (null == eventAdmin) {
            return;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>(6);
        ((Dictionary)properties).put("com.openexchange.folderstorage.context", contextId);
        ((Dictionary)properties).put("com.openexchange.folderstorage.user", entity);
        ((Dictionary)properties).put("com.openexchange.folderstorage.folder", String.valueOf(fuid));
        ((Dictionary)properties).put("com.openexchange.folderstorage.content-related", !deleted);
        Event event = new Event("com/openexchange/folderstorage", properties);
        eventAdmin.sendEvent(event);
    }
}

