/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class DropRendundantIndicesUpdateTask
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getDatabaseService().getForUpdateTask(contextId);
        try {
            con.setAutoCommit(false);
            this.dropIndex(con, "mailSync", new String[]{"cid", "user", "accountId"});
            this.dropIndex(con, "indexedFolders", new String[]{"cid", "uid", "module"});
            this.dropIndex(con, "indexedFolders", new String[]{"cid", "uid", "module", "account"});
            this.dropIndex(con, "oauth2Accessor", new String[]{"cid", "user"});
            this.dropIndex(con, "oauthAccessor", new String[]{"cid", "user"});
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.getDatabaseService().backForUpdateTask(con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{"com.openexchange.groupware.update.tasks.AddGuestCreatedByIndexForUserTable"};
    }

    private void dropIndex(Connection con, String table, String[] columns) throws SQLException {
        String index;
        if (Tools.tableExists(con, table) && null != (index = Tools.existsIndex(con, table, columns)) && !index.isEmpty()) {
            Tools.dropIndex(con, table, index);
        }
    }
}

