/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextExtended;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactsRepairLinksAttachments
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(ContactsRepairLinksAttachments.class);

    @Override
    public int addedWithVersion() {
        return 17;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            this.correctContacts(con);
            this.correctLinks(con);
            this.correctAttachments(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            if (con != null) {
                Database.backNoTimeout(contextId, true, con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void correctContacts(Connection con) throws SQLException {
        String sql = "SELECT c.intfield01,c.cid,c.pflag FROM prg_contacts c LEFT JOIN oxfolder_tree f ON c.fid=f.fuid AND c.cid=f.cid WHERE f.fuid is NULL";
        Statement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.createStatement();
            result = stmt.executeQuery("SELECT c.intfield01,c.cid,c.pflag FROM prg_contacts c LEFT JOIN oxfolder_tree f ON c.fid=f.fuid AND c.cid=f.cid WHERE f.fuid is NULL");
            ContextExtended ctx = null;
            while (result.next()) {
                boolean delete = false;
                int pos = 1;
                int id = result.getInt(pos++);
                int cid = result.getInt(pos++);
                int pflag = result.getInt(pos++);
                try {
                    ctx = ContextStorage.getInstance().loadContext(cid);
                    if (pflag == 0) {
                        try {
                            this.moveContactToAdmin(con, ctx, id);
                        }
                        catch (OXException e) {
                            LOG.info("Failed moving contact {} to admin in context {}. Removing contact.", new Object[]{id, cid, e});
                            delete = true;
                        }
                        catch (Exception e) {
                            LOG.info("Failed moving contact {} to admin in context {}. Removing contact.", new Object[]{id, cid, e});
                            delete = true;
                        }
                    } else {
                        LOG.info("Removing private contact {} in context {} because its folder does not exist anymore.", (Object)id, (Object)cid);
                        delete = true;
                    }
                }
                catch (OXException ce) {
                    LOG.info("Removing contact {} in context {} because context does not exist anymore.", (Object)id, (Object)cid);
                    delete = true;
                }
                if (!delete) continue;
                this.deleteContact(con, cid, id);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveContactToAdmin(Connection con, Context ctx, int id) throws SQLException, OXException {
        String sql = "UPDATE prg_contacts SET changed_from = ?, created_from = ?, changing_date = ?, fid = ? WHERE intfield01 = ? and cid = ?";
        int folderId = new OXFolderAccess(con, ctx).getDefaultFolder(ctx.getMailadmin(), 3).getObjectID();
        PreparedStatement stmt = null;
        try {
            LOG.info("Trying to move contact {} to admin in context {}.", (Object)id, (Object)ctx.getContextId());
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, ctx.getMailadmin());
            stmt.setInt(2, ctx.getMailadmin());
            stmt.setLong(3, System.currentTimeMillis());
            stmt.setInt(4, folderId);
            stmt.setInt(5, id);
            stmt.setInt(6, ctx.getContextId());
            stmt.execute();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteContact(Connection con, int cid, int id) throws SQLException {
        String sql = "DELETE FROM prg_contacts WHERE cid=? AND intfield01=?";
        PreparedStatement stmt2 = null;
        try {
            stmt2 = con.prepareStatement("DELETE FROM prg_contacts WHERE cid=? AND intfield01=?");
            stmt2.setInt(1, cid);
            stmt2.setInt(2, id);
            stmt2.execute();
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkContactExistence(Connection con, int id, int cid) throws SQLException {
        String sql = "SELECT intfield01 FROM prg_contacts WHERE cid=? AND intfield01=?";
        ResultSet result = null;
        PreparedStatement ps = null;
        boolean exists = false;
        try {
            ps = con.prepareStatement("SELECT intfield01 FROM prg_contacts WHERE cid=? AND intfield01=?");
            ps.setInt(1, cid);
            ps.setInt(2, id);
            result = ps.executeQuery();
            while (result.next()) {
                int chk = result.getInt(1);
                if (chk != id) continue;
                exists = true;
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, ps);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, ps);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void correctLinks(Connection con) throws SQLException {
        String sql = "SELECT firstid,firstmodule,secondid,secondmodule,cid FROM prg_links WHERE firstmodule=? OR secondmodule=?";
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            ps = con.prepareStatement("SELECT firstid,firstmodule,secondid,secondmodule,cid FROM prg_links WHERE firstmodule=? OR secondmodule=?");
            ps.setInt(1, 7);
            ps.setInt(2, 7);
            result = ps.executeQuery();
            while (result.next()) {
                int pos = 1;
                int id1 = result.getInt(pos++);
                int mod1 = result.getInt(pos++);
                int id2 = result.getInt(pos++);
                int mod2 = result.getInt(pos++);
                int cid = result.getInt(pos++);
                boolean deleteit = false;
                if (mod1 == 7 && !this.checkContactExistence(con, id1, cid)) {
                    deleteit = true;
                }
                if (mod2 == 7 && !deleteit && !this.checkContactExistence(con, id2, cid)) {
                    deleteit = true;
                }
                if (!deleteit) continue;
                this.deleteLink(cid, con, id1, id2, mod1, mod2);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, ps);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLink(int cid, Connection con, int id1, int id2, int mod1, int mod2) throws SQLException {
        LOG.info("Deleting orphaned link in context {}.", (Object)cid);
        String sql = "DELETE FROM prg_links WHERE firstid=? AND secondid=? AND firstmodule=? AND secondmodule=? AND cid=?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("DELETE FROM prg_links WHERE firstid=? AND secondid=? AND firstmodule=? AND secondmodule=? AND cid=?");
            int pos = 1;
            ps.setInt(pos++, id1);
            ps.setInt(pos++, id2);
            ps.setInt(pos++, mod1);
            ps.setInt(pos++, mod2);
            ps.setInt(pos++, cid);
            ps.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(null, ps);
        }
    }

    public void correctAttachments(Connection con) throws OXException {
        String sql = "SELECT a.cid,a.id,a.filename FROM prg_attachment a LEFT JOIN prg_contacts c ON a.attached=c.intfield01 AND a.cid=c.cid WHERE a.module=? AND c.intfield01 IS NULL";
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            ps = con.prepareStatement("SELECT a.cid,a.id,a.filename FROM prg_attachment a LEFT JOIN prg_contacts c ON a.attached=c.intfield01 AND a.cid=c.cid WHERE a.module=? AND c.intfield01 IS NULL");
            ps.setInt(1, 7);
            result = ps.executeQuery();
            while (result.next()) {
                int pos = 1;
                int cid = result.getInt(pos++);
                int attachId = result.getInt(pos++);
                String filename = result.getString(pos++);
                this.deleteAttachments(cid, con, attachId, filename);
            }
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, ps);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteAttachments(int cid, Connection con, int id, String filename) throws SQLException {
        LOG.info("Deleting orphaned attachment {} in context {}.", (Object)id, (Object)cid);
        try {
            Tools.removeFile(cid, filename);
        }
        catch (OXException e) {
            LOG.info("Context is already removed. Assuming its files are removed, too.");
        }
        String sql = "DELETE FROM prg_attachment WHERE cid=? AND id=?";
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("DELETE FROM prg_attachment WHERE cid=? AND id=?");
            ps.setInt(1, cid);
            ps.setInt(2, id);
            ps.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(null, ps);
        }
    }
}

