/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks.mapping;

import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Priority
implements Mapper<Integer> {
    public static final Priority SINGLETON = new Priority();

    private Priority() {
    }

    @Override
    public int getId() {
        return 309;
    }

    @Override
    public boolean isSet(Task task) {
        return task.containsPriority();
    }

    @Override
    public String getDBColumnName() {
        return "priority";
    }

    @Override
    public String getDisplayName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toDB(PreparedStatement stmt, int pos, Task task) throws SQLException {
        if (null == task.getPriority()) {
            stmt.setNull(pos, 4);
        } else {
            stmt.setInt(pos, Autoboxing.i((Integer)task.getPriority()));
        }
    }

    @Override
    public void fromDB(ResultSet result, int pos, Task task) throws SQLException {
        int priority = result.getInt(pos);
        if (!result.wasNull()) {
            task.setPriority(Autoboxing.I((int)priority));
        }
    }

    @Override
    public boolean equals(Task task1, Task task2) {
        Integer prio1 = task1.getPriority();
        Integer prio2 = task2.getPriority();
        if (null == prio1) {
            return null == prio2;
        }
        if (null == prio2) {
            return false;
        }
        return prio1.intValue() == prio2.intValue();
    }

    @Override
    public Integer get(Task task) {
        return task.getPriority();
    }

    @Override
    public void set(Task task, Integer value) {
        task.setPriority(value);
    }
}

