/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.internal;

import com.openexchange.api2.ReminderService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.session.Session;

public class RemindAgain {
    private final Session session;
    private final Context ctx;
    private final ReminderObject reminder;
    private final ReminderService reminderService;

    public RemindAgain(ReminderObject reminder, Session session, Context ctx, ReminderService reminderService) {
        this.session = session;
        this.ctx = ctx;
        this.reminder = reminder;
        this.reminderService = reminderService;
    }

    public void remindAgain() throws OXException {
        int module = this.reminder.getModule();
        if (1 == module) {
            throw ReminderExceptionCode.UNEXPECTED_ERROR.create("Operation not supported for module calendar.");
        }
        if (4 != module) {
            throw ReminderExceptionCode.UNEXPECTED_ERROR.create("Unknown module: " + module);
        }
        this.remindAgainTask();
    }

    private void remindAgainTask() throws OXException {
        int taskId = this.reminder.getTargetId();
        int userId = this.reminder.getUser();
        if (null == this.reminder.getDate()) {
            if (this.reminderService.existsReminder(taskId, userId, 4)) {
                this.reminderService.deleteReminder(taskId, userId, 4);
            }
        } else if (this.reminderService.existsReminder(taskId, userId, 4)) {
            this.reminderService.updateReminder(this.reminder);
        } else {
            this.reminderService.insertReminder(this.reminder);
        }
        ReminderObject updated = this.reminderService.loadReminder(this.reminder.getObjectId());
        this.reminder.setDate(updated.getDate());
        this.reminder.setDescription(updated.getDescription());
        this.reminder.setFolder(updated.getFolder());
        this.reminder.setLastModified(updated.getLastModified());
        this.reminder.setModule(updated.getModule());
        this.reminder.setObjectId(updated.getObjectId());
        this.reminder.setRecurrenceAppointment(updated.isRecurrenceAppointment());
        this.reminder.setRecurrencePosition(updated.getRecurrencePosition());
        this.reminder.setTargetId(updated.getTargetId());
        this.reminder.setUser(updated.getUser());
    }
}

