/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder;

import com.openexchange.groupware.reminder.ReminderConfig;
import com.openexchange.groupware.reminder.ReminderEvent;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.TimerService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReminderPool
implements Runnable {
    private static final Map<String, ReminderEvent> register = new HashMap<String, ReminderEvent>();
    private static final Set<ReminderObject> pool = new HashSet<ReminderObject>();
    private static final Logger LOG = LoggerFactory.getLogger(ReminderPool.class);

    public ReminderPool(ReminderConfig reminderConfig) {
        if (reminderConfig.isReminderEnabled()) {
            LOG.info("Starting ReminderPool");
            TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
            if (timer != null) {
                timer.schedule((Runnable)this, (long)reminderConfig.getReminderInterval());
            }
        } else {
            LOG.info("ReminderPool is disabled");
        }
    }

    @Override
    public void run() {
    }

    public static void addReminderEvent(ReminderEvent reminderevent, int module) {
        register.put(String.valueOf(module), reminderevent);
    }

    public static void add(ReminderObject reminderobject) {
        pool.add(reminderobject);
    }

    public static void remove(ReminderObject reminderobject) {
        pool.remove(reminderobject);
    }
}

