/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify;

import com.openexchange.ajax.Attachment;
import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.data.conversion.ical.ICalEmitter;
import com.openexchange.data.conversion.ical.ICalSession;
import com.openexchange.data.conversion.ical.SimpleMode;
import com.openexchange.data.conversion.ical.ZoneInfo;
import com.openexchange.data.conversion.ical.itip.ITipContainer;
import com.openexchange.data.conversion.ical.itip.ITipMethod;
import com.openexchange.event.impl.AppointmentEventInterface2;
import com.openexchange.event.impl.TaskEventInterface2;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.container.mail.MailObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.notify.EmailableParticipant;
import com.openexchange.groupware.notify.NotificationConfig;
import com.openexchange.groupware.notify.NotificationPool;
import com.openexchange.groupware.notify.PooledNotification;
import com.openexchange.groupware.notify.State;
import com.openexchange.groupware.notify.TaskState;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.userconfiguration.CapabilityUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.i18n.tools.RenderMap;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.i18n.tools.StringTemplate;
import com.openexchange.i18n.tools.Template;
import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.i18n.tools.TemplateToken;
import com.openexchange.i18n.tools.replacement.AppointmentActionReplacement;
import com.openexchange.i18n.tools.replacement.ChangeExceptionsReplacement;
import com.openexchange.i18n.tools.replacement.CommentsReplacement;
import com.openexchange.i18n.tools.replacement.ConfirmationActionReplacement;
import com.openexchange.i18n.tools.replacement.CreationDateReplacement;
import com.openexchange.i18n.tools.replacement.DeleteExceptionsReplacement;
import com.openexchange.i18n.tools.replacement.EndDateReplacement;
import com.openexchange.i18n.tools.replacement.FolderReplacement;
import com.openexchange.i18n.tools.replacement.FormatLocalizedStringReplacement;
import com.openexchange.i18n.tools.replacement.ParticipantsReplacement;
import com.openexchange.i18n.tools.replacement.ResourcesReplacement;
import com.openexchange.i18n.tools.replacement.SeriesReplacement;
import com.openexchange.i18n.tools.replacement.StartDateReplacement;
import com.openexchange.i18n.tools.replacement.StringReplacement;
import com.openexchange.i18n.tools.replacement.TaskActionReplacement;
import com.openexchange.i18n.tools.replacement.TaskPriorityReplacement;
import com.openexchange.i18n.tools.replacement.TaskStatusReplacement;
import com.openexchange.java.Charsets;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.resource.Resource;
import com.openexchange.resource.storage.ResourceStorage;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticipantNotify
implements AppointmentEventInterface2,
TaskEventInterface2 {
    private static final String STR_UNKNOWN = "UNKNOWN";
    private static final Logger LOG = LoggerFactory.getLogger(ParticipantNotify.class);
    public static ParticipantNotify messageSender = new ParticipantNotify();
    private static final Pattern PATTERN_PREFIX_MODIFIED = Pattern.compile("(^|\r?\n)" + Pattern.quote("* "));
    private static final Pattern P_TRIM = Pattern.compile("[a-zA-Z-_]+:\r?\n");

    protected static void sendMessage(MailMessage mmsg, ServerSession session, CalendarObject obj, State state) {
        messageSender.sendMessage(mmsg, session, obj, state, false);
    }

    protected void sendMessage(MailMessage msg, ServerSession session, CalendarObject obj, State state, boolean suppressOXReminderHeader) {
        String fromAddr;
        int fuid;
        if (LOG.isDebugEnabled()) {
            String message;
            if (Multipart.class.isInstance(msg.message)) {
                try {
                    Object content = ((Multipart)msg.message).getBodyPart(0).getContent();
                    String appendix = "\n\n(With ICal attached)";
                    if (Multipart.class.isInstance(content)) {
                        content = ((Multipart)content).getBodyPart(0).getContent();
                        appendix = appendix + "\n(With file attachments)";
                    }
                    message = content.toString() + appendix;
                }
                catch (Exception e) {
                    message = "";
                }
            } else {
                message = msg.message.toString();
            }
            LOG.debug("Sending message to: {}\n=====[{}]====\n\n{}\n\n", new Object[]{msg.addresses, msg.title, message});
        }
        if ((fuid = msg.folderId) == -1) {
            fuid = obj.getParentFolderID();
        }
        if (suppressOXReminderHeader) {
            fuid = -2;
        }
        String type = msg.overrideType != null ? msg.overrideType.toString() : state.getType().toString();
        MailObject mail = new MailObject(session, obj.getObjectID(), fuid, state.getModule(), type);
        User sender = session.getUser();
        String senderSource = NotificationConfig.getProperty(NotificationConfig.NotificationProperty.FROM_SOURCE, "primaryMail");
        if (senderSource.equals("defaultSenderAddress")) {
            try {
                fromAddr = this.getUserSettingMail(session.getUserId(), session.getContext()).getSendAddr();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                fromAddr = sender.getMail();
            }
        } else {
            fromAddr = sender.getMail();
        }
        if (sender == null) {
            mail.setFromAddr(fromAddr);
        } else {
            QuotedInternetAddress addr = new QuotedInternetAddress();
            addr.setAddress(fromAddr);
            try {
                addr.setPersonal(sender.getDisplayName(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            mail.setFromAddr(addr.toString());
        }
        mail.setToAddrs(msg.addresses.toArray(new String[msg.addresses.size()]));
        mail.setText(msg.message);
        mail.setSubject(msg.title);
        if (Multipart.class.isInstance(msg.message)) {
            mail.setContentType(((Multipart)msg.message).getContentType());
            mail.setInternalRecipient(false);
        } else {
            mail.setContentType("text/plain; charset=UTF-8");
        }
        if (state.getModule() == 4) {
            if (msg.internal) {
                state.modifyInternal(mail, obj, session);
            } else {
                state.modifyExternal(mail, obj, session);
            }
        }
        try {
            mail.send();
        }
        catch (OXException e) {
            ParticipantNotify.log(e);
        }
    }

    protected TIntSet loadAllUsersSet(Context ctx) throws OXException {
        int[] uids = UserStorage.getInstance().listAllUser(ctx);
        TIntHashSet allIds = new TIntHashSet(uids.length);
        for (int id : uids) {
            allIds.add(id);
        }
        return allIds;
    }

    protected User[] resolveUsers(Context ctx, int ... ids) throws OXException {
        User[] r = new User[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            r[i] = UserStorage.getInstance().getUser(ids[i], ctx);
        }
        return r;
    }

    protected Group[] resolveGroups(Context ctx, int ... ids) throws OXException {
        GroupStorage groups = GroupStorage.getInstance();
        Group[] r = new Group[ids.length];
        int i = 0;
        for (int id : ids) {
            r[i++] = groups.getGroup(id, ctx);
        }
        return r;
    }

    protected Resource[] resolveResources(Context ctx, int ... ids) throws OXException {
        ResourceStorage resources = ResourceStorage.getInstance();
        Resource[] r = new Resource[ids.length];
        int i = 0;
        for (int id : ids) {
            r[i++] = resources.getResource(id, ctx);
        }
        return r;
    }

    protected UserConfiguration getUserConfiguration(int id, int[] groups, Context context) throws SQLException, OXException {
        return CapabilityUserConfigurationStorage.loadUserConfiguration(id, groups, context);
    }

    protected UserSettingMail getUserSettingMail(int id, Context context) throws OXException {
        return UserSettingMailStorage.getInstance().loadUserSettingMail(id, context);
    }

    @Override
    public void appointmentCreated(Appointment appointmentObj, Session session) {
    }

    @Override
    public void appointmentModified(Appointment appointmentObj, Session session) {
    }

    @Override
    public void appointmentModified(Appointment oldAppointment, Appointment newAppointment, Session session) {
    }

    @Override
    public void appointmentAccepted(Appointment appointmentObj, Session session) {
    }

    @Override
    public void appointmentDeclined(Appointment appointmentObj, Session session) {
    }

    @Override
    public void appointmentTentativelyAccepted(Appointment appointmentObj, Session session) {
    }

    @Override
    public void appointmentWaiting(Appointment appointmentObj, Session session) {
    }

    @Override
    public void appointmentDeleted(Appointment appointmentObj, Session session) {
    }

    @Override
    public void taskCreated(Task taskObj, Session session) {
        this.sendNotification(null, taskObj, session, new TaskState(new TaskActionReplacement(0), "A new task was created by [created_by].\nYou can check this task in your tasks:\n[link]\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ", State.Type.NEW), false, false, false);
    }

    @Override
    public void taskModified(Task taskObj, Session session) {
        this.taskModified(null, taskObj, session);
    }

    @Override
    public void taskModified(Task oldTask, Task newTask, Session session) {
        this.sendNotification(oldTask, newTask, session, new TaskState(new TaskActionReplacement(1), "This task was changed by [changed_by].\nYou can check this task in your tasks:\n[link]\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n==========================================", State.Type.MODIFIED), false, false, true);
    }

    @Override
    public void taskAccepted(Task taskObj, Session session) {
        this.taskAccepted(null, taskObj, session);
    }

    @Override
    public void taskAccepted(Task oldTask, Task taskObj, Session session) {
        this.sendNotification(oldTask, taskObj, session, new TaskState(new TaskActionReplacement(3), new ConfirmationActionReplacement(0), "[changed_by] has [confirmation_action] this task.\nYou can check this task in your tasks:\n[link]\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n==========================================", State.Type.ACCEPTED), false, false, false);
    }

    @Override
    public void taskDeclined(Task taskObj, Session session) {
        this.taskDeclined(null, taskObj, session);
    }

    @Override
    public void taskDeclined(Task oldTask, Task taskObj, Session session) {
        this.sendNotification(oldTask, taskObj, session, new TaskState(new TaskActionReplacement(4), new ConfirmationActionReplacement(1), "[changed_by] has [confirmation_action] this task.\nYou can check this task in your tasks:\n[link]\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n==========================================", State.Type.DECLINED), false, false, false);
    }

    @Override
    public void taskTentativelyAccepted(Task taskObj, Session session) {
        this.taskTentativelyAccepted(null, taskObj, session);
    }

    @Override
    public void taskTentativelyAccepted(Task oldTask, Task taskObj, Session session) {
        this.sendNotification(oldTask, taskObj, session, new TaskState(new TaskActionReplacement(5), new ConfirmationActionReplacement(2), "[changed_by] has [confirmation_action] this task.\nYou can check this task in your tasks:\n[link]\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n==========================================", State.Type.TENTATIVELY_ACCEPTED), false, false, false);
    }

    @Override
    public void taskDeleted(Task taskObj, Session session) {
        NotificationPool.getInstance().removeByObject(taskObj.getObjectID(), session.getContextId());
        this.sendNotification(null, taskObj, session, new TaskState(new TaskActionReplacement(2), "This task was either deleted by [changed_by] or\nyou have been removed from the list of participants.\n\nTask\n====\nCreated by:  [created_by]\nCreated at:  [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ", State.Type.DELETED), NotificationConfig.getPropertyAsBoolean(NotificationConfig.NotificationProperty.NOTIFY_ON_DELETE, false), true, false);
    }

    private void sendNotification(CalendarObject oldObj, CalendarObject newObj, Session session, State state, boolean forceNotifyOthers, boolean suppressOXReminderHeader, boolean isUpdate) {
        String title;
        ServerSession serverSession;
        block27: {
            if (session.getUserId() <= 0 || session.getContextId() <= 0) {
                String sessionId = session.getSessionID();
                if (null != sessionId) {
                    ServerServiceRegistry.getInstance().getService(SessiondService.class).removeSession(sessionId);
                }
                return;
            }
            if (this.onlyIrrelevantFieldsChanged(session, oldObj, newObj, state)) {
                return;
            }
            try {
                serverSession = ServerSessionAdapter.valueOf(session);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                return;
            }
            String string = newObj.getTitle() == null ? (oldObj == null ? "" : (oldObj.getTitle() == null ? "" : oldObj.getTitle())) : (title = newObj.getTitle());
            if (newObj.containsNotification() && !newObj.getNotification() && newObj.getCreatedBy() == serverSession.getUserId() && !forceNotifyOthers) {
                LOG.debug("Dropping notification for {}{} ({}) since it indicates to discard its notification", new Object[]{state.getModule() == 1 ? "appointment " : "task ", title, newObj.getObjectID()});
                return;
            }
            if (newObj.getParticipants() == null) {
                if (oldObj == null || oldObj.getParticipants() == null) {
                    LOG.debug("Dropping notification for {}{} ({}) since it contains NO participants", new Object[]{state.getModule() == 1 ? "appointment " : "task ", title, newObj.getObjectID()});
                    return;
                }
                newObj.setParticipants(oldObj.getParticipants());
                newObj.setUsers(oldObj.getUsers());
            }
            if (newObj.getStartDate() == null && oldObj != null && oldObj.getStartDate() != null) {
                newObj.setStartDate(oldObj.getStartDate());
            }
            if (newObj.getEndDate() == null && oldObj != null && oldObj.getEndDate() != null) {
                newObj.setEndDate(oldObj.getEndDate());
            }
            if (0 == newObj.getRecurrenceType() && oldObj != null && 0 != oldObj.getRecurrenceType()) {
                newObj.setRecurrenceType(oldObj.getRecurrenceType());
                if (oldObj.containsOccurrence()) {
                    newObj.setOccurrence(oldObj.getOccurrence());
                }
                if (oldObj.containsInterval()) {
                    newObj.setInterval(oldObj.getInterval());
                }
                if (oldObj.containsDays()) {
                    newObj.setDays(oldObj.getDays());
                }
                if (oldObj.containsDayInMonth()) {
                    newObj.setDayInMonth(oldObj.getDayInMonth());
                }
                if (oldObj.containsUntil()) {
                    newObj.setUntil(oldObj.getUntil());
                }
            }
            if (!ParticipantNotify.checkStartAndEndDate(newObj, state.getModule())) {
                return;
            }
            if (!newObj.containsCreatedBy() && oldObj != null && oldObj.containsCreatedBy()) {
                newObj.setCreatedBy(oldObj.getCreatedBy());
            }
            if (!newObj.containsCreationDate() && oldObj != null && oldObj.containsCreationDate()) {
                newObj.setCreationDate(oldObj.getCreationDate());
            }
            if (1 == state.getModule()) {
                Appointment oldApp;
                Appointment newApp = (Appointment)newObj;
                Appointment appointment = oldApp = oldObj == null ? null : (Appointment)oldObj;
                if (!newApp.containsFullTime() && oldApp != null && oldApp.containsFullTime()) {
                    newApp.setFullTime(oldApp.getFullTime());
                }
                if (newApp.getRecurrenceType() != 0) {
                    try {
                        ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class, true).fillDAO((CalendarDataObject)newApp);
                        if (oldObj != null) {
                            ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class, true).fillDAO((CalendarDataObject)oldApp);
                        }
                    }
                    catch (Exception e) {
                        if (!(e instanceof OXException)) break block27;
                        StringBuilder builder = new StringBuilder(256).append("Could not set correct recurrence information in notification for appointment").append(title).append(" (").append(newObj.getObjectID()).append("). Cause:\n");
                        LOG.error("{}", (Object)builder, (Object)e);
                    }
                }
            }
        }
        HashMap<Locale, List<EmailableParticipant>> receivers = new HashMap<Locale, List<EmailableParticipant>>();
        RenderMap renderMap = this.createRenderMap(newObj, oldObj, isUpdate, title, state, receivers, serverSession);
        TemplateReplacement confirmActionRepl = state.getConfirmationAction();
        if (confirmActionRepl != null) {
            renderMap.put(confirmActionRepl);
        }
        List<MailMessage> messages = this.createMessageList(oldObj, newObj, state, forceNotifyOthers, isUpdate, serverSession, receivers, title, renderMap);
        for (MailMessage mmsg : messages) {
            this.sendMessage(mmsg, serverSession, newObj, state, suppressOXReminderHeader);
        }
    }

    private boolean onlyIrrelevantFieldsChanged(Session session, CalendarObject oldObj, CalendarObject newObj, State state) {
        if (oldObj == null || newObj == null) {
            return false;
        }
        return state.onlyIrrelevantFieldsChanged(oldObj, newObj);
    }

    private List<MailMessage> createMessageList(CalendarObject oldObj, CalendarObject newObj, State state, boolean forceNotifyOthers, boolean isUpdate, ServerSession session, Map<Locale, List<EmailableParticipant>> receivers, String title, RenderMap renderMap) {
        OXFolderAccess access = new OXFolderAccess(session.getContext());
        StringBuilder b = new StringBuilder(2048);
        TIntSet allUserIds = null;
        try {
            allUserIds = this.loadAllUsersSet(session.getContext());
        }
        catch (OXException e) {
            ParticipantNotify.log(e);
            return Collections.emptyList();
        }
        ArrayList<MailMessage> messages = new ArrayList<MailMessage>();
        for (Map.Entry<Locale, List<EmailableParticipant>> entry : receivers.entrySet()) {
            Locale locale = entry.getKey();
            TemplateReplacement actionRepl = state.getAction();
            actionRepl.setLocale(locale);
            renderMap.applyLocale(locale);
            List<EmailableParticipant> participants = entry.getValue();
            for (EmailableParticipant p : participants) {
                int folderId;
                TimeZone tz = TimeZone.getDefault();
                boolean sendMail = true;
                if (p.type != 5 && allUserIds.contains(p.id)) {
                    try {
                        sendMail = !p.ignoreNotification && state.sendMail(this.getUserSettingMail(p.id, session.getContext()), newObj.getCreatedBy(), p.id, session.getUserId()) && (!newObj.containsNotification() || newObj.getNotification() || forceNotifyOthers && p.id != session.getUserId());
                        tz = p.timeZone;
                    }
                    catch (OXException e) {
                        ParticipantNotify.log(e);
                    }
                } else {
                    sendMail = !p.ignoreNotification && (!newObj.containsNotification() || newObj.getNotification()) || newObj.getModifiedBy() != p.id && forceNotifyOthers;
                    boolean bl = sendMail = sendMail && (!ParticipantNotify.isStatusUpdate(state) || p.email.equals(newObj.getOrganizer()));
                    if (p.timeZone != null) {
                        tz = p.timeZone;
                    }
                }
                if (!sendMail) continue;
                renderMap.applyTimeZone(tz);
                int n = folderId = p.folderId > 0 ? p.folderId : newObj.getParentFolderID();
                if (folderId > 0) {
                    String folderName = this.getFolderName(folderId, locale, access);
                    FolderReplacement folderRepl = new FolderReplacement(folderName);
                    folderRepl.setLocale(locale);
                    if (oldObj != null) {
                        if (p.folderId > 0) {
                            this.checkChangedFolder(oldObj, p.email, folderId, folderRepl, session);
                        } else {
                            folderRepl.setChanged(newObj.getParentFolderID() != oldObj.getParentFolderID());
                        }
                    }
                    renderMap.put(folderRepl);
                }
                state.addSpecial(newObj, oldObj, renderMap, p);
                if (isUpdate && 0 == p.state) {
                    NotificationPool.getInstance().put(new PooledNotification(p, title, state, locale, (RenderMap)renderMap.clone(), session, newObj));
                    LOG.debug("{} update (id = {}) notification added to pool for receiver {}", new Object[]{1 == state.getModule() ? "Appointment" : "Task", newObj.getObjectID(), p.email});
                    continue;
                }
                MailMessage message = null;
                message = 1 == p.type ? ParticipantNotify.createUserMessage(session, newObj, p, ParticipantNotify.userCanReadObject(p, newObj, session), title, actionRepl, state, locale, renderMap, isUpdate, b) : ParticipantNotify.createParticipantMessage(session, newObj, p, title, actionRepl, state, locale, renderMap, isUpdate, b);
                if (null == message) continue;
                messages.add(message);
                LOG.debug("{} (id = {}) \"{}\" notification message generated for receiver {}", new Object[]{1 == state.getModule() ? "Appointment" : "Task", newObj.getObjectID(), 1 == p.state ? "New" : (-1 == p.state ? "Deleted" : state.getType().toString()), p.email});
            }
        }
        return messages;
    }

    public static boolean userCanReadObject(EmailableParticipant participant, CalendarObject obj, ServerSession session) {
        try {
            UserConfiguration userConfig = UserConfigurationStorage.getInstance().getUserConfiguration(participant.id, session.getContext());
            OXFolderAccess oxfa = new OXFolderAccess(session.getContext());
            if (oxfa.getFolderType(obj.getParentFolderID()) == 1) {
                return true;
            }
            EffectivePermission permission = oxfa.getFolderPermission(obj.getParentFolderID(), participant.id, userConfig);
            if (permission.canReadAllObjects()) {
                return true;
            }
            if (permission.canReadOwnObjects() && obj.getCreatedBy() == participant.id) {
                return true;
            }
        }
        catch (OXException e) {
            ParticipantNotify.log(e);
        }
        return false;
    }

    protected String getFolderName(int folderId, Locale locale, OXFolderAccess access) {
        String folderName = FolderObject.getFolderString(folderId, locale);
        if (folderName == null) {
            try {
                folderName = access.getFolderName(folderId);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                folderName = "";
            }
        }
        return folderName;
    }

    protected static MailMessage createUserMessage(ServerSession session, CalendarObject cal, EmailableParticipant p, boolean canRead, String title, TemplateReplacement actionRepl, State state, Locale locale, RenderMap renderMap, boolean isUpdate, StringBuilder b) {
        return ParticipantNotify.createParticipantMessage0(session, cal, p, canRead, title, actionRepl, state, locale, renderMap, isUpdate, b);
    }

    protected static MailMessage createParticipantMessage(ServerSession session, CalendarObject cal, EmailableParticipant p, String title, TemplateReplacement actionRepl, State state, Locale locale, RenderMap renderMap, boolean isUpdate, StringBuilder b) {
        return ParticipantNotify.createParticipantMessage0(session, cal, p, true, title, actionRepl, state, locale, renderMap, isUpdate, b);
    }

    private static MailMessage createParticipantMessage0(ServerSession session, CalendarObject cal, EmailableParticipant p, boolean canRead, String title, TemplateReplacement actionRepl, State state, Locale locale, RenderMap renderMap, boolean isUpdate, StringBuilder b) {
        MailMessage msg = new MailMessage();
        Template createTemplate = state.getTemplate();
        StringHelper strings = StringHelper.valueOf(locale);
        b.setLength(0);
        actionRepl.setLocale(locale);
        msg.title = b.append(actionRepl.getReplacement()).append(": ").append(title).toString();
        b.setLength(0);
        if (isUpdate) {
            if (-1 == p.state) {
                msg.overrideType = State.Type.DELETED;
                RenderMap clone = ParticipantNotify.clonedRenderMap(renderMap);
                if (1 == state.getModule()) {
                    msg.title = b.append(new AppointmentActionReplacement(2, locale).getReplacement()).append(": ").append(title).toString();
                    b.setLength(0);
                    msg.message = new StringTemplate("This appointment does not take place.\nIt was either deleted by [changed_by] or\nyou have been removed from the list of participants.\n\nAppointment\n===========\nCreated by:  [created_by]\nCreated at:  [creation_datetime]\n[title]\n[location][folder_name]\n\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n==========================================").render(p.getLocale(), clone);
                } else {
                    msg.title = b.append(new TaskActionReplacement(2, locale).getReplacement()).append(": ").append(title).toString();
                    b.setLength(0);
                    msg.message = new StringTemplate("This task was either deleted by [changed_by] or\nyou have been removed from the list of participants.\n\nTask\n====\nCreated by:  [created_by]\nCreated at:  [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ").render(p.getLocale(), clone);
                }
            } else if (1 == p.state) {
                msg.overrideType = State.Type.NEW;
                RenderMap clone = ParticipantNotify.clonedRenderMap(renderMap);
                if (1 == state.getModule()) {
                    msg.title = b.append(new AppointmentActionReplacement(0, locale).getReplacement()).append(": ").append(title).toString();
                    b.setLength(0);
                    String message = ParticipantNotify.getAppointmentCreateTemplate(p, canRead, cal, session);
                    String textMessage = new StringTemplate(message).render(p.getLocale(), clone);
                    msg.message = p.type == 1 && !NotificationConfig.getPropertyAsBoolean(NotificationConfig.NotificationProperty.INTERNAL_IMIP, false) ? textMessage : ParticipantNotify.generateMessageMultipart(session, cal, textMessage, state.getModule(), state.getType(), ITipMethod.REQUEST, p, strings, b);
                } else {
                    msg.title = b.append(new TaskActionReplacement(0, locale).getReplacement()).append(": ").append(title).toString();
                    b.setLength(0);
                    String message = ParticipantNotify.getTaskCreateMessage(p, canRead);
                    msg.message = new StringTemplate(message).render(p.getLocale(), clone);
                }
            } else {
                List<TemplateReplacement> changes = renderMap.getChanges();
                if (changes.isEmpty()) {
                    return null;
                }
                boolean relevantChanges = false;
                for (TemplateReplacement templateReplacement : changes) {
                    if (!templateReplacement.relevantChange()) continue;
                    relevantChanges = true;
                    break;
                }
                if (!relevantChanges) {
                    return null;
                }
                String textMessage = "";
                if (p.type == 5 || p.type == 3) {
                    String template = 1 == state.getModule() ? "This appointment was changed by [changed_by].\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location][folder_name]\n\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n==========================================" : "This task was changed by [changed_by].\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n==========================================";
                    textMessage = new StringTemplate(template).render(p.getLocale(), renderMap);
                } else if (!canRead) {
                    String template = state.getModule() == 1 ? "This appointment was changed by [changed_by].\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location][folder_name]\n\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n==========================================" : "This task was changed by [changed_by].\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n==========================================";
                    textMessage = new StringTemplate(template).render(p.getLocale(), renderMap);
                } else {
                    textMessage = createTemplate.render(p.getLocale(), renderMap);
                }
                if (!PATTERN_PREFIX_MODIFIED.matcher(textMessage).find()) {
                    return null;
                }
                msg.message = cal.getRecurrenceType() == 0 && p.type == 5 ? ParticipantNotify.generateMessageMultipart(session, cal, textMessage, state.getModule(), state.getType(), ITipMethod.REQUEST, p, strings, b) : textMessage;
            }
        } else if (State.Type.NEW.equals((Object)state.getType())) {
            int owner = ParticipantNotify.getFolderOwner(cal, session);
            boolean isOnBehalf = owner != session.getUserId();
            String textMessage = "";
            if (p.type == 5 || p.type == 3) {
                String template = strings.getString(1 == state.getModule() ? (isOnBehalf ? "A new appointment was created by [created_by] on behalf of [behalf_of].\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location]\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== " : "A new appointment was created by [created_by].\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location]\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ") : "A new task was created by [created_by].\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ");
                textMessage = new StringTemplate(template).render(p.getLocale(), renderMap);
            } else if (!canRead) {
                String template = strings.getString(state.getModule() == 1 ? (isOnBehalf ? "A new appointment was created by [created_by] on behalf of [behalf_of].\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location]\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== " : "A new appointment was created by [created_by].\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location]\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ") : "A new task was created by [created_by].\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ");
                textMessage = new StringTemplate(template).render(p.getLocale(), renderMap);
            } else {
                textMessage = createTemplate.render(p.getLocale(), renderMap);
            }
            msg.message = p.type == 1 && !NotificationConfig.getPropertyAsBoolean(NotificationConfig.NotificationProperty.INTERNAL_IMIP, false) ? textMessage : ParticipantNotify.generateMessageMultipart(session, cal, textMessage, state.getModule(), state.getType(), ITipMethod.REQUEST, p, strings, b);
        } else if (ParticipantNotify.isStatusUpdate(state)) {
            String textMessage = "";
            if (p.type == 5 || p.type == 3) {
                String template = strings.getString(1 == state.getModule() ? "[changed_by] has [confirmation_action] this appointment.\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location][folder_name]\n\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n==========================================" : "[changed_by] has [confirmation_action] this task.\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n==========================================");
                textMessage = new StringTemplate(template).render(p.getLocale(), renderMap);
            } else {
                textMessage = createTemplate.render(p.getLocale(), renderMap);
            }
            msg.message = p.type == 5 ? ParticipantNotify.generateMessageMultipart(session, cal, textMessage, state.getModule(), state.getType(), ITipMethod.REPLY, p, strings, b) : textMessage;
        } else {
            msg.message = state.getType() == State.Type.DELETED ? (p.type == 1 && !NotificationConfig.getPropertyAsBoolean(NotificationConfig.NotificationProperty.INTERNAL_IMIP, false) ? createTemplate.render(p.getLocale(), renderMap) : ParticipantNotify.generateMessageMultipart(session, cal, createTemplate.render(p.getLocale(), renderMap), state.getModule(), state.getType(), ITipMethod.CANCEL, p, strings, b)) : createTemplate.render(p.getLocale(), renderMap);
        }
        if (3 == p.type) {
            Object content = msg.message;
            if (content instanceof String) {
                msg.message = b.append(String.format(strings.getString("Mail to resource %1$s"), p.displayName)).append(": ").append(content).toString();
                b.setLength(0);
            }
            msg.title = b.append('[').append(strings.getString("Resource")).append("] ").append(msg.title).toString();
            b.setLength(0);
        }
        msg.addresses.add(p.email);
        msg.folderId = p.folderId;
        msg.internal = p.type != 5;
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object generateMessageMultipart(ServerSession session, CalendarObject cal, String text, int module, State.Type type, ITipMethod method, EmailableParticipant p, StringHelper strings, StringBuilder b) {
        if (module == 4) {
            return text;
        }
        try {
            String fileName;
            MimeMultipart mixedMultipart;
            Appointment app;
            block37: {
                app = (Appointment)cal;
                mixedMultipart = null;
                try {
                    AttachmentBase attachmentBase = Attachment.ATTACHMENT_BASE;
                    int folderId = app.getParentFolderID();
                    int objectId = app.getObjectID();
                    Context context = session.getContext();
                    User user = session.getUser();
                    UserConfiguration config = session.getUserConfiguration();
                    SearchIterator iterator = attachmentBase.getAttachments(session, folderId, objectId, 1, context, user, config).results();
                    if (!iterator.hasNext()) break block37;
                    try {
                        attachmentBase.startTransaction();
                        mixedMultipart = new MimeMultipart("mixed");
                        do {
                            AttachmentMetadata metadata = (AttachmentMetadata)iterator.next();
                            MimeBodyPart bodyPart = new MimeBodyPart();
                            String mimeType = metadata.getFileMIMEType();
                            if (null == mimeType) {
                                mimeType = "application/octet-stream";
                            }
                            ContentType ct = new ContentType(mimeType);
                            bodyPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(attachmentBase.getAttachedFile(session, folderId, objectId, 1, metadata.getId(), context, user, config), ct)));
                            String fileName2 = metadata.getFilename();
                            if (fileName2 != null && !ct.containsNameParameter()) {
                                ct.setNameParameter(fileName2);
                            }
                            bodyPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(ct.toString()));
                            bodyPart.setHeader(MessageHeaders.HDR_MIME_VERSION, "1.0");
                            if (fileName2 != null) {
                                ContentDisposition cd = new ContentDisposition("attachment");
                                cd.setFilenameParameter(fileName2);
                                bodyPart.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(cd.toString()));
                            }
                            bodyPart.setHeader(MessageHeaders.HDR_CONTENT_TRANSFER_ENC, "base64");
                            LOG.debug("Added file attachment to notification message: {}", (Object)fileName2);
                            mixedMultipart.addBodyPart((BodyPart)bodyPart);
                        } while (iterator.hasNext());
                        attachmentBase.commit();
                    }
                    catch (Exception e) {
                        try {
                            attachmentBase.rollback();
                        }
                        catch (OXException e1) {
                            LOG.error("Attachment transaction rollback failed", (Throwable)e1);
                        }
                        LOG.error("File attachment(s) cannot be added.", (Throwable)e);
                    }
                    finally {
                        SearchIterators.close((SearchIterator)iterator);
                        try {
                            attachmentBase.finish();
                        }
                        catch (OXException e) {
                            LOG.debug("Attachment transaction finish failed", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("File attachment(s) cannot be added.", (Throwable)e);
                }
            }
            MimeMultipart alternativeMultipart = new MimeMultipart("alternative");
            MimeBodyPart textPart = new MimeBodyPart();
            if (3 == p.type) {
                try {
                    textPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(b.append(String.format(strings.getString("Mail to resource %1$s"), p.displayName)).append(": ").append(text).toString(), "text/plain; charset=UTF-8")));
                    textPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, "text/plain; charset=UTF-8");
                    b.setLength(0);
                }
                catch (UnsupportedEncodingException e) {
                    throw new MessagingException("Unsupported encoding.", (Exception)e);
                }
            }
            try {
                textPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(text, "text/plain; charset=UTF-8")));
                textPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, "text/plain; charset=UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException("Unsupported encoding.", (Exception)e);
            }
            ICalEmitter emitter = ServerServiceRegistry.getInstance().getService(ICalEmitter.class);
            ICalSession icalSession = emitter.createSession(new SimpleMode(ZoneInfo.OUTLOOK));
            Date until = null;
            if (0 != app.getRecurrenceType()) {
                until = app.getEndDate();
                app.setEndDate(ParticipantNotify.computeFirstOccurrenceEnd(app));
            }
            boolean hasAlarm = app.containsAlarm();
            int alarm = app.getAlarm();
            app.removeAlarm();
            ITipContainer iTip = new ITipContainer(method, type, session.getUserId());
            emitter.writeAppointment(icalSession, app, session.getContext(), iTip, new LinkedList<ConversionError>(), new LinkedList<ConversionWarning>());
            if (null != until) {
                app.setEndDate(until);
            }
            if (hasAlarm) {
                app.setAlarm(alarm);
            }
            UnsynchronizedByteArrayOutputStream byteArrayOutputStream = new UnsynchronizedByteArrayOutputStream();
            emitter.writeSession(icalSession, (OutputStream)byteArrayOutputStream);
            byte[] icalFile = ParticipantNotify.trimICal(byteArrayOutputStream.toByteArray());
            boolean isAscii = ParticipantNotify.isAscii(icalFile);
            if (null == mixedMultipart) {
                mixedMultipart = new MimeMultipart("mixed");
            }
            MimeBodyPart iCalAttachmentPart = new MimeBodyPart();
            switch (method) {
                case REQUEST: {
                    fileName = "invite.ics";
                    break;
                }
                case CANCEL: {
                    fileName = "cancel.ics";
                    break;
                }
                default: {
                    fileName = "response.ics";
                }
            }
            b.append("application/ics; name=\"").append(fileName).append('\"');
            String ct = b.toString();
            b.setLength(0);
            iCalAttachmentPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(icalFile, ct)));
            iCalAttachmentPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(ct));
            b.append("attachment; filename=\"").append(fileName).append('\"');
            iCalAttachmentPart.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, b.toString());
            b.setLength(0);
            iCalAttachmentPart.setHeader(MessageHeaders.HDR_CONTENT_TRANSFER_ENC, "base64");
            mixedMultipart.addBodyPart((BodyPart)iCalAttachmentPart, 0);
            MimeBodyPart iCalPart = new MimeBodyPart();
            String contentType = b.append("text/calendar; charset=UTF-8; ").append(method.getMethod()).toString();
            b.setLength(0);
            iCalPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(icalFile, contentType)));
            iCalPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(contentType));
            iCalPart.setHeader(MessageHeaders.HDR_CONTENT_TRANSFER_ENC, isAscii ? "7bit" : "quoted-printable");
            alternativeMultipart.addBodyPart((BodyPart)textPart);
            alternativeMultipart.addBodyPart((BodyPart)iCalPart);
            MimeBodyPart altBodyPart = new MimeBodyPart();
            MessageUtility.setContent((Multipart)alternativeMultipart, (Part)altBodyPart);
            mixedMultipart.addBodyPart((BodyPart)altBodyPart, 0);
            return mixedMultipart;
        }
        catch (MessagingException e) {
            LOG.error("Unable to compose message", (Throwable)e);
        }
        catch (ConversionError e) {
            LOG.error("Unable to compose message", (Throwable)((Object)e));
        }
        catch (OXException e) {
            LOG.error("Unable to compose message", (Throwable)e);
        }
        return text;
    }

    private static byte[] trimICal(byte[] icalBytes) {
        return P_TRIM.matcher(new String(icalBytes, Charsets.UTF_8)).replaceAll("").getBytes(Charsets.UTF_8);
    }

    private static boolean isAscii(byte[] bytes) {
        boolean isAscci = true;
        for (int i = 0; isAscci && i < bytes.length; ++i) {
            isAscci = bytes[i] >= 0;
        }
        return isAscci;
    }

    private static String getTaskCreateMessage(EmailableParticipant p, boolean canRead) {
        if (p.type == 5 || p.type == 3) {
            return "A new task was created by [created_by].\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ";
        }
        if (!canRead) {
            return "A new task was created by [created_by].\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ";
        }
        return "A new task was created by [created_by].\nYou can check this task in your tasks:\n[link]\n\nTask\n====\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[folder_name]\n[priority]\n[task_status]\n\n[start]\n[end]\n[series]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ";
    }

    private static String getAppointmentCreateTemplate(EmailableParticipant p, boolean canRead, CalendarObject cal, ServerSession session) {
        int folderOwner = ParticipantNotify.getFolderOwner(cal, session);
        if (p.type == 5 || p.type == 3) {
            if (folderOwner == session.getUserId()) {
                return "A new appointment was created by [created_by].\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location]\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ";
            }
            return "A new appointment was created by [created_by] on behalf of [behalf_of].\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location]\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ";
        }
        if (!canRead) {
            if (folderOwner == session.getUserId()) {
                return "A new appointment was created by [created_by].\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location]\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ";
            }
            return "A new appointment was created by [created_by] on behalf of [behalf_of].\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location]\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ";
        }
        if (folderOwner == session.getUserId()) {
            return "A new appointment was created by [created_by].\nYou can check this appointment in your calendar:\n[link]\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location][folder_name]\n\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ";
        }
        return "A new appointment was created by [created_by] on behalf of [behalf_of].\nYou can check this appointment in your calendar:\n[link]\n\nAppointment\n===========\nCreated by: [created_by]\nCreated at: [creation_datetime]\n[title]\n[location][folder_name]\n\n[start]\n[end]\n[series][delete_exceptions][change_exceptions]\n[description]\nParticipants\n============\n[participants]\n\nResources\n=========\n[resources]\n\n========================================== ";
    }

    private static int getFolderOwner(CalendarObject cal, ServerSession session) {
        OXFolderAccess oxfa = new OXFolderAccess(session.getContext());
        try {
            return oxfa.getFolderOwner(cal.getParentFolderID());
        }
        catch (OXException e) {
            ParticipantNotify.log(e);
            return session.getUserId();
        }
    }

    private RenderMap createRenderMap(CalendarObject newObj, CalendarObject oldObj, boolean isUpdate, String title, State state, Map<Locale, List<EmailableParticipant>> receivers, ServerSession session) {
        ChangeExceptionsReplacement changeExceptionsReplacement;
        DeleteExceptionsReplacement deleteExceptionsReplacement;
        SeriesReplacement seriesRepl;
        boolean endChanged;
        int module = state.getModule();
        TreeSet<EmailableParticipant> participantSet = new TreeSet<EmailableParticipant>();
        TreeSet<EmailableParticipant> resourceSet = new TreeSet<EmailableParticipant>();
        HashMap<String, EmailableParticipant> all = new HashMap<String, EmailableParticipant>();
        UserParticipant[] users = newObj.getUsers();
        if (null == users) {
            Participant[] oldParticipants = new Participant[]{};
            if (oldObj != null) {
                oldParticipants = oldObj.getParticipants();
            }
            this.sortParticipants(oldParticipants, newObj.getParticipants(), participantSet, resourceSet, receivers, session, all);
        } else {
            UserParticipant[] oldUsers = new UserParticipant[]{};
            if (oldObj != null) {
                oldUsers = oldObj.getUsers();
            }
            Participant[] oldParticipants = new Participant[]{};
            if (oldObj != null) {
                oldParticipants = oldObj.getParticipants();
            }
            this.sortUserParticipants(oldUsers, newObj.getUsers(), participantSet, isUpdate, receivers, session, all);
            this.sortExternalParticipantsAndResources(oldParticipants, newObj.getParticipants(), participantSet, resourceSet, isUpdate, receivers, session, all, newObj.getOrganizer(), state);
        }
        if (newObj instanceof Task) {
            this.addTaskOwner(oldObj, newObj, receivers, all, session);
        }
        RenderMap renderMap = new RenderMap();
        renderMap.put(new FormatLocalizedStringReplacement(TemplateToken.TITLE, "Description: %1$s", title).setChanged(isUpdate ? (oldObj == null ? false : !ParticipantNotify.compareObjects(title, oldObj.getTitle())) : false));
        renderMap.put(new ParticipantsReplacement(participantSet).setChanged(isUpdate));
        renderMap.put(new ResourcesReplacement(resourceSet).setChanged(isUpdate));
        String createdByDisplayName = STR_UNKNOWN;
        Context ctx = session.getContext();
        if (0 != newObj.getCreatedBy()) {
            try {
                createdByDisplayName = this.resolveUsers(ctx, newObj.getCreatedBy())[0].getDisplayName();
            }
            catch (OXException e) {
                createdByDisplayName = STR_UNKNOWN;
                ParticipantNotify.log(e);
            }
        }
        String modifiedByDisplayName = STR_UNKNOWN;
        try {
            modifiedByDisplayName = this.resolveUsers(ctx, session.getUserId())[0].getDisplayName();
        }
        catch (OXException e) {
            modifiedByDisplayName = STR_UNKNOWN;
            ParticipantNotify.log(e);
        }
        String onBehalfDisplayName = STR_UNKNOWN;
        OXFolderAccess oxfa = new OXFolderAccess(session.getContext());
        try {
            onBehalfDisplayName = this.resolveUsers(ctx, oxfa.getFolderOwner(newObj.getParentFolderID()))[0].getDisplayName();
        }
        catch (OXException e) {
            ParticipantNotify.log(e);
        }
        renderMap.put(new StringReplacement(TemplateToken.CREATED_BY, createdByDisplayName));
        renderMap.put(new StringReplacement(TemplateToken.CHANGED_BY, modifiedByDisplayName));
        renderMap.put(new StringReplacement(TemplateToken.BEHALF_OF, onBehalfDisplayName));
        String note = null == newObj.getNote() ? "" : newObj.getNote();
        renderMap.put(new CommentsReplacement(note).setChanged(isUpdate ? (oldObj == null ? false : !ParticipantNotify.compareStrings(note, oldObj.getNote())) : false));
        if (4 == module) {
            Integer oldPriority;
            Task task = (Task)newObj;
            Task oldTask = (Task)oldObj;
            Integer priority = task.getPriority();
            Integer n = oldPriority = oldTask == null ? null : oldTask.getPriority();
            if (null != priority) {
                TaskPriorityReplacement replacement = new TaskPriorityReplacement(priority);
                renderMap.put(replacement);
                replacement.setChanged(oldTask == null ? false : !priority.equals(oldPriority));
            } else {
                renderMap.put(TaskPriorityReplacement.emptyTaskPriorityReplacement());
            }
            int status = task.getStatus();
            int percentComplete = task.getPercentComplete();
            boolean changed = false;
            if (status != 0 && oldTask != null) {
                changed |= status != oldTask.getStatus();
                changed |= percentComplete != oldTask.getPercentComplete();
            }
            try {
                renderMap.put(new TaskStatusReplacement(status, percentComplete).setChanged(changed));
            }
            catch (IllegalArgumentException e) {
                renderMap.put(TaskStatusReplacement.emptyTaskStatusReplacement());
            }
        }
        boolean isTask = 4 == module;
        boolean isFulltime = isTask ? true : ((Appointment)newObj).getFullTime();
        Date start = newObj.getStartDate();
        renderMap.put(new StartDateReplacement(start, isFulltime).setChanged(isUpdate ? (oldObj == null ? false : !ParticipantNotify.compareObjects(start, oldObj.getStartDate())) : false));
        Date end = newObj.getEndDate();
        boolean bl = isUpdate ? (oldObj == null ? false : !ParticipantNotify.compareObjects(end, oldObj.getEndDate())) : (endChanged = false);
        if (newObj.getRecurrenceType() != 0 && start != null && end != null) {
            end = ParticipantNotify.computeFirstOccurrenceEnd(start.getTime(), end.getTime());
        }
        renderMap.put(new EndDateReplacement(end, isFulltime, isTask).setChanged(endChanged));
        renderMap.put(new CreationDateReplacement((Date)(newObj.containsCreationDate() ? newObj.getCreationDate() : (oldObj == null ? null : oldObj.getCreationDate())), null));
        if (newObj.containsRecurrenceType() || newObj.getRecurrenceType() != 0) {
            seriesRepl = new SeriesReplacement(newObj, 4 == module);
            seriesRepl.setChanged(isUpdate ? (oldObj == null ? false : !ParticipantNotify.compareRecurrenceInformation(newObj, oldObj)) : false);
        } else if (oldObj != null && oldObj.containsRecurrenceType()) {
            seriesRepl = new SeriesReplacement(oldObj, 4 == module);
            seriesRepl.setChanged(false);
        } else {
            seriesRepl = new SeriesReplacement(newObj, 4 == module);
            seriesRepl.setChanged(false);
        }
        renderMap.put(seriesRepl);
        Date[] deleteExcs = newObj.getDeleteException();
        if (newObj.containsDeleteExceptions() || deleteExcs != null) {
            deleteExceptionsReplacement = new DeleteExceptionsReplacement(deleteExcs);
            deleteExceptionsReplacement.setChanged(isUpdate ? (oldObj == null ? false : !ParticipantNotify.compareDates(deleteExcs, oldObj.getDeleteException())) : false);
        } else if (oldObj != null && oldObj.containsDeleteExceptions()) {
            deleteExceptionsReplacement = new DeleteExceptionsReplacement(oldObj.getDeleteException());
            deleteExceptionsReplacement.setChanged(false);
        } else {
            deleteExceptionsReplacement = new DeleteExceptionsReplacement(deleteExcs);
            deleteExceptionsReplacement.setChanged(false);
        }
        renderMap.put(deleteExceptionsReplacement);
        Date[] changeExcs = newObj.getChangeException();
        if (newObj.containsChangeExceptions() || changeExcs != null) {
            String recurrenceTitle;
            changeExceptionsReplacement = new ChangeExceptionsReplacement(changeExcs);
            if (ParticipantNotify.isChangeException(newObj) && null != (recurrenceTitle = ParticipantNotify.getRecurrenceTitle(newObj, session.getContext()))) {
                changeExceptionsReplacement.setChangeException(true);
                changeExceptionsReplacement.setRecurrenceTitle(recurrenceTitle);
            } else {
                changeExceptionsReplacement.setChanged(isUpdate ? (oldObj == null ? false : !ParticipantNotify.compareDates(changeExcs, oldObj.getChangeException())) : false);
            }
        } else if (oldObj != null && oldObj.containsChangeExceptions()) {
            String recurrenceTitle;
            Date[] oldChangeExcs = oldObj.getChangeException();
            changeExceptionsReplacement = new ChangeExceptionsReplacement(oldChangeExcs);
            if (oldChangeExcs != null && ParticipantNotify.isChangeException(oldObj) && null != (recurrenceTitle = ParticipantNotify.getRecurrenceTitle(oldObj, session.getContext()))) {
                changeExceptionsReplacement.setChangeException(true);
                changeExceptionsReplacement.setRecurrenceTitle(recurrenceTitle);
            } else {
                changeExceptionsReplacement.setChanged(false);
            }
        } else {
            changeExceptionsReplacement = new ChangeExceptionsReplacement(changeExcs);
            changeExceptionsReplacement.setChanged(false);
        }
        renderMap.put(changeExceptionsReplacement);
        return renderMap;
    }

    private static RenderMap clonedRenderMap(RenderMap renderMap) {
        return ((RenderMap)renderMap.clone()).applyChangedStatus(false);
    }

    private void checkChangedFolder(CalendarObject oldObj, String email, int folderId, FolderReplacement folderRepl, ServerSession session) {
        Participant[] oldParticipants = oldObj.getParticipants();
        Context ctx = session.getContext();
        if (oldParticipants != null) {
            block8: for (Participant participant : oldParticipants) {
                switch (participant.getType()) {
                    case 1: {
                        EmailableParticipant p = this.getUserParticipant(participant, ctx);
                        if (p.type != 1 || p.folderId <= 0 || !p.email.equalsIgnoreCase(email)) continue block8;
                        folderRepl.setChanged(p.folderId != folderId);
                        return;
                    }
                    case 5: {
                        EmailableParticipant p = this.getExternalParticipant(participant, session);
                        if (p.type != 1 || p.folderId <= 0 || !p.email.equalsIgnoreCase(email)) continue block8;
                        folderRepl.setChanged(p.folderId != folderId);
                        return;
                    }
                    case 3: {
                        EmailableParticipant p = this.getResourceParticipant(participant, session);
                        if (p.type != 1 || p.folderId <= 0 || !p.email.equalsIgnoreCase(email)) continue block8;
                        folderRepl.setChanged(p.folderId != folderId);
                        return;
                    }
                    case 2: {
                        EmailableParticipant p;
                        try {
                            User[] memberObjects;
                            Group group = this.resolveGroups(ctx, participant.getIdentifier())[0];
                            int[] members = group.getMember();
                            for (User user : memberObjects = this.resolveUsers(ctx, members)) {
                                int[] groups = user.getGroups();
                                TimeZone tz = TimeZoneUtils.getTimeZone(user.getTimeZone());
                                if (user.getMail() == null) continue;
                                p = new EmailableParticipant(ctx.getContextId(), 1, user.getId(), groups, user.getMail(), user.getDisplayName(), user.getLocale(), tz, 10, -1, 0, null, participant.isIgnoreNotification());
                                if (p.type != 1 || p.folderId <= 0 || !p.email.equalsIgnoreCase(email)) continue;
                                folderRepl.setChanged(p.folderId != folderId);
                                return;
                            }
                            continue block8;
                        }
                        catch (OXException e) {
                            ParticipantNotify.log(e);
                            continue block8;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown Participant Type: " + participant.getType());
                    }
                }
            }
        }
    }

    private void sortExternalParticipantsAndResources(Participant[] oldParticipants, Participant[] newParticipants, Set<EmailableParticipant> participantSet, Set<EmailableParticipant> resourceSet, boolean isUpdate, Map<Locale, List<EmailableParticipant>> receivers, ServerSession session, Map<String, EmailableParticipant> all, String organizer, State state) {
        this.sortNewExternalParticipantsAndResources(newParticipants, participantSet, resourceSet, receivers, session, all, oldParticipants);
        this.sortOldExternalParticipantsAndResources(oldParticipants, participantSet, resourceSet, isUpdate, receivers, all, session, newParticipants, organizer, state);
    }

    private void sortOldExternalParticipantsAndResources(Participant[] oldParticipants, Set<EmailableParticipant> participantSet, Set<EmailableParticipant> resourceSet, boolean isUpdate, Map<Locale, List<EmailableParticipant>> receivers, Map<String, EmailableParticipant> all, ServerSession session, Participant[] newParticipants, String organizer, State state) {
        if (oldParticipants == null) {
            return;
        }
        Context ctx = session.getContext();
        block6: for (Participant participant : oldParticipants) {
            switch (participant.getType()) {
                case 1: {
                    continue block6;
                }
                case 5: {
                    EmailableParticipant p = this.getExternalParticipant(participant, session);
                    if (p == null) continue block6;
                    p.state = ParticipantNotify.contains(participant, newParticipants) ? 0 : -1;
                    this.addSingleParticipant(p, participantSet, resourceSet, receivers, all, false);
                    continue block6;
                }
                case 3: {
                    EmailableParticipant p = this.getResourceParticipant(participant, session);
                    if (p == null) {
                        p = this.getUserParticipant(participant, ctx);
                    }
                    if (p == null) continue block6;
                    p.state = ParticipantNotify.contains(participant, newParticipants) ? 0 : -1;
                    this.addSingleParticipant(p, participantSet, resourceSet, receivers, all, true);
                    continue block6;
                }
                case 2: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Participant Type: " + participant.getType());
                }
            }
        }
        if ((isUpdate || ParticipantNotify.isStatusUpdate(state)) && organizer != null) {
            this.addSingleParticipant(this.getExternalParticipant(new ExternalUserParticipant(organizer), session), participantSet, resourceSet, receivers, all, false);
        }
    }

    private void sortNewExternalParticipantsAndResources(Participant[] newParticipants, Set<EmailableParticipant> participantSet, Set<EmailableParticipant> resourceSet, Map<Locale, List<EmailableParticipant>> receivers, ServerSession session, Map<String, EmailableParticipant> all, Participant[] oldParticipants) {
        if (newParticipants == null) {
            return;
        }
        Context ctx = session.getContext();
        block6: for (Participant participant : newParticipants) {
            switch (participant.getType()) {
                case 1: {
                    continue block6;
                }
                case 5: {
                    EmailableParticipant p = this.getExternalParticipant(participant, session);
                    if (p == null) continue block6;
                    p.state = ParticipantNotify.contains(participant, oldParticipants) ? 0 : 1;
                    this.addSingleParticipant(p, participantSet, resourceSet, receivers, all, false);
                    continue block6;
                }
                case 3: {
                    EmailableParticipant p = this.getResourceParticipant(participant, session);
                    if (p == null) {
                        p = this.getUserParticipant(participant, ctx);
                    }
                    if (p == null) continue block6;
                    p.state = ParticipantNotify.contains(participant, oldParticipants) ? 0 : 1;
                    this.addSingleParticipant(p, participantSet, resourceSet, receivers, all, true);
                    continue block6;
                }
                case 2: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Participant Type: " + participant.getType());
                }
            }
        }
    }

    private void sortParticipants(Participant[] oldParticipants, Participant[] newParticipants, Set<EmailableParticipant> participantSet, Set<EmailableParticipant> resourceSet, Map<Locale, List<EmailableParticipant>> receivers, ServerSession session, Map<String, EmailableParticipant> all) {
        this.sortNewParticipants(newParticipants, participantSet, resourceSet, receivers, session, all, oldParticipants);
        this.sortOldParticipants(oldParticipants, participantSet, resourceSet, receivers, all, session, newParticipants);
    }

    private void sortOldParticipants(Participant[] oldParticipants, Set<EmailableParticipant> participantSet, Set<EmailableParticipant> resourceSet, Map<Locale, List<EmailableParticipant>> receivers, Map<String, EmailableParticipant> all, ServerSession session, Participant[] newParticipants) {
        if (oldParticipants == null) {
            return;
        }
        Context ctx = session.getContext();
        block8: for (Participant participant : oldParticipants) {
            switch (participant.getType()) {
                case 1: {
                    EmailableParticipant p = this.getUserParticipant(participant, ctx);
                    if (p == null) continue block8;
                    p.state = ParticipantNotify.contains(participant, newParticipants) ? 0 : -1;
                    this.addSingleParticipant(p, participantSet, resourceSet, receivers, all, false);
                    continue block8;
                }
                case 5: {
                    EmailableParticipant p = this.getExternalParticipant(participant, session);
                    if (p == null) continue block8;
                    p.state = ParticipantNotify.contains(participant, newParticipants) ? 0 : -1;
                    this.addSingleParticipant(p, participantSet, resourceSet, receivers, all, false);
                    continue block8;
                }
                case 3: {
                    EmailableParticipant p = this.getResourceParticipant(participant, session);
                    if (p == null) continue block8;
                    p.state = ParticipantNotify.contains(participant, newParticipants) ? 0 : -1;
                    this.addSingleParticipant(p, participantSet, resourceSet, receivers, all, true);
                    continue block8;
                }
                case 2: {
                    EmailableParticipant p;
                    try {
                        User[] memberObjects;
                        int state = ParticipantNotify.contains(participant, newParticipants) ? 0 : -1;
                        Group group = this.resolveGroups(ctx, participant.getIdentifier())[0];
                        int[] members = group.getMember();
                        for (User user : memberObjects = this.resolveUsers(ctx, members)) {
                            int[] groups = user.getGroups();
                            TimeZone tz = TimeZoneUtils.getTimeZone(user.getTimeZone());
                            if (user.getMail() == null) continue;
                            p = new EmailableParticipant(ctx.getContextId(), 1, user.getId(), groups, user.getMail(), user.getDisplayName(), user.getLocale(), tz, 10, -1, 0, null, participant.isIgnoreNotification());
                            p.state = state;
                            this.addSingleParticipant(p, participantSet, resourceSet, receivers, all, false);
                        }
                        continue block8;
                    }
                    catch (OXException e) {
                        ParticipantNotify.log(e);
                        continue block8;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown Participant Type: " + participant.getType());
                }
            }
        }
    }

    private void sortNewParticipants(Participant[] newParticipants, Set<EmailableParticipant> participantSet, Set<EmailableParticipant> resourceSet, Map<Locale, List<EmailableParticipant>> receivers, ServerSession session, Map<String, EmailableParticipant> all, Participant[] oldParticipants) {
        if (newParticipants == null) {
            return;
        }
        Context ctx = session.getContext();
        block8: for (Participant participant : newParticipants) {
            switch (participant.getType()) {
                case 1: {
                    EmailableParticipant p = this.getUserParticipant(participant, ctx);
                    if (p == null) continue block8;
                    p.state = ParticipantNotify.contains(participant, oldParticipants) ? 0 : 1;
                    this.addSingleParticipant(p, participantSet, resourceSet, receivers, all, false);
                    continue block8;
                }
                case 5: {
                    EmailableParticipant p = this.getExternalParticipant(participant, session);
                    if (p == null) continue block8;
                    p.state = ParticipantNotify.contains(participant, oldParticipants) ? 0 : 1;
                    this.addSingleParticipant(p, participantSet, resourceSet, receivers, all, false);
                    continue block8;
                }
                case 3: {
                    EmailableParticipant p = this.getResourceParticipant(participant, session);
                    if (p == null) continue block8;
                    p.state = ParticipantNotify.contains(participant, oldParticipants) ? 0 : 1;
                    this.addSingleParticipant(p, participantSet, resourceSet, receivers, all, true);
                    continue block8;
                }
                case 2: {
                    EmailableParticipant p;
                    try {
                        User[] memberObjects;
                        int state = ParticipantNotify.contains(participant, oldParticipants) ? 0 : 1;
                        Group group = this.resolveGroups(ctx, participant.getIdentifier())[0];
                        int[] members = group.getMember();
                        for (User user : memberObjects = this.resolveUsers(ctx, members)) {
                            int[] groups = user.getGroups();
                            TimeZone tz = TimeZoneUtils.getTimeZone(user.getTimeZone());
                            if (user.getMail() == null) continue;
                            p = new EmailableParticipant(ctx.getContextId(), 1, user.getId(), groups, user.getMail(), user.getDisplayName(), user.getLocale(), tz, 10, -1, 0, null, participant.isIgnoreNotification());
                            p.state = state;
                            this.addSingleParticipant(p, participantSet, resourceSet, receivers, all, false);
                        }
                        continue block8;
                    }
                    catch (OXException e) {
                        ParticipantNotify.log(e);
                        continue block8;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown Participant Type: " + participant.getType());
                }
            }
        }
    }

    private static void log(OXException e) {
        switch (((Category)e.getCategories().get(0)).getLogLevel()) {
            case TRACE: {
                LOG.trace("", (Throwable)e);
                break;
            }
            case DEBUG: {
                LOG.debug("", (Throwable)e);
                break;
            }
            case INFO: {
                LOG.info("", (Throwable)e);
                break;
            }
            case WARNING: {
                LOG.warn("", (Throwable)e);
                break;
            }
            case ERROR: {
                LOG.error("", (Throwable)e);
                break;
            }
        }
    }

    private EmailableParticipant getExternalParticipant(Participant participant, ServerSession session) {
        TimeZone tz;
        Locale l;
        if (null == participant.getEmailAddress()) {
            return null;
        }
        try {
            User user = this.resolveUsers(session.getContext(), session.getUserId())[0];
            l = user.getLocale();
            tz = ParticipantNotify.getCalendarTools().getTimeZone(user.getTimeZone());
        }
        catch (OXException e) {
            LOG.warn("Could not resolve user from session: UserId: {} in Context: {}", (Object)session.getUserId(), (Object)session.getContextId());
            l = Locale.getDefault();
            tz = TimeZone.getDefault();
        }
        return new EmailableParticipant(session.getContextId(), participant.getType(), -1, new int[0], participant.getEmailAddress(), participant.getDisplayName(), l, tz, 0, -1, 0, null, participant.isIgnoreNotification());
    }

    private EmailableParticipant getUserParticipant(Participant participant, Context ctx) {
        int[] groups = null;
        TimeZone tz = null;
        String mail = null;
        String displayName = null;
        int folderId = -1;
        Locale locale = null;
        try {
            User user = this.resolveUsers(ctx, participant.getIdentifier())[0];
            locale = user.getLocale();
            mail = user.getMail();
            if (mail == null) {
                mail = participant.getEmailAddress();
            }
            if ((displayName = user.getDisplayName()) == null) {
                displayName = participant.getDisplayName();
            }
            groups = user.getGroups();
            tz = ParticipantNotify.getCalendarTools().getTimeZone(user.getTimeZone());
            if (participant instanceof UserParticipant) {
                UserParticipant userParticipant = (UserParticipant)participant;
                folderId = userParticipant.getPersonalFolderId();
            }
        }
        catch (OXException e) {
            ParticipantNotify.log(e);
        }
        if (mail != null) {
            if (participant instanceof UserParticipant) {
                UserParticipant up = (UserParticipant)participant;
                return new EmailableParticipant(ctx.getContextId(), up.getType(), up.getIdentifier(), groups, mail, displayName, locale, tz, 10, folderId, up.getConfirm(), up.getConfirmMessage(), participant.isIgnoreNotification());
            }
            return new EmailableParticipant(ctx.getContextId(), participant.getType(), participant.getIdentifier(), groups, mail, displayName, locale, tz, 10, folderId, 0, null, participant.isIgnoreNotification());
        }
        return null;
    }

    private EmailableParticipant getResourceParticipant(Participant participant, ServerSession session) {
        Locale l;
        int[] groups = new int[]{};
        String mail = null;
        String displayName = null;
        Context ctx = session.getContext();
        try {
            Resource resource = this.resolveResources(ctx, participant.getIdentifier())[0];
            mail = resource.getMail();
            if (mail == null) {
                mail = participant.getEmailAddress();
            }
            if ((displayName = resource.getDisplayName()) == null) {
                displayName = participant.getDisplayName();
            }
        }
        catch (OXException e) {
            ParticipantNotify.log(e);
        }
        try {
            User user = this.resolveUsers(session.getContext(), session.getUserId())[0];
            l = user.getLocale();
        }
        catch (OXException e) {
            LOG.warn("Could not resolve user from session: UserId: {} in Context: {}", (Object)session.getUserId(), (Object)session.getContextId());
            l = Locale.getDefault();
        }
        if (mail != null) {
            EmailableParticipant p = new EmailableParticipant(ctx.getContextId(), participant.getType(), participant.getIdentifier(), groups, mail, displayName, l, TimeZone.getDefault(), -1, -2, 0, null, participant.isIgnoreNotification());
            return p;
        }
        return null;
    }

    private void sortUserParticipants(UserParticipant[] oldParticipants, UserParticipant[] newParticipants, Set<EmailableParticipant> participantSet, boolean forUpdate, Map<Locale, List<EmailableParticipant>> receivers, ServerSession session, Map<String, EmailableParticipant> all) {
        EmailableParticipant p;
        if (newParticipants == null) {
            return;
        }
        Context ctx = session.getContext();
        for (UserParticipant participant : newParticipants) {
            p = this.getUserParticipant(participant, ctx);
            if (p == null) continue;
            p.state = ParticipantNotify.contains(participant, oldParticipants) ? 0 : 1;
            this.addSingleParticipant(p, participantSet, null, receivers, all, false);
        }
        if (null != oldParticipants) {
            for (UserParticipant participant : oldParticipants) {
                p = this.getUserParticipant(participant, ctx);
                if (p == null) continue;
                int n = p.state = ParticipantNotify.contains(participant, newParticipants) ? 0 : -1;
                if (forUpdate) {
                    this.addSingleParticipant(p, participantSet, null, receivers, all, false);
                    continue;
                }
                this.addReceiver(p, receivers, all);
            }
        }
    }

    private void addTaskOwner(CalendarObject oldTask, CalendarObject newTask, Map<Locale, List<EmailableParticipant>> receivers, Map<String, EmailableParticipant> all, ServerSession session) {
        Context ctx = session.getContext();
        int creatorId = newTask.getCreatedBy();
        int folderId = null != oldTask ? oldTask.getParentFolderID() : -1;
        try {
            User user = this.resolveUsers(ctx, creatorId)[0];
            EmailableParticipant emailable = new EmailableParticipant(ctx.getContextId(), 1, creatorId, user.getGroups(), user.getMail(), user.getDisplayName(), user.getLocale(), ParticipantNotify.getCalendarTools().getTimeZone(user.getTimeZone()), 10, folderId, 0, null, false);
            this.addReceiver(emailable, receivers, all);
        }
        catch (OXException e) {
            ParticipantNotify.log(e);
        }
    }

    private void addReceiver(EmailableParticipant participant, Map<Locale, List<EmailableParticipant>> receivers, Map<String, EmailableParticipant> all) {
        if (all.containsKey(participant.email)) {
            EmailableParticipant other = all.get(participant.email);
            if (other.reliability < participant.reliability) {
                if (other.getLocale().equals(participant.getLocale())) {
                    other.copy(participant);
                    return;
                }
                List<EmailableParticipant> p = receivers.get(other.getLocale());
                p.remove(p.indexOf(other));
            }
            return;
        }
        Locale l = participant.getLocale();
        List<EmailableParticipant> p = receivers.get(l);
        if (p == null) {
            p = new ArrayList<EmailableParticipant>();
            receivers.put(l, p);
        }
        all.put(participant.email, participant);
        p.add(participant);
    }

    private void addSingleParticipant(EmailableParticipant participant, Set<EmailableParticipant> participantSet, Set<EmailableParticipant> resourceSet, Map<Locale, List<EmailableParticipant>> receivers, Map<String, EmailableParticipant> all, boolean resource) {
        this.addReceiver(participant, receivers, all);
        if (resource) {
            resourceSet.add(participant);
        } else {
            participantSet.add(participant);
        }
    }

    protected static final boolean contains(Participant toSearch, Participant[] participants) {
        if (null == participants) {
            return false;
        }
        for (Participant participant : participants) {
            if (participant == null || !participant.equals(toSearch)) continue;
            return true;
        }
        return false;
    }

    private static final boolean compareRecurrenceInformation(CalendarObject o1, CalendarObject o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1.getRecurrenceType() != o2.getRecurrenceType()) {
            return false;
        }
        if (1 == o1.getRecurrenceType()) {
            return o1.getInterval() == o2.getInterval();
        }
        if (2 == o1.getRecurrenceType()) {
            if (o1.getInterval() != o2.getInterval()) {
                return false;
            }
            return o1.getDays() == o2.getDays();
        }
        if (3 == o1.getRecurrenceType()) {
            if (o1.getInterval() != o2.getInterval()) {
                return false;
            }
            if (o1.getDays() != o2.getDays()) {
                return false;
            }
            return o1.getDayInMonth() == o2.getDayInMonth();
        }
        if (4 == o1.getRecurrenceType()) {
            if (o1.getMonth() != o2.getMonth()) {
                return false;
            }
            if (o1.getDays() != o2.getDays()) {
                return false;
            }
            return o1.getDayInMonth() == o2.getDayInMonth();
        }
        return true;
    }

    static final boolean compareObjects(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    static final boolean compareDates(Date[] dates1, Date[] dates2) {
        if (dates1 == dates2) {
            return true;
        }
        if (dates1 == null) {
            if (dates2 == null) {
                return true;
            }
            return dates2.length == 0;
        }
        if (dates2 == null && dates1.length == 0) {
            return true;
        }
        return Arrays.equals(dates1, dates2);
    }

    static final boolean compareStrings(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            if (s2 == null) {
                return true;
            }
            return s2.length() == 0;
        }
        if (s2 == null && s1.length() == 0) {
            return true;
        }
        return s1.trim().equals(s2 == null ? null : s2.trim());
    }

    static final boolean checkStartAndEndDate(CalendarObject calendarObj, int module) {
        long now = System.currentTimeMillis();
        if (0 == calendarObj.getRecurrenceType()) {
            Date endDate = calendarObj.getEndDate();
            if (endDate != null) {
                if (1 == module && endDate.getTime() < now) {
                    LOG.debug("Ignoring notification(s) for single appointment object {} since its end date is in the past", (Object)calendarObj.getObjectID());
                    return false;
                }
                if (4 == module && !ParticipantNotify.compare2Date(endDate.getTime(), now)) {
                    LOG.debug("Ignoring notification(s) for single task object {} since its end date is in the past", (Object)calendarObj.getObjectID());
                    return false;
                }
            }
        } else {
            Date untilDate = calendarObj.getUntil();
            if (null != untilDate) {
                if (1 == module && untilDate.getTime() < now) {
                    LOG.debug("Ignoring notification(s) for recurring appointment object {} since its until date is in the past", (Object)calendarObj.getObjectID());
                    return false;
                }
                if (4 == module && !ParticipantNotify.compare2Date(untilDate.getTime(), now)) {
                    LOG.debug("Ignoring notification(s) for recurring task object {} since its until date is in the past", (Object)calendarObj.getObjectID());
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean compare2Date(long date, long millis) {
        return date >= millis - millis % 86400000L;
    }

    private static Date computeFirstOccurrenceEnd(long startMillis, long endMillis) {
        Calendar cal = Calendar.getInstance(ParticipantNotify.getCalendarTools().getTimeZone("UTC"), Locale.ENGLISH);
        cal.setTimeInMillis(endMillis);
        int hourOfDay = cal.get(11);
        int minutes = cal.get(12);
        cal.setTimeInMillis(startMillis);
        cal.set(11, hourOfDay);
        cal.set(12, minutes);
        return cal.getTime();
    }

    private static Date computeFirstOccurrenceEnd(CalendarObject app) throws OXException {
        CalendarCollectionService service = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        RecurringResultsInterface recurrences = service.calculateFirstRecurring(app);
        RecurringResultInterface recurringResult = recurrences.getRecurringResult(0);
        return new Date(recurringResult.getEnd());
    }

    private static boolean isChangeException(CalendarObject appointment) {
        return appointment.containsObjectID() && appointment.containsRecurrenceID() && appointment.getRecurrenceID() > 0 && appointment.getObjectID() != appointment.getRecurrenceID();
    }

    private static boolean isStatusUpdate(State state) {
        return null != state && (State.Type.ACCEPTED.equals((Object)state.getType()) || State.Type.DECLINED.equals((Object)state.getType()) || State.Type.TENTATIVELY_ACCEPTED.equals((Object)state.getType()) || State.Type.NONE_ACCEPTED.equals((Object)state.getType()));
    }

    private static String getRecurrenceTitle(CalendarObject appointment, Context ctx) {
        int recurrenceId = appointment.getRecurrenceID();
        if (recurrenceId <= 0) {
            return null;
        }
        try {
            return ParticipantNotify.getCalendarTools().getAppointmentTitle(recurrenceId, ctx);
        }
        catch (OXException e) {
            return null;
        }
    }

    private static CalendarCollectionService getCalendarTools() {
        return ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
    }

    static final class MailMessage {
        public State.Type overrideType;
        public Object message;
        public String title;
        public List<String> addresses = new ArrayList<String>();
        public int folderId;
        public boolean internal;
    }
}

