/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.search.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.search.AbstractStringSearchTerm;
import com.openexchange.groupware.infostore.search.AndTerm;
import com.openexchange.groupware.infostore.search.CategoriesTerm;
import com.openexchange.groupware.infostore.search.ColorLabelTerm;
import com.openexchange.groupware.infostore.search.ComparablePattern;
import com.openexchange.groupware.infostore.search.ContentTerm;
import com.openexchange.groupware.infostore.search.CreatedByTerm;
import com.openexchange.groupware.infostore.search.CreatedTerm;
import com.openexchange.groupware.infostore.search.CurrentVersionTerm;
import com.openexchange.groupware.infostore.search.DescriptionTerm;
import com.openexchange.groupware.infostore.search.FileMd5SumTerm;
import com.openexchange.groupware.infostore.search.FileMimeTypeTerm;
import com.openexchange.groupware.infostore.search.FileNameTerm;
import com.openexchange.groupware.infostore.search.FileSizeTerm;
import com.openexchange.groupware.infostore.search.LastModifiedTerm;
import com.openexchange.groupware.infostore.search.LastModifiedUtcTerm;
import com.openexchange.groupware.infostore.search.LockedUntilTerm;
import com.openexchange.groupware.infostore.search.MetaTerm;
import com.openexchange.groupware.infostore.search.ModifiedByTerm;
import com.openexchange.groupware.infostore.search.NotTerm;
import com.openexchange.groupware.infostore.search.NumberOfVersionsTerm;
import com.openexchange.groupware.infostore.search.OrTerm;
import com.openexchange.groupware.infostore.search.SearchTerm;
import com.openexchange.groupware.infostore.search.SearchTermVisitor;
import com.openexchange.groupware.infostore.search.SequenceNumberTerm;
import com.openexchange.groupware.infostore.search.TitleTerm;
import com.openexchange.groupware.infostore.search.UrlTerm;
import com.openexchange.groupware.infostore.search.VersionCommentTerm;
import com.openexchange.groupware.infostore.search.VersionTerm;
import com.openexchange.groupware.infostore.search.impl.SearchEngineImpl;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.java.Autoboxing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.owasp.esapi.codecs.MySQLCodec;

public class ToMySqlQueryVisitor
implements SearchTermVisitor {
    private static final String INFOSTORE = "infostore.";
    private static final String DOCUMENT = "infostore_document.";
    private static final String PREFIX = " FROM infostore JOIN infostore_document ON infostore_document.cid = infostore.cid AND infostore_document.infostore_id = infostore.id AND infostore_document.version_number = infostore.version WHERE infostore.cid = ";
    private static final char[] IMMUNE = new char[]{' ', '%', '_'};
    private static final char[] IMMUNE_WILDCARDS = new char[]{' ', '%', '_', '\\'};
    private static final Set<Class<? extends SearchTerm<?>>> UNSUPPORTED = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(ContentTerm.class, MetaTerm.class, SequenceNumberTerm.class)));
    private final StringBuilder sb = new StringBuilder(8192);
    private final MySQLCodec codec = new MySQLCodec(MySQLCodec.Mode.STANDARD);
    private final Metadata sortedBy;
    private final int dir;
    private final int start;
    private final int end;

    public ToMySqlQueryVisitor(List<Integer> readAllFolders, List<Integer> readOwnFolders, int contextId, int userId, String cols, Metadata sortedBy, int dir, int start, int end) {
        this.sortedBy = sortedBy;
        this.dir = dir;
        this.start = start;
        this.end = end;
        this.sb.append(cols);
        this.sb.append(PREFIX).append(contextId);
        SearchEngineImpl.appendFolders(this.sb, contextId, userId, readAllFolders, readOwnFolders);
        this.sb.append(" AND ");
    }

    protected ToMySqlQueryVisitor(int[] allFolderIds, int[] ownFolderIds, int contextId, int userId, String cols, Metadata sortedBy, int dir, int start, int end) {
        this(null == allFolderIds ? Collections.emptyList() : Arrays.asList(Autoboxing.i2I((int[])allFolderIds)), null == ownFolderIds ? Collections.emptyList() : Arrays.asList(Autoboxing.i2I((int[])ownFolderIds)), contextId, userId, cols, sortedBy, dir, start, end);
    }

    protected ToMySqlQueryVisitor(int[] allFolderIds, int[] ownFolderIds, int contextId, int userId, String cols) {
        this(null == allFolderIds ? Collections.emptyList() : Arrays.asList(Autoboxing.i2I((int[])allFolderIds)), null == ownFolderIds ? Collections.emptyList() : Arrays.asList(Autoboxing.i2I((int[])ownFolderIds)), contextId, userId, cols, null, -11, -11, -11);
    }

    public String getMySqlQuery() {
        if (null != this.sortedBy && this.dir != -11) {
            this.sb.append(" ORDER BY ").append(this.sortedBy.getName());
            if (this.dir == 1) {
                this.sb.append(" ASC");
            } else if (this.dir == -1) {
                this.sb.append(" DESC");
            }
        }
        if (this.start > -1 && this.end > -1 && this.start < this.end) {
            this.sb.append(" LIMIT ").append(this.start).append(",").append(this.end);
        }
        return this.sb.toString();
    }

    private static List<SearchTerm<?>> prepareTerms(List<SearchTerm<?>> terms) {
        if (null == terms) {
            return Collections.emptyList();
        }
        ArrayList retval = new ArrayList(terms.size());
        for (SearchTerm<?> term : terms) {
            if (UNSUPPORTED.contains(term.getClass())) continue;
            retval.add(term);
        }
        return retval;
    }

    @Override
    public void visit(AndTerm andTerm) throws OXException {
        List<SearchTerm<?>> terms = ToMySqlQueryVisitor.prepareTerms(andTerm.getPattern());
        int size = terms.size();
        if (size <= 0) {
            return;
        }
        if (1 == size) {
            terms.get(0).visit(this);
            return;
        }
        this.sb.append('(');
        terms.get(0).visit(this);
        for (int i = 1; i < size; ++i) {
            this.sb.append("AND ");
            terms.get(i).visit(this);
        }
        this.sb.append(')');
    }

    @Override
    public void visit(OrTerm orTerm) throws OXException {
        List<SearchTerm<?>> terms = ToMySqlQueryVisitor.prepareTerms(orTerm.getPattern());
        int size = terms.size();
        if (size <= 0) {
            return;
        }
        if (1 == size) {
            terms.get(0).visit(this);
            return;
        }
        this.sb.append('(');
        terms.get(0).visit(this);
        for (int i = 1; i < size; ++i) {
            this.sb.append("OR ");
            terms.get(i).visit(this);
        }
        this.sb.append(')');
    }

    @Override
    public void visit(NotTerm notTerm) throws OXException {
        this.sb.append("NOT ");
        notTerm.getPattern().visit(this);
    }

    @Override
    public void visit(MetaTerm metaTerm) {
    }

    @Override
    public void visit(NumberOfVersionsTerm numberOfVersionsTerm) {
        String comp = this.getComparionType((ComparablePattern)numberOfVersionsTerm.getPattern());
        this.sb.append(INFOSTORE).append("version").append(comp).append("MAX(").append(numberOfVersionsTerm.getPattern().getPattern()).append(") ");
    }

    @Override
    public void visit(LastModifiedUtcTerm lastModifiedUtcTerm) {
        String comp = this.getComparionType((ComparablePattern)lastModifiedUtcTerm.getPattern());
        this.sb.append(INFOSTORE).append("last_modified").append(comp).append(((Date)lastModifiedUtcTerm.getPattern().getPattern()).getTime()).append(" ");
    }

    @Override
    public void visit(ColorLabelTerm colorLabelTerm) {
        String comp = this.getComparionType((ComparablePattern)colorLabelTerm.getPattern());
        this.sb.append(INFOSTORE).append("color_label").append(comp).append(colorLabelTerm.getPattern().getPattern()).append(" ");
    }

    @Override
    public void visit(CurrentVersionTerm currentVersionTerm) {
        this.sb.append(INFOSTORE).append("version = ").append(DOCUMENT).append("version_number").append(" ");
    }

    @Override
    public void visit(VersionCommentTerm versionCommentTerm) {
        String field = "file_version_comment";
        this.parseStringSearchTerm(versionCommentTerm, field);
    }

    @Override
    public void visit(FileMd5SumTerm fileMd5SumTerm) {
        String field = "file_md5sum";
        this.parseStringSearchTerm(fileMd5SumTerm, field);
    }

    @Override
    public void visit(LockedUntilTerm lockedUntilTerm) {
        String comp = this.getComparionType((ComparablePattern)lockedUntilTerm.getPattern());
        this.sb.append(INFOSTORE).append("locked_until").append(comp).append(((Date)lockedUntilTerm.getPattern().getPattern()).getTime()).append(" ");
    }

    @Override
    public void visit(CategoriesTerm categoriesTerm) {
        String field = "categories";
        this.parseStringSearchTerm(categoriesTerm, field);
    }

    @Override
    public void visit(SequenceNumberTerm sequenceNumberTerm) {
    }

    @Override
    public void visit(FileMimeTypeTerm fileMimeTypeTerm) {
        String field = "file_mimetype";
        this.parseStringSearchTerm(fileMimeTypeTerm, field);
    }

    @Override
    public void visit(FileNameTerm fileNameTerm) {
        String field = "filename";
        this.parseStringSearchTerm(fileNameTerm, field);
    }

    @Override
    public void visit(LastModifiedTerm lastModifiedTerm) {
        String comp = this.getComparionType((ComparablePattern)lastModifiedTerm.getPattern());
        this.sb.append(INFOSTORE).append("last_modified").append(comp).append(((Date)lastModifiedTerm.getPattern().getPattern()).getTime()).append(" ");
    }

    @Override
    public void visit(CreatedTerm createdTerm) {
        String comp = this.getComparionType((ComparablePattern)createdTerm.getPattern());
        this.sb.append(INFOSTORE).append("creating_date").append(comp).append(((Date)createdTerm.getPattern().getPattern()).getTime()).append(" ");
    }

    @Override
    public void visit(ModifiedByTerm modifiedByTerm) {
        String comp = this.getComparionType((ComparablePattern)modifiedByTerm.getPattern());
        this.sb.append(INFOSTORE).append("changed_by =").append(comp).append(modifiedByTerm.getPattern().getPattern()).append(" ");
    }

    @Override
    public void visit(TitleTerm titleTerm) {
        String field = "title";
        this.parseStringSearchTerm(titleTerm, field);
    }

    @Override
    public void visit(VersionTerm versionTerm) {
        this.sb.append(DOCUMENT).append("version_number = ").append(versionTerm.getPattern()).append(" ");
    }

    @Override
    public void visit(ContentTerm contentTerm) {
    }

    @Override
    public void visit(FileSizeTerm fileSizeTerm) {
        String comp = this.getComparionType((ComparablePattern)fileSizeTerm.getPattern());
        this.sb.append(DOCUMENT).append("file_size").append(comp).append(fileSizeTerm.getPattern().getPattern()).append(" ");
    }

    @Override
    public void visit(DescriptionTerm descriptionTerm) {
        String field = "description";
        this.parseStringSearchTerm(descriptionTerm, field);
    }

    @Override
    public void visit(UrlTerm urlTerm) {
        String field = "url";
        this.parseStringSearchTerm(urlTerm, field);
    }

    @Override
    public void visit(CreatedByTerm createdByTerm) {
        String comp = this.getComparionType((ComparablePattern)createdByTerm.getPattern());
        this.sb.append(INFOSTORE).append("created_by").append(comp).append(createdByTerm.getPattern().getPattern()).append(" ");
    }

    private <T> String getComparionType(ComparablePattern<T> pattern) {
        String comp;
        switch (pattern.getComparisonType()) {
            case LESS_THAN: {
                comp = "<";
                break;
            }
            case GREATER_THAN: {
                comp = ">";
                break;
            }
            case EQUALS: {
                comp = "=";
                break;
            }
            default: {
                comp = "";
            }
        }
        return comp;
    }

    private boolean hasWildCards(String pattern) {
        return pattern.indexOf(42) >= 0 || pattern.indexOf(63) >= 0;
    }

    private String replaceWildcards(String pattern) {
        int length = pattern.length();
        StringBuilder sb = new StringBuilder(length);
        block7: for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    sb.append('%');
                    continue block7;
                }
                case '?': {
                    sb.append('_');
                    continue block7;
                }
                case '%': {
                    sb.append("\\%");
                    continue block7;
                }
                case '_': {
                    sb.append("\\_");
                    continue block7;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private void parseStringSearchTerm(AbstractStringSearchTerm searchTerm, String field) {
        String pattern = searchTerm.getPattern();
        boolean useLike = searchTerm.isSubstringSearch() || this.hasWildCards(pattern);
        String fieldName = DOCUMENT + field;
        if (useLike) {
            pattern = this.codec.encode(IMMUNE_WILDCARDS, this.replaceWildcards(pattern));
            if (searchTerm.isSubstringSearch()) {
                StringBuilder tmp = new StringBuilder(pattern.length() + 8);
                if (!pattern.startsWith("%")) {
                    tmp.append('%');
                }
                tmp.append(pattern);
                if (!pattern.endsWith("%")) {
                    tmp.append('%');
                }
                pattern = tmp.toString();
            }
        } else {
            pattern = this.codec.encode(IMMUNE, pattern);
        }
        if (searchTerm.isIgnoreCase()) {
            fieldName = "UPPER(" + fieldName + ')';
            pattern = "UPPER('" + pattern + "')";
        } else {
            pattern = new StringBuilder(pattern.length() + 2).append('\'').append(pattern).append('\'').toString();
        }
        this.sb.append(fieldName);
        if (useLike) {
            this.sb.append(" LIKE ").append(pattern);
        } else {
            this.sb.append(" = ").append(pattern);
        }
    }
}

