/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.facade.impl;

import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageUtility;
import com.openexchange.file.storage.Quota;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.filestore.FileStorage;
import com.openexchange.filestore.QuotaFileStorage;
import com.openexchange.filestore.QuotaFileStorageService;
import com.openexchange.groupware.container.EffectiveObjectPermission;
import com.openexchange.groupware.container.EffectiveObjectPermissions;
import com.openexchange.groupware.container.ObjectPermission;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.infostore.DocumentAndMetadata;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.EffectiveInfostoreFolderPermission;
import com.openexchange.groupware.infostore.EffectiveInfostorePermission;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreSearchEngine;
import com.openexchange.groupware.infostore.InfostoreTimedResult;
import com.openexchange.groupware.infostore.database.FilenameReservation;
import com.openexchange.groupware.infostore.database.FilenameReserver;
import com.openexchange.groupware.infostore.database.impl.AbstractDocumentListAction;
import com.openexchange.groupware.infostore.database.impl.CheckSizeSwitch;
import com.openexchange.groupware.infostore.database.impl.CreateDocumentAction;
import com.openexchange.groupware.infostore.database.impl.CreateObjectPermissionAction;
import com.openexchange.groupware.infostore.database.impl.CreateVersionAction;
import com.openexchange.groupware.infostore.database.impl.DatabaseImpl;
import com.openexchange.groupware.infostore.database.impl.DeleteDocumentAction;
import com.openexchange.groupware.infostore.database.impl.DeleteObjectPermissionAction;
import com.openexchange.groupware.infostore.database.impl.DeleteVersionAction;
import com.openexchange.groupware.infostore.database.impl.DocumentCustomizer;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.FilenameReserverImpl;
import com.openexchange.groupware.infostore.database.impl.InfostoreIterator;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurity;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurityImpl;
import com.openexchange.groupware.infostore.database.impl.ReplaceDocumentIntoDelTableAction;
import com.openexchange.groupware.infostore.database.impl.Tools;
import com.openexchange.groupware.infostore.database.impl.UpdateDocumentAction;
import com.openexchange.groupware.infostore.database.impl.UpdateObjectPermissionAction;
import com.openexchange.groupware.infostore.database.impl.UpdateVersionAction;
import com.openexchange.groupware.infostore.database.impl.versioncontrol.VersionControlUtil;
import com.openexchange.groupware.infostore.facade.impl.DocumentAndMetadataImpl;
import com.openexchange.groupware.infostore.facade.impl.LockedUntilLoader;
import com.openexchange.groupware.infostore.facade.impl.NumberOfVersionsLoader;
import com.openexchange.groupware.infostore.facade.impl.ObjectPermissionLoader;
import com.openexchange.groupware.infostore.facade.impl.SaveParameters;
import com.openexchange.groupware.infostore.search.SearchTerm;
import com.openexchange.groupware.infostore.search.impl.SearchEngineImpl;
import com.openexchange.groupware.infostore.utils.GetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.utils.SetSwitch;
import com.openexchange.groupware.infostore.validation.FilenamesMayNotContainSlashesValidator;
import com.openexchange.groupware.infostore.validation.InvalidCharactersValidator;
import com.openexchange.groupware.infostore.validation.ObjectPermissionValidator;
import com.openexchange.groupware.infostore.validation.ValidationChain;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.infostore.webdav.EntityLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.Lock;
import com.openexchange.groupware.infostore.webdav.LockManager;
import com.openexchange.groupware.infostore.webdav.TouchInfoitemsWithExpiredLocksListener;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.Results;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.quota.QuotaExceptionCodes;
import com.openexchange.quota.groupware.AmountQuotas;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.share.ShareService;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.file.AppendFileAction;
import com.openexchange.tools.file.SaveFileAction;
import com.openexchange.tools.iterator.Customizer;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.iterator.SearchIteratorDelegator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.user.UserService;
import com.openexchange.userconf.UserPermissionService;
import gnu.trove.list.linked.TIntLinkedList;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfostoreFacadeImpl
extends DBService
implements InfostoreFacade,
InfostoreSearchEngine {
    private static final Logger LOG = LoggerFactory.getLogger(InfostoreFacadeImpl.class);
    private static final InfostoreQueryCatalog QUERIES = InfostoreQueryCatalog.getInstance();
    private static final AtomicReference<QuotaFileStorageService> QFS_REF = new AtomicReference();
    protected final InfostoreSecurity security = new InfostoreSecurityImpl();
    private final DatabaseImpl db = new DatabaseImpl();
    private final EntityLockManager lockManager = new EntityLockManagerImpl("infostore_lock");
    private final ThreadLocal<List<FileRemoveInfo>> fileIdRemoveList = new ThreadLocal();
    private final ThreadLocal<Map<Integer, Set<Integer>>> guestCleanupList = new ThreadLocal();
    private final TouchInfoitemsWithExpiredLocksListener expiredLocksListener = new TouchInfoitemsWithExpiredLocksListener(null, this);
    private final ObjectPermissionLoader objectPermissionLoader;
    private final NumberOfVersionsLoader numberOfVersionsLoader;
    private final LockedUntilLoader lockedUntilLoader;
    private final SearchEngineImpl searchEngine;

    public static void setQuotaFileStorageService(QuotaFileStorageService service) {
        QFS_REF.set(service);
    }

    public InfostoreFacadeImpl() {
        this.lockManager.addExpiryListener(this.expiredLocksListener);
        this.searchEngine = new SearchEngineImpl(this);
        this.objectPermissionLoader = new ObjectPermissionLoader(this);
        this.numberOfVersionsLoader = new NumberOfVersionsLoader(this);
        this.lockedUntilLoader = new LockedUntilLoader(this.lockManager);
    }

    public InfostoreFacadeImpl(DBProvider provider) {
        this();
        this.setProvider(provider);
    }

    @Override
    public boolean exists(int id, int version2, ServerSession session) throws OXException {
        try {
            return this.security.getInfostorePermission(session, id).canReadObject();
        }
        catch (OXException e) {
            if (InfostoreExceptionCodes.NOT_EXIST.equals(e)) {
                return false;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(int id, int version2, Context context) throws OXException {
        boolean bl;
        InfostoreIterator searchIterator;
        block4: {
            Metadata[] metadata = new Metadata[]{Metadata.FOLDER_ID_LITERAL, Metadata.ID_LITERAL, Metadata.VERSION_LITERAL};
            searchIterator = null;
            searchIterator = InfostoreIterator.versions(id, metadata, Metadata.VERSION_LITERAL, 1, this, context);
            if (version2 != -1) break block4;
            boolean bl2 = searchIterator.hasNext();
            SearchIterators.close((SearchIterator)searchIterator);
            return bl2;
        }
        try {
            boolean found = false;
            while (searchIterator.hasNext()) {
                DocumentMetadata document = searchIterator.next();
                if (version2 != document.getVersion()) continue;
                found = true;
                break;
            }
            bl = found;
        }
        catch (Throwable throwable) {
            SearchIterators.close(searchIterator);
            throw throwable;
        }
        SearchIterators.close((SearchIterator)searchIterator);
        return bl;
    }

    @Override
    public boolean hasDocumentAccess(int id, InfostoreFacade.AccessPermission permission, User user, Context context) throws OXException {
        UserPermissionService userPermissionService = ServerServiceRegistry.getServize(UserPermissionService.class, true);
        UserPermissionBits permissionBits = userPermissionService.getUserPermissionBits(user.getId(), context);
        EffectiveInfostorePermission effectivePermission = this.security.getInfostorePermission(context, user, permissionBits, id);
        return permission.appliesTo(effectivePermission);
    }

    @Override
    public DocumentMetadata getDocumentMetadata(int id, int version2, ServerSession session) throws OXException {
        return this.getDocumentMetadata(-1L, id, version2, session);
    }

    @Override
    public DocumentMetadata getDocumentMetadata(long folderId, int id, int version2, ServerSession session) throws OXException {
        Context context = session.getContext();
        DocumentMetadata document = this.objectPermissionLoader.add(this.load(id, version2, context), context, null);
        EffectiveInfostorePermission permission = this.security.getInfostorePermission(session, document);
        if (!permission.canReadObject()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        if ((long)this.getSharedFilesFolderID(session) == folderId || !permission.canReadObjectInFolder()) {
            document.setOriginalFolderId(document.getFolderId());
            document.setFolderId(this.getSharedFilesFolderID(session));
            document.setShareable(false);
        } else {
            document.setShareable(permission.canShareObject());
        }
        return this.numberOfVersionsLoader.add(this.lockedUntilLoader.add(document, context, null), context, null);
    }

    @Override
    public DocumentMetadata getDocumentMetadata(int id, int version2, Context context) throws OXException {
        DocumentMetadata document = this.objectPermissionLoader.add(this.load(id, version2, context), context, null);
        return this.numberOfVersionsLoader.add(this.lockedUntilLoader.add(document, context, null), context, null);
    }

    @Override
    public FileStorageFileAccess.IDTuple saveDocumentMetadata(DocumentMetadata document, long sequenceNumber, ServerSession session) throws OXException {
        return this.saveDocument(document, null, sequenceNumber, session);
    }

    @Override
    public FileStorageFileAccess.IDTuple saveDocumentMetadata(DocumentMetadata document, long sequenceNumber, Metadata[] modifiedColumns, ServerSession session) throws OXException {
        return this.saveDocument(document, null, sequenceNumber, modifiedColumns, session);
    }

    @Override
    public InputStream getDocument(int id, int version2, ServerSession session) throws OXException {
        return this.getDocument(id, version2, 0L, -1L, session);
    }

    @Override
    public InputStream getDocument(int id, int version2, long offset, long length, ServerSession session) throws OXException {
        DocumentMetadata metadata = this.load(id, version2, session.getContext());
        EffectiveInfostorePermission permission = this.security.getInfostorePermission(session, metadata);
        if (!permission.canReadObject()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        if (null == metadata.getFilestoreLocation()) {
            return Streams.EMPTY_INPUT_STREAM;
        }
        QuotaFileStorage fileStorage = this.getFileStorage(permission.getFolderOwner(), session.getContextId());
        if (0L == offset && -1L == length) {
            return fileStorage.getFile(metadata.getFilestoreLocation());
        }
        return fileStorage.getFile(metadata.getFilestoreLocation(), offset, length);
    }

    private static String getETag(DocumentMetadata metadata) {
        FileID fileID = new FileID(String.valueOf(metadata.getId()));
        fileID.setFolderId(String.valueOf(metadata.getFolderId()));
        return FileStorageUtility.getETagFor((String)fileID.toUniqueID(), (String)String.valueOf(metadata.getVersion()), (Date)metadata.getLastModified());
    }

    @Override
    public DocumentAndMetadata getDocumentAndMetadata(int id, int version2, String clientETag, ServerSession session) throws OXException {
        return this.getDocumentAndMetadata(-1L, id, version2, clientETag, session);
    }

    @Override
    public DocumentAndMetadata getDocumentAndMetadata(long folderId, int id, int version2, String clientETag, ServerSession session) throws OXException {
        Context context = session.getContext();
        DocumentMetadata metadata = this.objectPermissionLoader.add(this.load(id, version2, context), context, null);
        EffectiveInfostorePermission permission = this.security.getInfostorePermission(session, metadata);
        if (!permission.canReadObject()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        if ((long)this.getSharedFilesFolderID(session) == folderId || !permission.canReadObjectInFolder()) {
            metadata.setOriginalFolderId(metadata.getFolderId());
            metadata.setFolderId(this.getSharedFilesFolderID(session));
            metadata.setShareable(false);
        } else {
            metadata.setShareable(permission.canShareObject());
        }
        metadata = this.numberOfVersionsLoader.add(this.lockedUntilLoader.add(metadata, context, null), context, null);
        String eTag = InfostoreFacadeImpl.getETag(metadata);
        if (!Strings.isEmpty((String)clientETag) && clientETag.equals(eTag)) {
            return new DocumentAndMetadataImpl(metadata, null, eTag);
        }
        QuotaFileStorage fileStorage = this.getFileStorage(permission.getFolderOwner(), session.getContextId());
        final String filestoreLocation = metadata.getFilestoreLocation();
        IFileHolder.InputStreamClosure isClosure = new IFileHolder.InputStreamClosure((FileStorage)fileStorage){
            final /* synthetic */ FileStorage val$fileStorage;
            {
                this.val$fileStorage = fileStorage;
            }

            public InputStream newStream() throws OXException, IOException {
                return null == filestoreLocation ? Streams.EMPTY_INPUT_STREAM : this.val$fileStorage.getFile(filestoreLocation);
            }
        };
        return new DocumentAndMetadataImpl(metadata, isClosure, eTag);
    }

    @Override
    public void lock(int id, long diff, ServerSession session) throws OXException {
        Context context = session.getContext();
        User user = session.getUser();
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(session, id);
        if (!infoPerm.canWriteObject()) {
            throw InfostoreExceptionCodes.WRITE_PERMS_FOR_LOCK_MISSING.create();
        }
        DocumentMetadata document = this.checkWriteLock(id, session);
        if (this.lockManager.isLocked(document.getId(), session.getContext(), user)) {
            return;
        }
        long timeout = 0L;
        timeout = timeout == -1L ? -1L : diff;
        this.lockManager.lock(id, timeout, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, session.getUserlogin(), context, user);
        this.touch(id, session);
    }

    @Override
    public void unlock(int id, ServerSession session) throws OXException {
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(session, id);
        if (!infoPerm.canWriteObject()) {
            throw InfostoreExceptionCodes.WRITE_PERMS_FOR_UNLOCK_MISSING.create();
        }
        this.checkMayUnlock(id, session);
        this.lockManager.removeAll(id, session);
        this.touch(id, session);
    }

    @Override
    public void touch(int id, ServerSession session) throws OXException {
        Context context = session.getContext();
        DocumentMetadata oldDocument = this.load(id, -1, context);
        DocumentMetadataImpl document = new DocumentMetadataImpl(oldDocument);
        Metadata[] modifiedColums = new Metadata[]{Metadata.LAST_MODIFIED_LITERAL, Metadata.MODIFIED_BY_LITERAL};
        long sequenceNumber = oldDocument.getSequenceNumber();
        document.setLastModified(new Date());
        document.setModifiedBy(session.getUserId());
        this.perform(new UpdateDocumentAction((DBProvider)this, QUERIES, context, document, oldDocument, modifiedColums, sequenceNumber, (Session)session), true);
        this.perform(new UpdateVersionAction((DBProvider)this, QUERIES, context, document, oldDocument, modifiedColums, sequenceNumber, (Session)session), true);
    }

    @Override
    public Quota getFileQuota(ServerSession session) throws OXException {
        long limit = -1L;
        long usage = -1L;
        limit = AmountQuotas.getLimit((Session)session, (String)"infostore", (ConfigViewFactory)ServerServiceRegistry.getServize(ConfigViewFactory.class, true), (DatabaseService)ServerServiceRegistry.getServize(DatabaseService.class, true));
        if (-1L != limit) {
            usage = this.getUsedQuota(session.getContext());
        }
        return new Quota(limit, usage, Quota.Type.FILE);
    }

    @Override
    public Quota getStorageQuota(ServerSession session) throws OXException {
        long limit = -1L;
        long usage = -1L;
        try {
            limit = this.getFileStorage(session.getUserId(), session.getContextId()).getQuota();
        }
        catch (OXException e) {
            LOG.warn("Error getting file storage quota for context {}", (Object)session.getContextId(), (Object)e);
        }
        if (-1L != limit) {
            usage = this.getFileStorage(session.getUserId(), session.getContextId()).getUsage();
        }
        return new Quota(limit, usage, Quota.Type.STORAGE);
    }

    protected DocumentMetadata load(int id, Context ctx) throws OXException {
        return this.load(id, -1, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentMetadata load(int id, int version2, Context ctx) throws OXException {
        DocumentMetadata documentMetadata;
        InfostoreIterator iterator = null;
        try {
            iterator = InfostoreIterator.loadDocumentIterator(id, version2, this, ctx);
            if (!iterator.hasNext()) {
                throw InfostoreExceptionCodes.DOCUMENT_NOT_EXIST.create();
            }
            documentMetadata = iterator.next();
        }
        catch (Throwable throwable) {
            SearchIterators.close(iterator);
            throw throwable;
        }
        SearchIterators.close((SearchIterator)iterator);
        return documentMetadata;
    }

    private DocumentMetadata checkWriteLock(int id, ServerSession session) throws OXException {
        DocumentMetadata document = this.load(id, -1, session.getContext());
        this.checkWriteLock(document, session);
        return document;
    }

    private void checkWriteLock(DocumentMetadata document, ServerSession session) throws OXException {
        if (document.getModifiedBy() == session.getUserId()) {
            return;
        }
        if (this.lockManager.isLocked(document.getId(), session.getContext(), session.getUser())) {
            throw InfostoreExceptionCodes.CURRENTLY_LOCKED.create();
        }
    }

    private void checkMayUnlock(int id, ServerSession session) throws OXException {
        DocumentMetadata document = this.load(id, -1, session.getContext());
        if (document.getCreatedBy() == session.getUserId() || document.getModifiedBy() == session.getUserId()) {
            return;
        }
        List<Lock> locks = this.lockManager.findLocks(id, (Session)session);
        if (locks.size() > 0) {
            throw InfostoreExceptionCodes.LOCKED_BY_ANOTHER.create();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileStorageFileAccess.IDTuple saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, ServerSession session) throws OXException {
        long usage;
        if (document.getId() != -1) {
            return this.saveDocument(document, data, sequenceNumber, this.nonNull(document), session);
        }
        Context context = session.getContext();
        EffectiveInfostoreFolderPermission targetFolderPermission = this.security.getFolderPermission(session, document.getFolderId());
        if (8 != targetFolderPermission.getPermission().getFolderModule()) {
            throw InfostoreExceptionCodes.NOT_INFOSTORE_FOLDER.create(Autoboxing.L((long)document.getFolderId()));
        }
        if (!targetFolderPermission.canCreateObjects()) {
            throw InfostoreExceptionCodes.NO_CREATE_PERMISSION.create();
        }
        if (null != document.getObjectPermissions() && !targetFolderPermission.canShareOwnObjects()) {
            throw InfostoreExceptionCodes.NO_WRITE_PERMISSION.create();
        }
        Quota storageQuota = this.getFileQuota(session);
        long limit = storageQuota.getLimit();
        if (limit > 0L && (usage = storageQuota.getUsage()) >= limit) {
            throw QuotaExceptionCodes.QUOTA_EXCEEDED_FILES.create(new Object[]{usage, limit});
        }
        this.setDefaults(document);
        this.getValidationChain().validate(session, document);
        CheckSizeSwitch.checkSizes(document, this, context);
        FilenameReserverImpl filenameReserver = null;
        try {
            filenameReserver = new FilenameReserverImpl(context, this);
            FilenameReservation reservation = filenameReserver.reserve(document, true);
            if (reservation.wasAdjusted()) {
                document.setFileName(reservation.getFilename());
                if (reservation.wasSameTitle()) {
                    document.setTitle(reservation.getFilename());
                }
            }
            Connection writeCon = null;
            try {
                this.startDBTransaction();
                writeCon = this.getWriteConnection(context);
                document.setId(this.getId(context, writeCon));
                this.commitDBTransaction();
            }
            catch (SQLException e) {
                throw InfostoreExceptionCodes.NEW_ID_FAILED.create(e, new Object[0]);
            }
            finally {
                this.releaseWriteConnection(context, writeCon);
                this.finishDBTransaction();
            }
            Date now = new Date();
            if (null == document.getLastModified()) {
                document.setLastModified(now);
            }
            if (null == document.getCreationDate()) {
                document.setCreationDate(now);
            }
            document.setCreatedBy(session.getUserId());
            document.setModifiedBy(session.getUserId());
            if (null != data) {
                document.setVersion(1);
            } else {
                document.setVersion(0);
            }
            this.perform(new CreateDocumentAction(this, QUERIES, context, Collections.singletonList(document), session), true);
            this.perform(new CreateObjectPermissionAction(this, context, document), true);
            DocumentMetadataImpl version0 = new DocumentMetadataImpl(document);
            version0.setFileName(null);
            version0.setFileSize(0L);
            version0.setFileMD5Sum(null);
            version0.setFileMIMEType(null);
            version0.setVersion(0);
            version0.setFilestoreLocation(null);
            this.perform(new CreateVersionAction(this, QUERIES, context, Collections.singletonList(version0), session), true);
            if (data != null) {
                SaveFileAction saveFile = new SaveFileAction((FileStorage)this.getFileStorage(targetFolderPermission.getFolderOwner(), session.getContextId()), data, document.getFileSize());
                this.perform(saveFile, false);
                document.setVersion(1);
                document.setFilestoreLocation(saveFile.getFileStorageID());
                document.setFileMD5Sum(saveFile.getChecksum());
                document.setFileSize(saveFile.getByteCount());
                this.perform(new CreateVersionAction(this, QUERIES, context, Collections.singletonList(document), session), true);
            }
            FileStorageFileAccess.IDTuple iDTuple = new FileStorageFileAccess.IDTuple(String.valueOf(document.getFolderId()), String.valueOf(document.getId()));
            return iDTuple;
        }
        finally {
            if (null != filenameReserver) {
                filenameReserver.cleanUp();
            }
        }
    }

    private long getUsedQuota(Context context) throws OXException {
        long l;
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = this.getReadConnection(context);
            stmt = readCon.prepareStatement("SELECT COUNT(id) from infostore where cid=?");
            stmt.setLong(1, context.getContextId());
            rs = stmt.executeQuery();
            l = rs.next() ? rs.getLong(1) : -1L;
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, stmt);
                if (null != readCon) {
                    this.releaseReadConnection(context, readCon);
                }
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        if (null != readCon) {
            this.releaseReadConnection(context, readCon);
        }
        return l;
    }

    private void setDefaults(DocumentMetadata document) {
        if (document.getTitle() == null || "".equals(document.getTitle())) {
            document.setTitle(document.getFileName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T performQuery(Context ctx, String query, ResultProcessor<T> rsp, Object ... args) throws SQLException, OXException {
        T t;
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement(query);
            for (int i = 0; i < args.length; ++i) {
                stmt.setObject(i + 1, args[i]);
            }
            rs = stmt.executeQuery();
            t = rsp.process(rs);
        }
        catch (Throwable throwable) {
            this.close(stmt, rs);
            if (readCon != null) {
                this.releaseReadConnection(ctx, readCon);
            }
            throw throwable;
        }
        this.close(stmt, rs);
        if (readCon != null) {
            this.releaseReadConnection(ctx, readCon);
        }
        return t;
    }

    private int getNextVersionNumberForInfostoreObject(int cid, int infostore_id, Connection con) throws SQLException {
        int delVersion;
        int retval = 0;
        PreparedStatement stmt = con.prepareStatement("SELECT MAX(version_number) FROM infostore_document WHERE cid=? AND infostore_id=?");
        stmt.setInt(1, cid);
        stmt.setInt(2, infostore_id);
        ResultSet result = stmt.executeQuery();
        if (result.next()) {
            retval = result.getInt(1);
        }
        result.close();
        stmt.close();
        stmt = con.prepareStatement("SELECT MAX(version_number) FROM del_infostore_document WHERE cid=? AND infostore_id=?");
        stmt.setInt(1, cid);
        stmt.setInt(2, infostore_id);
        result = stmt.executeQuery();
        if (result.next() && (delVersion = result.getInt(1)) > retval) {
            retval = delVersion;
        }
        result.close();
        stmt.close();
        return retval + 1;
    }

    protected QuotaFileStorage getFileStorage(int folderOwner, int contextId) throws OXException {
        QuotaFileStorageService storageService = QFS_REF.get();
        if (null == storageService) {
            throw ServiceExceptionCode.absentService(QuotaFileStorageService.class);
        }
        return storageService.getQuotaFileStorage(folderOwner, contextId);
    }

    private Metadata[] nonNull(DocumentMetadata document) {
        ArrayList<Metadata> nonNull = new ArrayList<Metadata>();
        GetSwitch get = new GetSwitch(document);
        for (Metadata metadata : Metadata.HTTPAPI_VALUES) {
            if (null == metadata.doSwitch(get)) continue;
            nonNull.add(metadata);
        }
        return nonNull.toArray(new Metadata[nonNull.size()]);
    }

    @Override
    public FileStorageFileAccess.IDTuple saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, Metadata[] modifiedColumns, ServerSession session) throws OXException {
        return this.saveDocument(document, data, sequenceNumber, modifiedColumns, false, session);
    }

    @Override
    public FileStorageFileAccess.IDTuple saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, Metadata[] modifiedColumns, boolean ignoreVersion, ServerSession session) throws OXException {
        return this.saveDocument(document, data, sequenceNumber, modifiedColumns, ignoreVersion, -1L, session);
    }

    @Override
    public FileStorageFileAccess.IDTuple saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, Metadata[] modifiedColumns, long offset, ServerSession session) throws OXException {
        return this.saveDocument(document, data, sequenceNumber, modifiedColumns, true, offset, session);
    }

    protected FileStorageFileAccess.IDTuple saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, Metadata[] modifiedColumns, boolean ignoreVersion, long offset, ServerSession session) throws OXException {
        if (!(0L >= offset || -1 != document.getId() && ignoreVersion)) {
            throw InfostoreExceptionCodes.NO_OFFSET_FOR_NEW_VERSIONS.create();
        }
        if (document.getId() == -1) {
            return this.saveDocument(document, data, sequenceNumber, session);
        }
        Context context = session.getContext();
        int sharedFilesFolderID = this.getSharedFilesFolderID(session);
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(session, document.getId());
        if (!infoPerm.canWriteObject() || Arrays.contains((Object[])modifiedColumns, (Object)Metadata.OBJECT_PERMISSIONS_LITERAL) && (document.getFolderId() == (long)sharedFilesFolderID || !infoPerm.canShareObject())) {
            throw InfostoreExceptionCodes.NO_WRITE_PERMISSION.create();
        }
        ArrayList sanitizedColumns = new ArrayList(modifiedColumns.length);
        Collections.addAll(sanitizedColumns, modifiedColumns);
        if (sanitizedColumns.contains(Metadata.FOLDER_ID_LITERAL)) {
            long folderId = document.getFolderId();
            if (folderId == (long)sharedFilesFolderID) {
                document.setFolderId(infoPerm.getObject().getFolderId());
                sanitizedColumns.remove(Metadata.FOLDER_ID_LITERAL);
                modifiedColumns = sanitizedColumns.toArray(new Metadata[sanitizedColumns.size()]);
            } else if (document.getFolderId() != -1L && infoPerm.getObject().getFolderId() != document.getFolderId()) {
                EffectiveInfostoreFolderPermission targetFolderPermission = this.security.getFolderPermission(session, document.getFolderId());
                if (8 != targetFolderPermission.getPermission().getFolderModule()) {
                    throw InfostoreExceptionCodes.NOT_INFOSTORE_FOLDER.create(Autoboxing.L((long)folderId));
                }
                if (!targetFolderPermission.canCreateObjects()) {
                    throw InfostoreExceptionCodes.NO_CREATE_PERMISSION.create();
                }
                if (!infoPerm.canDeleteObject()) {
                    throw InfostoreExceptionCodes.NO_SOURCE_DELETE_PERMISSION.create();
                }
            }
        }
        HashSet<Metadata> updatedCols = new HashSet<Metadata>(java.util.Arrays.asList(modifiedColumns));
        updatedCols.removeAll(java.util.Arrays.asList(Metadata.CREATED_BY_LITERAL, Metadata.CREATION_DATE_LITERAL, Metadata.ID_LITERAL));
        if (!updatedCols.contains(Metadata.LAST_MODIFIED_LITERAL) || null == document.getLastModified()) {
            document.setLastModified(new Date());
        }
        document.setModifiedBy(session.getUserId());
        updatedCols.add(Metadata.LAST_MODIFIED_LITERAL);
        updatedCols.add(Metadata.MODIFIED_BY_LITERAL);
        CheckSizeSwitch.checkSizes(document, this, context);
        this.getValidationChain().validate(session, document);
        DocumentMetadata oldDocument = this.objectPermissionLoader.add(this.checkWriteLock(document.getId(), session), session.getContext(), null);
        SaveParameters saveParameters = new SaveParameters(context, session, document, oldDocument, sequenceNumber, updatedCols, infoPerm.getFolderOwner());
        saveParameters.setData(data, offset, session.getUserId(), ignoreVersion);
        this.saveModifiedDocument(saveParameters);
        return new FileStorageFileAccess.IDTuple(String.valueOf(document.getFolderId()), String.valueOf(document.getId()));
    }

    @Override
    public FileStorageFileAccess.IDTuple saveDocumentMetadata(DocumentMetadata document, long sequenceNumber, Metadata[] modifiedColumns, Context context) throws OXException {
        if (document.getId() == -1) {
            throw InfostoreExceptionCodes.DOCUMENT_NOT_EXIST.create();
        }
        long folderId = document.getFolderId();
        if (folderId < 0L) {
            throw InfostoreExceptionCodes.NOT_INFOSTORE_FOLDER.create(folderId);
        }
        if (folderId < 20L) {
            throw InfostoreExceptionCodes.NO_DOCUMENTS_IN_VIRTUAL_FOLDER.create();
        }
        HashSet<Metadata> updatedCols = new HashSet<Metadata>();
        Collections.addAll(updatedCols, modifiedColumns == null ? Metadata.VALUES_ARRAY : modifiedColumns);
        if (!updatedCols.contains(Metadata.LAST_MODIFIED_LITERAL)) {
            document.setLastModified(new Date());
            updatedCols.add(Metadata.LAST_MODIFIED_LITERAL);
        }
        if (!updatedCols.contains(Metadata.MODIFIED_BY_LITERAL)) {
            document.setModifiedBy(context.getMailadmin());
            updatedCols.add(Metadata.MODIFIED_BY_LITERAL);
        }
        CheckSizeSwitch.checkSizes(document, this, context);
        DocumentMetadata oldDocument = this.objectPermissionLoader.add(this.load(document.getId(), context), context, null);
        return this.saveModifiedDocument(new SaveParameters(context, null, document, oldDocument, sequenceNumber, updatedCols, this.security.getFolderOwner(folderId, context)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStorageFileAccess.IDTuple saveModifiedDocument(SaveParameters parameters) throws OXException {
        FilenameReserver filenameReserver = null;
        try {
            Metadata[] modifiedCols;
            boolean isRename;
            Set<Metadata> updatedCols = parameters.getUpdatedCols();
            DocumentMetadata document = parameters.getDocument();
            DocumentMetadata oldDocument = parameters.getOldDocument();
            Context context = parameters.getContext();
            ServerSession session = parameters.getSession();
            int checkedVersion = -1;
            if (updatedCols.contains(Metadata.VERSION_LITERAL)) {
                String fname = this.load(document.getId(), document.getVersion(), context).getFileName();
                checkedVersion = document.getVersion();
                if (!updatedCols.contains(Metadata.FILENAME_LITERAL)) {
                    updatedCols.add(Metadata.FILENAME_LITERAL);
                    document.setFileName(fname);
                }
            }
            boolean isMove = updatedCols.contains(Metadata.FOLDER_ID_LITERAL) && oldDocument.getFolderId() != document.getFolderId();
            boolean bl = isRename = updatedCols.contains(Metadata.FILENAME_LITERAL) && null != document.getFileName() && false == document.getFileName().equals(oldDocument.getFileName());
            if (isMove) {
                String newFileName = null != document.getFileName() ? document.getFileName() : oldDocument.getFileName();
                DocumentMetadataImpl placeHolder = new DocumentMetadataImpl(oldDocument.getId());
                placeHolder.setFolderId(document.getFolderId());
                placeHolder.setFileName(newFileName);
                if (null == filenameReserver) {
                    filenameReserver = new FilenameReserverImpl(context, this.db);
                }
                FilenameReservation reservation = filenameReserver.reserve(placeHolder, true);
                document.setFileName(reservation.getFilename());
                updatedCols.add(Metadata.FILENAME_LITERAL);
                DocumentMetadataImpl tombstoneDocument = new DocumentMetadataImpl(oldDocument);
                tombstoneDocument.setLastModified(document.getLastModified());
                tombstoneDocument.setModifiedBy(document.getModifiedBy());
                this.perform(new ReplaceDocumentIntoDelTableAction((DBProvider)this, QUERIES, context, tombstoneDocument, (Session)session), true);
                document.setObjectPermissions(null);
                updatedCols.add(Metadata.OBJECT_PERMISSIONS_LITERAL);
            } else if (isRename) {
                DocumentMetadataImpl placeHolder = new DocumentMetadataImpl(oldDocument.getId());
                placeHolder.setFolderId(oldDocument.getFolderId());
                placeHolder.setFileName(document.getFileName());
                if (null == filenameReserver) {
                    filenameReserver = new FilenameReserverImpl(context, this.db);
                }
                FilenameReservation reservation = filenameReserver.reserve(placeHolder, true);
                document.setFileName(reservation.getFilename());
                updatedCols.add(Metadata.FILENAME_LITERAL);
            }
            String oldTitle = oldDocument.getTitle();
            if (!updatedCols.contains(Metadata.TITLE_LITERAL) && oldDocument.getFileName() != null && oldTitle != null && oldDocument.getFileName().equals(oldTitle)) {
                if (null == document.getFileName()) {
                    document.setTitle(oldDocument.getFileName());
                    document.setFileName(oldDocument.getFileName());
                    updatedCols.add(Metadata.FILENAME_LITERAL);
                } else {
                    document.setTitle(document.getFileName());
                }
                updatedCols.add(Metadata.TITLE_LITERAL);
            }
            if (isMove) {
                VersionControlUtil.doVersionControl(this, Collections.singletonList(document), Collections.singletonList(oldDocument), document.getFolderId(), context);
            }
            if (parameters.hasData()) {
                this.storeNewData(parameters);
                modifiedCols = updatedCols.toArray(new Metadata[updatedCols.size()]);
            } else {
                modifiedCols = updatedCols.toArray(new Metadata[updatedCols.size()]);
                if (QUERIES.updateVersion(modifiedCols)) {
                    if (!updatedCols.contains(Metadata.VERSION_LITERAL)) {
                        document.setVersion(oldDocument.getVersion());
                    }
                    if (checkedVersion > 0 && checkedVersion != document.getVersion()) {
                        this.load(document.getId(), document.getVersion(), context);
                    }
                    this.perform(new UpdateVersionAction((DBProvider)this, QUERIES, context, document, oldDocument, modifiedCols, parameters.getSequenceNumber(), (Session)session), true);
                }
            }
            if (QUERIES.updateDocument(modifiedCols)) {
                this.perform(new UpdateDocumentAction((DBProvider)this, QUERIES, context, document, oldDocument, modifiedCols, Long.MAX_VALUE, (Session)session), true);
            }
            if (updatedCols.contains(Metadata.OBJECT_PERMISSIONS_LITERAL)) {
                this.rememberForGuestCleanup(context.getContextId(), Collections.singletonList(oldDocument));
                this.perform(new UpdateObjectPermissionAction(this, context, document, oldDocument), true);
            }
            FileStorageFileAccess.IDTuple iDTuple = new FileStorageFileAccess.IDTuple(String.valueOf(document.getFolderId()), String.valueOf(document.getId()));
            return iDTuple;
        }
        finally {
            if (null != filenameReserver) {
                filenameReserver.cleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeNewData(SaveParameters parameters) throws OXException {
        AbstractDocumentListAction action;
        QuotaFileStorage qfs = this.getFileStorage(parameters.getOptFolderAdmin(), parameters.getContext().getContextId());
        if (0L < parameters.getOffset()) {
            AppendFileAction appendFile = new AppendFileAction((FileStorage)qfs, parameters.getData(), parameters.getOldDocument().getFilestoreLocation(), parameters.getDocument().getFileSize(), parameters.getOffset());
            this.perform(appendFile, false);
            parameters.getDocument().setFilestoreLocation(parameters.getOldDocument().getFilestoreLocation());
            parameters.getDocument().setFileSize(appendFile.getByteCount() + parameters.getOffset());
            parameters.getDocument().setFileMD5Sum(null);
            parameters.getUpdatedCols().addAll(java.util.Arrays.asList(Metadata.FILE_MD5SUM_LITERAL, Metadata.FILE_SIZE_LITERAL));
        } else {
            SaveFileAction saveFile = new SaveFileAction((FileStorage)qfs, parameters.getData(), parameters.getDocument().getFileSize());
            this.perform(saveFile, false);
            parameters.getDocument().setFilestoreLocation(saveFile.getFileStorageID());
            parameters.getDocument().setFileSize(saveFile.getByteCount());
            parameters.getDocument().setFileMD5Sum(saveFile.getChecksum());
            parameters.getUpdatedCols().addAll(java.util.Arrays.asList(Metadata.FILE_MD5SUM_LITERAL, Metadata.FILE_SIZE_LITERAL, Metadata.FILESTORE_LOCATION_LITERAL));
        }
        GetSwitch get = new GetSwitch(parameters.getOldDocument());
        SetSwitch set = new SetSwitch(parameters.getDocument());
        for (Metadata m : new Metadata[]{Metadata.DESCRIPTION_LITERAL, Metadata.TITLE_LITERAL, Metadata.FILENAME_LITERAL, Metadata.URL_LITERAL}) {
            if (parameters.getUpdatedCols().contains(m)) continue;
            set.setValue(m.doSwitch(get));
            m.doSwitch(set);
        }
        parameters.getDocument().setCreatedBy(parameters.getFileCreatedBy());
        if (!parameters.getUpdatedCols().contains(Metadata.CREATION_DATE_LITERAL)) {
            parameters.getDocument().setCreationDate(new Date());
        }
        ServerSession session = parameters.getSession();
        if (parameters.isIgnoreVersion()) {
            parameters.getDocument().setVersion(parameters.getOldDocument().getVersion());
            parameters.getUpdatedCols().add(Metadata.VERSION_LITERAL);
            parameters.getUpdatedCols().add(Metadata.FILESTORE_LOCATION_LITERAL);
            action = new UpdateVersionAction((DBProvider)this, QUERIES, parameters.getContext(), parameters.getDocument(), parameters.getOldDocument(), parameters.getUpdatedCols().toArray(new Metadata[parameters.getUpdatedCols().size()]), parameters.getSequenceNumber(), (Session)session);
            if (0L >= parameters.getOffset()) {
                this.removeFile(parameters.getContext(), parameters.getOldDocument().getFilestoreLocation(), this.security.getFolderOwner(parameters.getOldDocument(), parameters.getContext()));
            }
        } else {
            Connection con = null;
            try {
                con = this.getReadConnection(parameters.getContext());
                parameters.getDocument().setVersion(this.getNextVersionNumberForInfostoreObject(parameters.getContext().getContextId(), parameters.getDocument().getId(), con));
                parameters.getUpdatedCols().add(Metadata.VERSION_LITERAL);
            }
            catch (SQLException e) {
                LOG.error("SQLException: ", (Throwable)e);
            }
            finally {
                this.releaseReadConnection(parameters.getContext(), con);
            }
            action = new CreateVersionAction(this, QUERIES, parameters.getContext(), Collections.singletonList(parameters.getDocument()), session);
        }
        this.perform(action, true);
    }

    @Override
    public void removeDocument(long folderId, long date, ServerSession session) throws OXException {
        if (folderId == (long)this.getSharedFilesFolderID(session)) {
            throw InfostoreExceptionCodes.NO_DELETE_PERMISSION.create();
        }
        Context context = session.getContext();
        String whereClause = "infostore.folder_id = " + folderId;
        List<DocumentMetadata> allDocuments = InfostoreIterator.allDocumentsWhere(whereClause, Metadata.VALUES_ARRAY, this, context).asList();
        if (0 < allDocuments.size()) {
            List<DocumentMetadata> allVersions = InfostoreIterator.allVersionsWhere(whereClause, Metadata.VALUES_ARRAY, this, context).asList();
            this.objectPermissionLoader.add(allDocuments, context, this.objectPermissionLoader.load(folderId, context));
            this.removeDocuments(allDocuments, allVersions, date, session, null);
        }
    }

    protected void removeDocuments(List<DocumentMetadata> allDocuments, List<DocumentMetadata> allVersions, long date, ServerSession session, List<DocumentMetadata> rejected) throws OXException {
        ArrayList<DocumentMetadata> delDocs = new ArrayList<DocumentMetadata>();
        ArrayList<DocumentMetadata> delVers = new ArrayList<DocumentMetadata>();
        HashSet<Integer> rejectedIds = new HashSet<Integer>();
        Date now = new Date();
        for (DocumentMetadata m : allDocuments) {
            if (m.getSequenceNumber() > date) {
                if (rejected == null) {
                    throw InfostoreExceptionCodes.NOT_ALL_DELETED.create();
                }
                rejected.add(m);
                rejectedIds.add(m.getId());
                continue;
            }
            this.checkWriteLock(m, session);
            m.setLastModified(now);
            delDocs.add(m);
        }
        Context context = session.getContext();
        this.perform(new ReplaceDocumentIntoDelTableAction((DBProvider)this, QUERIES, context, delDocs, (Session)session), true);
        ArrayList<String> filestoreLocations = new ArrayList<String>(allVersions.size());
        TIntLinkedList folderAdmins = new TIntLinkedList();
        for (DocumentMetadata m : allVersions) {
            if (rejectedIds.contains(m.getId())) continue;
            delVers.add(m);
            m.setLastModified(now);
            if (null == m.getFilestoreLocation()) continue;
            filestoreLocations.add(m.getFilestoreLocation());
            folderAdmins.add(this.security.getFolderOwners(Collections.singletonList(m), context));
        }
        this.removeFiles(context, filestoreLocations, folderAdmins.toArray());
        this.perform(new DeleteVersionAction((DBProvider)this, QUERIES, context, delVers, (Session)session), true);
        this.perform(new DeleteDocumentAction((DBProvider)this, QUERIES, context, delDocs, (Session)session), true);
        this.perform(new DeleteObjectPermissionAction(this, context, delDocs), true);
        this.rememberForGuestCleanup(context.getContextId(), delDocs);
    }

    private void removeFile(Context context, String filestoreLocation, int folderAdmin) throws OXException {
        this.removeFiles(context, Collections.singletonList(filestoreLocation), new int[]{folderAdmin});
    }

    private void removeFiles(Context context, List<String> filestoreLocations, int[] folderAdmins) throws OXException {
        block4: {
            int size;
            if (null == filestoreLocations || 0 >= (size = filestoreLocations.size())) break block4;
            int contextId = context.getContextId();
            List<FileRemoveInfo> removeList = this.fileIdRemoveList.get();
            if (null != removeList) {
                for (int i = 0; i < size; ++i) {
                    removeList.add(new FileRemoveInfo(filestoreLocations.get(i), folderAdmins[i], contextId));
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    this.getFileStorage(folderAdmins[i], contextId).deleteFile(filestoreLocations.get(i));
                }
            }
        }
    }

    private void rememberForGuestCleanup(int contextID, List<DocumentMetadata> removedDocuments) {
        if (null != removedDocuments && 0 < removedDocuments.size()) {
            for (DocumentMetadata document : removedDocuments) {
                List<ObjectPermission> objectPermissions = document.getObjectPermissions();
                if (null == objectPermissions || 0 >= objectPermissions.size()) continue;
                Map<Integer, Set<Integer>> cleanupList = this.guestCleanupList.get();
                Set<Integer> entities = cleanupList.get(Autoboxing.I((int)contextID));
                if (null == entities) {
                    entities = new HashSet<Integer>(objectPermissions.size());
                    cleanupList.put(Autoboxing.I((int)contextID), entities);
                }
                for (ObjectPermission permission : objectPermissions) {
                    if (permission.isGroup()) continue;
                    entities.add(Autoboxing.I((int)permission.getEntity()));
                }
            }
        }
    }

    private static List<DocumentMetadata> getAllDocuments(DBProvider provider, Context context, int[] ids, Metadata[] metadata) throws OXException {
        if (null == ids || 0 == ids.length) {
            return Collections.emptyList();
        }
        if (1 == ids.length) {
            return InfostoreIterator.allDocumentsWhere("infostore.id = " + ids[0], metadata, provider, context).asList();
        }
        StringBuilder StringBuilder2 = new StringBuilder("infostore.id IN (");
        StringBuilder2.append(String.valueOf(ids[0]));
        for (int i = 1; i < ids.length; ++i) {
            StringBuilder2.append(',').append(String.valueOf(ids[i]));
        }
        StringBuilder2.append(')');
        return InfostoreIterator.allDocumentsWhere(StringBuilder2.toString(), metadata, provider, context).asList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DocumentMetadata> moveDocuments(ServerSession session, List<DocumentMetadata> documents, long destinationFolderID, long sequenceNumber, boolean adjustFilenamesAsNeeded) throws OXException {
        UserPermissionBits permissionBits;
        User user;
        Context context = session.getContext();
        EffectiveInfostoreFolderPermission destinationFolderPermission = this.security.getFolderPermission(destinationFolderID, context, user = session.getUser(), permissionBits = session.getUserPermissionBits());
        if (!destinationFolderPermission.canCreateObjects()) {
            throw InfostoreExceptionCodes.NO_CREATE_PERMISSION.create();
        }
        LinkedList<DocumentMetadata> rejectedDocuments = new LinkedList<DocumentMetadata>();
        ArrayList<DocumentMetadata> sourceDocuments = new ArrayList<DocumentMetadata>(documents.size());
        List<EffectiveInfostorePermission> permissions = this.security.getInfostorePermissions(documents, context, user, permissionBits);
        for (EffectiveInfostorePermission permission : permissions) {
            if (permission.canDeleteObject()) continue;
            throw InfostoreExceptionCodes.NO_DELETE_PERMISSION.create();
        }
        for (DocumentMetadata document : documents) {
            this.checkWriteLock(document, session);
            if (document.getSequenceNumber() <= sequenceNumber) {
                sourceDocuments.add(document);
                continue;
            }
            rejectedDocuments.add(document);
        }
        int numberOfDocuments = sourceDocuments.size();
        if (0 < numberOfDocuments) {
            Date now = new Date();
            Connection readConnection = null;
            FilenameReserverImpl filenameReserver = new FilenameReserverImpl(session.getContext(), this);
            try {
                readConnection = this.getReadConnection(context);
                ArrayList<DocumentMetadata> tombstoneDocuments = new ArrayList<DocumentMetadata>(numberOfDocuments);
                ArrayList<DocumentMetadata> documentsToUpdate = new ArrayList<DocumentMetadata>(numberOfDocuments);
                ArrayList<DocumentMetadata> versionsToUpdate = new ArrayList<DocumentMetadata>();
                ArrayList<DocumentMetadata> objectPermissionsToDelete = new ArrayList<DocumentMetadata>();
                for (DocumentMetadata document : sourceDocuments) {
                    DocumentMetadataImpl documentToUpdate = new DocumentMetadataImpl(document);
                    documentToUpdate.setLastModified(now);
                    documentToUpdate.setModifiedBy(session.getUserId());
                    documentToUpdate.setFolderId(destinationFolderID);
                    documentsToUpdate.add(documentToUpdate);
                    DocumentMetadataImpl tombstoneDocument = new DocumentMetadataImpl(document);
                    tombstoneDocument.setLastModified(now);
                    tombstoneDocument.setModifiedBy(session.getUserId());
                    tombstoneDocuments.add(tombstoneDocument);
                    if (null == document.getObjectPermissions() || 0 >= document.getObjectPermissions().size()) continue;
                    objectPermissionsToDelete.add(document);
                }
                Map<DocumentMetadata, FilenameReservation> reservations = filenameReserver.reserve(documentsToUpdate, adjustFilenamesAsNeeded);
                if (adjustFilenamesAsNeeded) {
                    for (Map.Entry<DocumentMetadata, FilenameReservation> entry : reservations.entrySet()) {
                        FilenameReservation reservation = entry.getValue();
                        if (!reservation.wasAdjusted()) continue;
                        DocumentMetadata document = entry.getKey();
                        if (reservation.wasSameTitle()) {
                            document.setTitle(reservation.getFilename());
                        }
                        document.setFileName(reservation.getFilename());
                        versionsToUpdate.add(document);
                    }
                }
                this.perform(new ReplaceDocumentIntoDelTableAction((DBProvider)this, QUERIES, session.getContext(), tombstoneDocuments, (Session)session), true);
                VersionControlUtil.doVersionControl(this, documentsToUpdate, sourceDocuments, destinationFolderID, context);
                this.perform(new UpdateDocumentAction((DBProvider)this, QUERIES, session.getContext(), documentsToUpdate, sourceDocuments, new Metadata[]{Metadata.LAST_MODIFIED_LITERAL, Metadata.MODIFIED_BY_LITERAL, Metadata.FOLDER_ID_LITERAL}, sequenceNumber, (Session)session), true);
                if (0 < objectPermissionsToDelete.size()) {
                    this.perform(new DeleteObjectPermissionAction(this, context, objectPermissionsToDelete), true);
                    this.rememberForGuestCleanup(context.getContextId(), objectPermissionsToDelete);
                }
                if (0 < versionsToUpdate.size()) {
                    this.perform(new UpdateVersionAction((DBProvider)this, QUERIES, session.getContext(), versionsToUpdate, sourceDocuments, new Metadata[]{Metadata.FILENAME_LITERAL, Metadata.TITLE_LITERAL}, sequenceNumber, (Session)session), true);
                }
            }
            finally {
                filenameReserver.cleanUp();
                if (null != readConnection) {
                    this.releaseReadConnection(context, readConnection);
                }
            }
        }
        return rejectedDocuments;
    }

    @Override
    public List<FileStorageFileAccess.IDTuple> moveDocuments(ServerSession session, List<FileStorageFileAccess.IDTuple> ids, long sequenceNumber, String targetFolderID, boolean adjustFilenamesAsNeeded) throws OXException {
        long destinationFolderID;
        if (null == ids || 0 == ids.size()) {
            return Collections.emptyList();
        }
        try {
            destinationFolderID = Long.parseLong(targetFolderID);
        }
        catch (NumberFormatException e) {
            throw InfostoreExceptionCodes.NOT_INFOSTORE_FOLDER.create(targetFolderID, e);
        }
        int[] objectIDs = Tools.getObjectIDArray(ids);
        List<DocumentMetadata> allDocuments = InfostoreFacadeImpl.getAllDocuments(this, session.getContext(), objectIDs, Metadata.VALUES_ARRAY);
        this.objectPermissionLoader.add(allDocuments, session.getContext(), Tools.getIDs(allDocuments));
        Map<Integer, Long> idsToFolders = Tools.getIDsToFolders(ids);
        for (DocumentMetadata document : allDocuments) {
            Long requestedFolder = idsToFolders.get(document.getId());
            long expectedFolder = document.getFolderId();
            if (requestedFolder != null && requestedFolder == expectedFolder) continue;
            throw InfostoreExceptionCodes.NOT_EXIST.create();
        }
        List<DocumentMetadata> rejectedDocuments = this.moveDocuments(session, allDocuments, destinationFolderID, sequenceNumber, adjustFilenamesAsNeeded);
        if (null == rejectedDocuments || 0 == rejectedDocuments.size()) {
            return Collections.emptyList();
        }
        ArrayList<FileStorageFileAccess.IDTuple> rejectedIDs = new ArrayList<FileStorageFileAccess.IDTuple>();
        for (DocumentMetadata rejected : rejectedDocuments) {
            rejectedIDs.add(new FileStorageFileAccess.IDTuple(Long.toString(rejected.getFolderId()), Integer.toString(rejected.getId())));
        }
        return rejectedIDs;
    }

    @Override
    public List<FileStorageFileAccess.IDTuple> removeDocument(List<FileStorageFileAccess.IDTuple> ids, long date, ServerSession session) throws OXException {
        String whereClause;
        if (null == ids || 0 == ids.size()) {
            return Collections.emptyList();
        }
        Map<Integer, Long> idsToFolders = Tools.getIDsToFolders(ids);
        Context context = session.getContext();
        User user = session.getUser();
        UserPermissionBits userPermissionBits = session.getUserPermissionBits();
        Set<Integer> objectIDs = idsToFolders.keySet();
        if (1 == objectIDs.size()) {
            whereClause = "infostore.id=" + objectIDs.iterator().next();
        } else {
            StringBuilder stringBuilder = new StringBuilder("infostore.id IN (");
            Strings.join(objectIDs, (String)",", (StringBuilder)stringBuilder);
            whereClause = stringBuilder.append(')').toString();
        }
        List<DocumentMetadata> allDocuments = InfostoreIterator.allDocumentsWhere(whereClause, Metadata.VALUES_ARRAY, this, context).asList();
        List<DocumentMetadata> allVersions = InfostoreIterator.allVersionsWhere(whereClause, Metadata.VALUES_ARRAY, this, context).asList();
        this.objectPermissionLoader.add(allDocuments, context, idsToFolders.keySet());
        for (DocumentMetadata document : allDocuments) {
            Long requestedFolder = idsToFolders.get(document.getId());
            long expectedFolder = document.getFolderId();
            if (requestedFolder != null && requestedFolder == expectedFolder) continue;
            throw InfostoreExceptionCodes.NOT_EXIST.create();
        }
        List<EffectiveInfostorePermission> permissions = this.security.getInfostorePermissions(allDocuments, context, user, userPermissionBits);
        for (EffectiveInfostorePermission permission : permissions) {
            if (permission.canDeleteObject()) continue;
            throw InfostoreExceptionCodes.NO_DELETE_PERMISSION.create();
        }
        HashSet<Integer> unknownDocuments = new HashSet<Integer>(idsToFolders.keySet());
        for (DocumentMetadata document : allDocuments) {
            unknownDocuments.remove(document.getId());
        }
        ArrayList<DocumentMetadata> rejectedDocuments = new ArrayList<DocumentMetadata>();
        this.removeDocuments(allDocuments, allVersions, date, session, rejectedDocuments);
        ArrayList<FileStorageFileAccess.IDTuple> rejectedIDs = new ArrayList<FileStorageFileAccess.IDTuple>(rejectedDocuments.size() + unknownDocuments.size());
        for (DocumentMetadata rejected : rejectedDocuments) {
            rejectedIDs.add(new FileStorageFileAccess.IDTuple(Long.toString(rejected.getFolderId()), Integer.toString(rejected.getId())));
        }
        for (Integer notFound : unknownDocuments) {
            rejectedIDs.add(new FileStorageFileAccess.IDTuple(idsToFolders.get(notFound).toString(), Integer.toString(notFound)));
        }
        return rejectedIDs;
    }

    @Override
    public void removeDocuments(List<FileStorageFileAccess.IDTuple> ids, Context context) throws OXException {
        String whereClause;
        if (null == ids || 0 == ids.size()) {
            return;
        }
        Map<Integer, Long> idsToFolders = Tools.getIDsToFolders(ids);
        Set<Integer> objectIDs = idsToFolders.keySet();
        if (1 == objectIDs.size()) {
            whereClause = "infostore.id=" + objectIDs.iterator().next();
        } else {
            StringBuilder stringBuilder = new StringBuilder("infostore.id IN (");
            Strings.join(objectIDs, (String)",", (StringBuilder)stringBuilder);
            whereClause = stringBuilder.append(')').toString();
        }
        List<DocumentMetadata> allDocuments = InfostoreIterator.allDocumentsWhere(whereClause, Metadata.VALUES_ARRAY, this, context).asList();
        List<DocumentMetadata> allVersions = InfostoreIterator.allVersionsWhere(whereClause, Metadata.VALUES_ARRAY, this, context).asList();
        for (DocumentMetadata document : allDocuments) {
            Long requestedFolder = idsToFolders.get(document.getId());
            long expectedFolder = document.getFolderId();
            if (requestedFolder != null && requestedFolder == expectedFolder) continue;
            throw InfostoreExceptionCodes.NOT_EXIST.create();
        }
        HashSet<Integer> unknownDocuments = new HashSet<Integer>(idsToFolders.keySet());
        for (DocumentMetadata document : allDocuments) {
            unknownDocuments.remove(document.getId());
        }
        if (!unknownDocuments.isEmpty()) {
            throw InfostoreExceptionCodes.NOT_EXIST.create();
        }
        this.perform(new ReplaceDocumentIntoDelTableAction((DBProvider)this, QUERIES, context, allDocuments, null), true);
        ArrayList<String> filestoreLocations = new ArrayList<String>(allVersions.size());
        TIntLinkedList folderAdmins = new TIntLinkedList();
        for (DocumentMetadata m : allVersions) {
            if (null == m.getFilestoreLocation()) continue;
            filestoreLocations.add(m.getFilestoreLocation());
            folderAdmins.add(this.security.getFolderOwners(Collections.singletonList(m), context));
        }
        this.removeFiles(context, filestoreLocations, folderAdmins.toArray());
        this.perform(new DeleteVersionAction((DBProvider)this, QUERIES, context, allVersions, null), true);
        this.perform(new DeleteDocumentAction((DBProvider)this, QUERIES, context, allDocuments, null), true);
        this.perform(new DeleteObjectPermissionAction(this, context, allDocuments), true);
        this.rememberForGuestCleanup(context.getContextId(), allDocuments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] removeVersion(int id, int[] versionIds, ServerSession session) throws OXException {
        if (null == versionIds || 0 == versionIds.length) {
            return new int[0];
        }
        Context context = session.getContext();
        DocumentMetadata metadata = this.objectPermissionLoader.add(this.load(id, -1, context), context, null);
        try {
            this.checkWriteLock(metadata, session);
        }
        catch (OXException x) {
            return versionIds;
        }
        EffectiveInfostorePermission permission = this.security.getInfostorePermission(session, metadata);
        if (!permission.canDeleteObject()) {
            throw InfostoreExceptionCodes.NO_DELETE_PERMISSION_FOR_VERSION.create();
        }
        StringBuilder versions = new StringBuilder().append('(');
        HashSet<Integer> versionSet = new HashSet<Integer>();
        for (int v : versionIds) {
            versions.append(v).append(',');
            versionSet.add(v);
        }
        versions.setLength(versions.length() - 1);
        versions.append(')');
        List<DocumentMetadata> allVersions = InfostoreIterator.allVersionsWhere("infostore_document.infostore_id = " + id + " AND infostore_document.version_number IN " + versions.toString() + " and infostore_document.version_number != 0 ", Metadata.VALUES_ARRAY, this, context).asList();
        Date now = new Date();
        boolean removeCurrent = false;
        for (DocumentMetadata v : allVersions) {
            if (v.getVersion() == metadata.getVersion()) {
                removeCurrent = true;
            }
            versionSet.remove(v.getVersion());
            v.setLastModified(now);
            this.removeFile(context, v.getFilestoreLocation(), this.security.getFolderOwner(v, context));
        }
        DocumentMetadataImpl update = new DocumentMetadataImpl(metadata);
        update.setLastModified(now);
        update.setModifiedBy(session.getUserId());
        HashSet<Metadata> updatedFields = new HashSet<Metadata>();
        updatedFields.add(Metadata.LAST_MODIFIED_LITERAL);
        updatedFields.add(Metadata.MODIFIED_BY_LITERAL);
        if (removeCurrent) {
            DocumentMetadata oldVersion0 = this.load(id, 0, context);
            DocumentMetadataImpl version0 = new DocumentMetadataImpl(metadata);
            version0.setVersion(0);
            version0.setFileMIMEType("");
            this.perform(new UpdateVersionAction((DBProvider)this, QUERIES, context, version0, oldVersion0, new Metadata[]{Metadata.DESCRIPTION_LITERAL, Metadata.TITLE_LITERAL, Metadata.URL_LITERAL, Metadata.LAST_MODIFIED_LITERAL, Metadata.MODIFIED_BY_LITERAL, Metadata.FILE_MIMETYPE_LITERAL}, Long.MAX_VALUE, (Session)session), true);
            update.setVersion(this.db.getMaxActiveVersion(metadata.getId(), context, allVersions));
            updatedFields.add(Metadata.VERSION_LITERAL);
        }
        FilenameReserver filenameReserver = null;
        try {
            if (removeCurrent) {
                filenameReserver = new FilenameReserverImpl(context, this.db);
                FilenameReservation reservation = filenameReserver.reserve(metadata = this.load(metadata.getId(), update.getVersion(), context), true);
                if (reservation.wasAdjusted()) {
                    update.setFileName(reservation.getFilename());
                    updatedFields.add(Metadata.FILENAME_LITERAL);
                }
                if (reservation.wasSameTitle()) {
                    update.setTitle(reservation.getFilename());
                    updatedFields.add(Metadata.TITLE_LITERAL);
                }
            }
            this.perform(new UpdateDocumentAction((DBProvider)this, QUERIES, context, update, metadata, updatedFields.toArray(new Metadata[updatedFields.size()]), Long.MAX_VALUE, (Session)session), true);
            this.perform(new DeleteVersionAction((DBProvider)this, QUERIES, context, allVersions, (Session)session), true);
            int[] retval = new int[versionSet.size()];
            int i = 0;
            for (Integer integer : versionSet) {
                retval[i++] = integer;
            }
            int[] nArray = retval;
            return nArray;
        }
        finally {
            if (null != filenameReserver) {
                filenameReserver.cleanUp();
            }
        }
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(long folderId, ServerSession session) throws OXException {
        return this.getDocuments(folderId, Metadata.HTTPAPI_VALUES_ARRAY, null, 0, session);
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(long folderId, Metadata[] columns, ServerSession session) throws OXException {
        return this.getDocuments(folderId, columns, null, 0, session);
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(long folderId, Metadata[] columns, Metadata sort, int order, ServerSession session) throws OXException {
        return this.getDocuments(folderId, columns, sort, order, -1, -1, session);
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(long folderId, Metadata[] columns, Metadata sort, int order, int start, int end, Context context, User user, UserPermissionBits permissionBits) throws OXException {
        return this.getDocuments(context, user, permissionBits, folderId, columns, sort, order, start, end);
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(long folderId, Metadata[] columns, Metadata sort, int order, int start, int end, ServerSession session) throws OXException {
        return this.getDocuments(session.getContext(), session.getUser(), session.getUserPermissionBits(), folderId, columns, sort, order, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimedResult<DocumentMetadata> getUserSharedDocuments(Metadata[] columns, Metadata sort, int order, int start, int end, ServerSession session) throws OXException {
        List<DocumentMetadata> documents;
        Metadata[] fields = Tools.getFieldsToQuery(columns, Metadata.LAST_MODIFIED_LITERAL, Metadata.ID_LITERAL, Metadata.FOLDER_ID_LITERAL);
        Context context = session.getContext();
        InfostoreIterator iterator = null;
        try {
            iterator = InfostoreIterator.sharedDocumentsByUser(context, session.getUser(), fields, sort, order, start, end, this.db);
            documents = Tools.removeNonPrivate((SearchIterator<DocumentMetadata>)iterator, session, this.db);
        }
        catch (Throwable throwable) {
            SearchIterators.close(iterator);
            throw throwable;
        }
        SearchIterators.close((SearchIterator)iterator);
        if (Arrays.contains((Object[])columns, (Object)Metadata.SHAREABLE_LITERAL)) {
            for (DocumentMetadata document : documents) {
                document.setShareable(true);
            }
        }
        if (Arrays.contains((Object[])columns, (Object)Metadata.LOCKED_UNTIL_LITERAL)) {
            documents = this.lockedUntilLoader.add(documents, context, (Map)null);
        }
        if (Arrays.contains((Object[])columns, (Object)Metadata.OBJECT_PERMISSIONS_LITERAL)) {
            documents = this.objectPermissionLoader.add(documents, context, (Map)null);
        }
        return new InfostoreTimedResult((SearchIterator<DocumentMetadata>)new SearchIteratorAdapter(documents.iterator(), documents.size()));
    }

    @Override
    public TimedResult<DocumentMetadata> getVersions(int id, ServerSession session) throws OXException {
        return this.getVersions(id, Metadata.HTTPAPI_VALUES_ARRAY, null, 0, session);
    }

    @Override
    public TimedResult<DocumentMetadata> getVersions(int id, Metadata[] columns, ServerSession session) throws OXException {
        return this.getVersions(id, columns, null, 0, session);
    }

    @Override
    public TimedResult<DocumentMetadata> getVersions(int id, Metadata[] columns, Metadata sort, int order, final ServerSession session) throws OXException {
        Context context = session.getContext();
        final EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(session, id);
        if (!infoPerm.canReadObject()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        Metadata[] cols = this.addLastModifiedIfNeeded(columns);
        InfostoreIterator iter = InfostoreIterator.versions(id, cols, sort, order, this, context);
        iter.setCustomizer(new DocumentCustomizer(){

            @Override
            public DocumentMetadata handle(DocumentMetadata document) {
                if (!infoPerm.canReadObjectInFolder()) {
                    document.setOriginalFolderId(document.getFolderId());
                    document.setFolderId(InfostoreFacadeImpl.this.getSharedFilesFolderID(session));
                    document.setShareable(false);
                } else {
                    document.setShareable(infoPerm.canShareObject());
                }
                return document;
            }
        });
        TimedResult<DocumentMetadata> timedResult = new TimedResult<DocumentMetadata>((SearchIterator<DocumentMetadata>)iter);
        if (Arrays.contains((Object[])columns, (Object)Metadata.LOCKED_UNTIL_LITERAL)) {
            timedResult = this.lockedUntilLoader.add(timedResult, context, Collections.singleton(Autoboxing.I((int)id)));
        }
        if (Arrays.contains((Object[])columns, (Object)Metadata.OBJECT_PERMISSIONS_LITERAL)) {
            timedResult = this.objectPermissionLoader.add(timedResult, context, Collections.singleton(Autoboxing.I((int)id)));
        }
        return timedResult;
    }

    @Override
    public TimedResult<DocumentMetadata> getDocuments(List<FileStorageFileAccess.IDTuple> ids, Metadata[] columns, final ServerSession session) throws OXException {
        final Context context = session.getContext();
        final User user = session.getUser();
        final Map<Integer, Long> idsToFolders = Tools.getIDsToFolders(this.ensureFolderIDs(context, ids));
        List<Integer> objectIDs = Tools.getObjectIDs(ids);
        Object[] cols = this.addLastModifiedIfNeeded(columns);
        boolean addObjectPermissions = Arrays.contains((Object[])cols, (Object)Metadata.OBJECT_PERMISSIONS_LITERAL);
        final Map<Integer, List<ObjectPermission>> knownObjectPermissions = addObjectPermissions ? this.objectPermissionLoader.load(objectIDs, context) : null;
        final HashMap knownFolderPermissions = new HashMap();
        InfostoreIterator iterator = InfostoreIterator.list(Autoboxing.I2i(objectIDs), (Metadata[])cols, this, session.getContext());
        iterator.setCustomizer(new DocumentCustomizer(){

            @Override
            public DocumentMetadata handle(DocumentMetadata document) throws OXException {
                Long folderID = document.getFolderId();
                EffectiveInfostoreFolderPermission folderPermission = (EffectiveInfostoreFolderPermission)knownFolderPermissions.get(folderID);
                if (null == folderPermission) {
                    folderPermission = InfostoreFacadeImpl.this.security.getFolderPermission(folderID, context, user, session.getUserPermissionBits());
                    knownFolderPermissions.put(folderID, folderPermission);
                }
                if (!new EffectiveInfostorePermission(folderPermission.getPermission(), document, user, -1).canReadObject()) {
                    ObjectPermission matchingPermission;
                    List objectPermissions;
                    EffectiveInfostorePermission infostorePermission = null;
                    List list = objectPermissions = null != knownObjectPermissions ? (List)knownObjectPermissions.get(Autoboxing.I((int)document.getId())) : (List)InfostoreFacadeImpl.this.objectPermissionLoader.load(document.getId(), context);
                    if (null != objectPermissions && null != (matchingPermission = EffectiveObjectPermissions.find(user, objectPermissions))) {
                        EffectiveObjectPermission objectPermission = EffectiveObjectPermissions.convert(8, (int)document.getFolderId(), document.getId(), matchingPermission, session.getUserPermissionBits());
                        infostorePermission = new EffectiveInfostorePermission(folderPermission.getPermission(), objectPermission, document, user, -1);
                    }
                    if (null == infostorePermission || !infostorePermission.canReadObject()) {
                        throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
                    }
                    if (!infostorePermission.canReadObjectInFolder()) {
                        Long requestedFolderID = (Long)idsToFolders.get(Autoboxing.I((int)document.getId()));
                        if (null == requestedFolderID || InfostoreFacadeImpl.this.getSharedFilesFolderID(session) != requestedFolderID.intValue()) {
                            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
                        }
                        document.setOriginalFolderId(document.getFolderId());
                        document.setFolderId(InfostoreFacadeImpl.this.getSharedFilesFolderID(session));
                        document.setShareable(false);
                    }
                } else {
                    Long requestedFolderID = (Long)idsToFolders.get(Autoboxing.I((int)document.getId()));
                    if (InfostoreFacadeImpl.this.getSharedFilesFolderID(session) == requestedFolderID.intValue()) {
                        document.setOriginalFolderId(document.getFolderId());
                        document.setFolderId(requestedFolderID);
                        document.setShareable(false);
                    } else {
                        document.setShareable(folderPermission.canShareAllObjects() || folderPermission.canShareOwnObjects() && document.getCreatedBy() == user.getId());
                    }
                }
                return document;
            }
        });
        TimedResult<DocumentMetadata> timedResult = new TimedResult<DocumentMetadata>((SearchIterator<DocumentMetadata>)iterator);
        if (addObjectPermissions) {
            timedResult = this.objectPermissionLoader.add(timedResult, context, knownObjectPermissions);
        }
        if (Arrays.contains((Object[])cols, (Object)Metadata.LOCKED_UNTIL_LITERAL)) {
            timedResult = this.lockedUntilLoader.add(timedResult, context, objectIDs);
        }
        if (Arrays.contains((Object[])cols, (Object)Metadata.NUMBER_OF_VERSIONS_LITERAL)) {
            timedResult = this.numberOfVersionsLoader.add(timedResult, context, objectIDs);
        }
        return timedResult;
    }

    @Override
    public Delta<DocumentMetadata> getDelta(long folderId, long updateSince, Metadata[] columns, boolean ignoreDeleted, ServerSession session) throws OXException {
        return this.getDelta(folderId, updateSince, columns, null, 0, ignoreDeleted, session);
    }

    @Override
    public Delta<DocumentMetadata> getDelta(long folderId, long updateSince, Metadata[] columns, Metadata sort, int order, boolean ignoreDeleted, ServerSession session) throws OXException {
        Context context = session.getContext();
        User user = session.getUser();
        Map<Integer, List<Lock>> locks = this.loadLocksInFolderAndExpireOldLocks(folderId, session);
        InfostoreIterator newIter = null;
        InfostoreIterator modIter = null;
        InfostoreIterator delIter = null;
        Metadata[] cols = this.addLastModifiedIfNeeded(columns);
        final int sharedFilesFolderID = this.getSharedFilesFolderID(session);
        if (folderId == (long)sharedFilesFolderID) {
            DocumentCustomizer customizer = new DocumentCustomizer(){

                @Override
                public DocumentMetadata handle(DocumentMetadata document) {
                    document.setOriginalFolderId(document.getFolderId());
                    document.setFolderId(sharedFilesFolderID);
                    return document;
                }
            };
            newIter = InfostoreIterator.newSharedDocumentsForUser(context, user, columns, sort, order, updateSince, this);
            newIter.setCustomizer(customizer);
            modIter = InfostoreIterator.modifiedSharedDocumentsForUser(context, user, columns, sort, order, updateSince, this);
            modIter.setCustomizer(customizer);
            if (!ignoreDeleted) {
                delIter = InfostoreIterator.deletedSharedDocumentsForUser(context, user, columns, sort, order, updateSince, this);
                delIter.setCustomizer(customizer);
            }
        } else {
            boolean onlyOwn = false;
            EffectiveInfostoreFolderPermission isperm = this.security.getFolderPermission(folderId, context, user, session.getUserPermissionBits());
            if (isperm.getReadPermission() == 0) {
                throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
            }
            if (isperm.getReadPermission() == 2) {
                onlyOwn = true;
            }
            if (onlyOwn) {
                newIter = InfostoreIterator.newDocumentsByCreator(folderId, user.getId(), cols, sort, order, updateSince, this, context);
                modIter = InfostoreIterator.modifiedDocumentsByCreator(folderId, user.getId(), cols, sort, order, updateSince, this, context);
                if (!ignoreDeleted) {
                    delIter = InfostoreIterator.deletedDocumentsByCreator(folderId, user.getId(), sort, order, updateSince, this, context);
                }
            } else {
                newIter = InfostoreIterator.newDocuments(folderId, cols, sort, order, updateSince, this, context);
                modIter = InfostoreIterator.modifiedDocuments(folderId, cols, sort, order, updateSince, this, context);
                if (!ignoreDeleted) {
                    delIter = InfostoreIterator.deletedDocuments(folderId, sort, order, updateSince, this, context);
                }
            }
        }
        boolean addLocked = false;
        boolean addNumberOfVersions = false;
        for (Metadata m : columns) {
            if (m == Metadata.LOCKED_UNTIL_LITERAL) {
                addLocked = true;
                break;
            }
            if (m != Metadata.NUMBER_OF_VERSIONS_LITERAL) continue;
            addNumberOfVersions = true;
            break;
        }
        Object it = ignoreDeleted ? SearchIteratorAdapter.emptyIterator() : delIter;
        Delta<DocumentMetadata> delta = new Delta<DocumentMetadata>((SearchIterator)newIter, (SearchIterator)modIter, it, System.currentTimeMillis());
        if (addLocked) {
            delta = this.lockedUntilLoader.add(delta, context, locks);
        }
        if (addNumberOfVersions) {
            delta = this.numberOfVersionsLoader.add(delta, context, (Map)null);
        }
        return delta;
    }

    @Override
    public Map<Long, Long> getSequenceNumbers(List<Long> folderIds, boolean versionsOnly, ServerSession session) throws OXException {
        if (0 == folderIds.size()) {
            return Collections.emptyMap();
        }
        final HashMap<Long, Long> sequenceNumbers = new HashMap<Long, Long>(folderIds.size());
        try {
            User user = session.getUser();
            int contextId = session.getContextId();
            Context context = session.getContext();
            final Long userInfostoreId = new Long(10L);
            if (folderIds.remove(userInfostoreId)) {
                this.performQuery(context, QUERIES.getSharedDocumentsSequenceNumbersQuery(versionsOnly, true, contextId, user.getId(), user.getGroups()), new ResultProcessor<Void>(){

                    @Override
                    public Void process(ResultSet rs) throws SQLException {
                        while (rs.next()) {
                            long newSequence = rs.getLong(1);
                            Long oldSequence = (Long)sequenceNumbers.get(userInfostoreId);
                            if (oldSequence != null && oldSequence >= newSequence) continue;
                            sequenceNumbers.put(userInfostoreId, newSequence);
                        }
                        return null;
                    }
                }, new Object[0]);
                this.performQuery(context, QUERIES.getSharedDocumentsSequenceNumbersQuery(versionsOnly, false, contextId, user.getId(), user.getGroups()), new ResultProcessor<Void>(){

                    @Override
                    public Void process(ResultSet rs) throws SQLException {
                        while (rs.next()) {
                            long newSequence = rs.getLong(1);
                            Long oldSequence = (Long)sequenceNumbers.get(userInfostoreId);
                            if (oldSequence != null && oldSequence >= newSequence) continue;
                            sequenceNumbers.put(userInfostoreId, newSequence);
                        }
                        return null;
                    }
                }, new Object[0]);
            }
            this.performQuery(context, QUERIES.getFolderSequenceNumbersQuery(folderIds, versionsOnly, true, contextId), new ResultProcessor<Void>(){

                @Override
                public Void process(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        sequenceNumbers.put(rs.getLong(1), rs.getLong(2));
                    }
                    return null;
                }
            }, new Object[0]);
            this.performQuery(context, QUERIES.getFolderSequenceNumbersQuery(folderIds, versionsOnly, false, contextId), new ResultProcessor<Void>(){

                @Override
                public Void process(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        Long folderID = rs.getLong(1);
                        long newSequence = rs.getLong(2);
                        Long oldSequence = (Long)sequenceNumbers.get(folderID);
                        if (oldSequence != null && oldSequence >= newSequence) continue;
                        sequenceNumbers.put(folderID, newSequence);
                    }
                    return null;
                }
            }, new Object[0]);
        }
        catch (SQLException e) {
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        return sequenceNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, List<Lock>> loadLocksInFolderAndExpireOldLocks(long folderId, ServerSession session) throws OXException {
        HashMap<Integer, List<Lock>> locks = new HashMap<Integer, List<Lock>>();
        try (InfostoreIterator documents = InfostoreIterator.documents(folderId, new Metadata[]{Metadata.ID_LITERAL}, null, -1, -1, -1, this, session.getContext());){
            while (documents.hasNext()) {
                DocumentMetadata document = documents.next();
                this.lockManager.findLocks(document.getId(), (Session)session);
            }
        }
        return locks;
    }

    @Override
    public int countDocuments(long folderId, ServerSession session) throws OXException {
        if (folderId == (long)this.getSharedFilesFolderID(session)) {
            InfostoreIterator it = InfostoreIterator.sharedDocumentsForUser(session.getContext(), session.getUser(), 1, new Metadata[]{Metadata.ID_LITERAL}, null, 0, -1, -1, this);
            return it.asList().size();
        }
        boolean onlyOwn = false;
        User user = session.getUser();
        EffectiveInfostoreFolderPermission isperm = this.security.getFolderPermission(folderId, session.getContext(), user, session.getUserPermissionBits());
        if (!isperm.canReadAllObjects() && !isperm.canReadOwnObjects()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        if (!isperm.canReadAllObjects() && isperm.canReadOwnObjects()) {
            onlyOwn = true;
        }
        return this.db.countDocuments(folderId, onlyOwn, session.getContext(), user);
    }

    @Override
    public boolean hasFolderForeignObjects(long folderId, ServerSession session) throws OXException {
        if (folderId == (long)this.getSharedFilesFolderID(session)) {
            return true;
        }
        return this.db.hasFolderForeignObjects(folderId, session.getContext(), session.getUser());
    }

    @Override
    public boolean isFolderEmpty(long folderId, Context ctx) throws OXException {
        if (folderId == 10L) {
            return true;
        }
        return this.db.isFolderEmpty(folderId, ctx);
    }

    @Override
    public void removeUser(int userId, Context ctx, ServerSession session) throws OXException {
        this.db.removeUser(userId, ctx, session, this.lockManager);
    }

    @Override
    public SearchIterator<DocumentMetadata> search(ServerSession session, String query, int folderId, Metadata[] cols, Metadata sortedBy, int dir, int start, int end) throws OXException {
        int[] nArray;
        ArrayList<Integer> all = new ArrayList<Integer>();
        ArrayList<Integer> own = new ArrayList<Integer>();
        if (-11 == folderId || -10 == folderId) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = folderId;
        }
        int[] requestedFolderIDs = nArray;
        Map<Integer, EffectiveInfostoreFolderPermission> permissionsByFolderID = Tools.gatherVisibleFolders(session, this.security, this.db, requestedFolderIDs, all, own);
        if (all.isEmpty() && own.isEmpty()) {
            return SearchIteratorAdapter.emptyIterator();
        }
        Metadata[] fields = Tools.getFieldsToQuery(cols, Metadata.ID_LITERAL, Metadata.FOLDER_ID_LITERAL);
        SearchIterator<DocumentMetadata> searchIterator = this.searchEngine.search(session, query, all, own, fields, sortedBy, dir, start, end);
        return this.postProcessSearch(session, searchIterator, fields, permissionsByFolderID);
    }

    @Override
    public SearchIterator<DocumentMetadata> search(ServerSession session, SearchTerm<?> searchTerm, int[] folderIds, Metadata[] cols, Metadata sortedBy, int dir, int start, int end) throws OXException {
        ArrayList<Integer> all = new ArrayList<Integer>();
        ArrayList<Integer> own = new ArrayList<Integer>();
        int[] requestedFolderIDs = null == folderIds || 0 == folderIds.length ? null : folderIds;
        Map<Integer, EffectiveInfostoreFolderPermission> permissionsByFolderID = Tools.gatherVisibleFolders(session, this.security, this.db, requestedFolderIDs, all, own);
        if (all.isEmpty() && own.isEmpty()) {
            return SearchIteratorAdapter.emptyIterator();
        }
        Metadata[] fields = Tools.getFieldsToQuery(cols, Metadata.ID_LITERAL, Metadata.FOLDER_ID_LITERAL);
        SearchIterator<DocumentMetadata> searchIterator = this.searchEngine.search(session, searchTerm, all, own, fields, sortedBy, dir, start, end);
        return this.postProcessSearch(session, searchIterator, fields, permissionsByFolderID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchIterator<DocumentMetadata> postProcessSearch(ServerSession session, SearchIterator<DocumentMetadata> searchIterator, Metadata[] fields, Map<Integer, EffectiveInfostoreFolderPermission> permissionsByFolderID) throws OXException {
        List<DocumentMetadata> documents;
        int sharedFilesFolderID = 10;
        boolean containsSharedFilesResults = null != permissionsByFolderID && permissionsByFolderID.containsKey(Autoboxing.I((int)sharedFilesFolderID));
        boolean addLocked = Arrays.contains((Object[])fields, (Object)Metadata.LOCKED_UNTIL_LITERAL);
        boolean addNumberOfVersions = Arrays.contains((Object[])fields, (Object)Metadata.NUMBER_OF_VERSIONS_LITERAL);
        boolean addObjectPermissions = Arrays.contains((Object[])fields, (Object)Metadata.OBJECT_PERMISSIONS_LITERAL);
        boolean addShareable = Arrays.contains((Object[])fields, (Object)Metadata.SHAREABLE_LITERAL);
        if (!(addLocked || addNumberOfVersions || addObjectPermissions || addShareable || containsSharedFilesResults)) {
            return searchIterator;
        }
        try {
            documents = SearchIterators.asList(searchIterator);
        }
        finally {
            SearchIterators.close(searchIterator);
        }
        if (null == documents || 0 == documents.size()) {
            return SearchIteratorAdapter.emptyIterator();
        }
        List<Integer> objectIDs = Tools.getIDs(documents);
        if (addObjectPermissions || addShareable || containsSharedFilesResults) {
            documents = this.objectPermissionLoader.add(documents, session.getContext(), objectIDs);
        }
        if (addLocked) {
            documents = this.lockedUntilLoader.add(documents, session.getContext(), objectIDs);
        }
        if (addNumberOfVersions) {
            documents = this.numberOfVersionsLoader.add(documents, session.getContext(), objectIDs);
        }
        if (addShareable || containsSharedFilesResults) {
            boolean hasSharedFolderAccess = session.getUserConfiguration().hasFullSharedFolderAccess();
            for (DocumentMetadata document : documents) {
                int physicalFolderID = (int)document.getFolderId();
                if (null == permissionsByFolderID) {
                    document.setShareable(hasSharedFolderAccess);
                    continue;
                }
                EffectiveInfostoreFolderPermission folderPermission = permissionsByFolderID.get(Autoboxing.I((int)physicalFolderID));
                if (null != folderPermission && (folderPermission.canReadAllObjects() || folderPermission.canReadOwnObjects() && document.getCreatedBy() == session.getUserId())) {
                    document.setShareable(folderPermission.canShareAllObjects() || folderPermission.canShareOwnObjects() && document.getCreatedBy() == session.getUserId());
                    continue;
                }
                List<ObjectPermission> objectPermissions = document.getObjectPermissions();
                if (null != objectPermissions) {
                    ObjectPermission matchingPermission = EffectiveObjectPermissions.find(session.getUser(), objectPermissions);
                    if (null != matchingPermission && matchingPermission.canRead()) {
                        document.setOriginalFolderId(document.getFolderId());
                        document.setFolderId(sharedFilesFolderID);
                        document.setShareable(false);
                        continue;
                    }
                    throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
                }
                throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
            }
        }
        return new SearchIteratorDelegator(documents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getId(Context context, Connection writeCon) throws SQLException {
        boolean autoCommit = writeCon.getAutoCommit();
        if (autoCommit) {
            writeCon.setAutoCommit(false);
        }
        try {
            int n = IDGenerator.getId(context, 137, writeCon);
            return n;
        }
        finally {
            if (autoCommit) {
                writeCon.commit();
                writeCon.setAutoCommit(true);
            }
        }
    }

    private Metadata[] addLastModifiedIfNeeded(Metadata[] columns) {
        for (Metadata metadata : columns) {
            if (metadata != Metadata.LAST_MODIFIED_LITERAL && metadata != Metadata.LAST_MODIFIED_UTC_LITERAL) continue;
            return columns;
        }
        Metadata[] copy = new Metadata[columns.length + 1];
        int i = 0;
        for (Metadata metadata : columns) {
            copy[i++] = metadata;
        }
        copy[i] = Metadata.LAST_MODIFIED_UTC_LITERAL;
        return copy;
    }

    public InfostoreSecurity getSecurity() {
        return this.security;
    }

    @Override
    public void commit() throws OXException {
        Map<Integer, Set<Integer>> guestsToCleanup;
        this.db.commit();
        ServiceMethod.COMMIT.callUnsafe(this.security, new Object[0]);
        this.lockManager.commit();
        List<FileRemoveInfo> filesToRemove = this.fileIdRemoveList.get();
        if (null != filesToRemove && !filesToRemove.isEmpty()) {
            if (1 == filesToRemove.size()) {
                FileRemoveInfo removeInfo = filesToRemove.get(0);
                this.getFileStorage(removeInfo.folderAdmin, removeInfo.contextId).deleteFile(removeInfo.fileId);
            } else {
                HashMap<QuotaFileStorage, ArrayList<String>> removalsPerStorage = new HashMap<QuotaFileStorage, ArrayList<String>>();
                for (FileRemoveInfo fileRemoveInfo : filesToRemove) {
                    QuotaFileStorage fileStorage = this.getFileStorage(fileRemoveInfo.folderAdmin, fileRemoveInfo.contextId);
                    ArrayList<String> removals = (ArrayList<String>)removalsPerStorage.get(fileStorage);
                    if (null == removals) {
                        removals = new ArrayList<String>();
                        removalsPerStorage.put(fileStorage, removals);
                    }
                    removals.add(fileRemoveInfo.fileId);
                }
                for (Map.Entry entry : removalsPerStorage.entrySet()) {
                    ((QuotaFileStorage)entry.getKey()).deleteFiles(((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
                }
            }
        }
        if (null != (guestsToCleanup = this.guestCleanupList.get()) && 0 < guestsToCleanup.size()) {
            for (Map.Entry entry : guestsToCleanup.entrySet()) {
                int contextID = Autoboxing.i((Integer)((Integer)entry.getKey()));
                Set<Integer> guestIDs = this.filterGuests(contextID, (Set)entry.getValue());
                if (null == guestIDs || 0 >= guestIDs.size()) continue;
                ServerServiceRegistry.getServize(ShareService.class).scheduleGuestCleanup(contextID, Autoboxing.I2i(guestIDs));
            }
        }
        super.commit();
    }

    private Set<Integer> filterGuests(int contextID, Set<Integer> entityIDs) throws OXException {
        if (null == entityIDs || 0 == entityIDs.size()) {
            return Collections.emptySet();
        }
        UserService userService = ServerServiceRegistry.getServize(UserService.class);
        HashSet<Integer> guestIDs = new HashSet<Integer>(entityIDs.size());
        for (Integer id : entityIDs) {
            try {
                if (!userService.isGuest((int)id, contextID)) continue;
                guestIDs.add(id);
            }
            catch (OXException e) {
                if (UserExceptionCode.USER_NOT_FOUND.equals(e)) continue;
                throw e;
            }
        }
        return guestIDs;
    }

    @Override
    public void finish() throws OXException {
        this.fileIdRemoveList.set(null);
        this.guestCleanupList.set(null);
        this.db.finish();
        ServiceMethod.FINISH.callUnsafe(this.security, new Object[0]);
        this.lockManager.finish();
        super.finish();
    }

    @Override
    public void rollback() throws OXException {
        this.db.rollback();
        ServiceMethod.ROLLBACK.callUnsafe(this.security, new Object[0]);
        this.lockManager.rollback();
        super.rollback();
    }

    @Override
    public void setRequestTransactional(boolean transactional) {
        this.db.setRequestTransactional(transactional);
        ServiceMethod.SET_REQUEST_TRANSACTIONAL.call(this.security, transactional);
        this.lockManager.setRequestTransactional(transactional);
        super.setRequestTransactional(transactional);
    }

    @Override
    public void setTransactional(boolean transactional) {
        this.lockManager.setTransactional(transactional);
    }

    @Override
    public void startTransaction() throws OXException {
        this.fileIdRemoveList.set(new LinkedList());
        this.guestCleanupList.set(new HashMap());
        this.db.startTransaction();
        ServiceMethod.START_TRANSACTION.callUnsafe(this.security, new Object[0]);
        this.lockManager.startTransaction();
        super.startTransaction();
    }

    @Override
    public void setProvider(DBProvider provider) {
        super.setProvider(provider);
        this.db.setProvider(this);
        ServiceMethod.SET_PROVIDER.call(this.security, this);
        ServiceMethod.SET_PROVIDER.call(this.lockManager, this);
    }

    @Override
    public void setSessionHolder(SessionHolder sessionHolder) {
        this.expiredLocksListener.setSessionHolder(sessionHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileStorageFileAccess.IDTuple> ensureFolderIDs(Context context, List<FileStorageFileAccess.IDTuple> tuples) throws OXException {
        if (null == tuples || 0 == tuples.size()) {
            return tuples;
        }
        HashMap<Integer, FileStorageFileAccess.IDTuple> incompleteTuples = new HashMap<Integer, FileStorageFileAccess.IDTuple>();
        for (FileStorageFileAccess.IDTuple tuple : tuples) {
            if (null != tuple.getFolder()) continue;
            try {
                incompleteTuples.put(Integer.valueOf(tuple.getId()), tuple);
            }
            catch (NumberFormatException e) {
                throw InfostoreExceptionCodes.NOT_EXIST.create();
            }
        }
        if (0 < incompleteTuples.size()) {
            InfostoreIterator iterator = null;
            try {
                iterator = InfostoreIterator.list(Autoboxing.I2i(incompleteTuples.keySet()), new Metadata[]{Metadata.ID_LITERAL, Metadata.FOLDER_ID_LITERAL}, this, context);
                while (iterator.hasNext()) {
                    DocumentMetadata document = iterator.next();
                    FileStorageFileAccess.IDTuple tuple = (FileStorageFileAccess.IDTuple)incompleteTuples.get(document.getId());
                    if (null == tuple) continue;
                    tuple.setFolder(String.valueOf(document.getFolderId()));
                }
            }
            catch (Throwable throwable) {
                SearchIterators.close(iterator);
                throw throwable;
            }
            SearchIterators.close((SearchIterator)iterator);
        }
        return tuples;
    }

    private ValidationChain getValidationChain() {
        return new ValidationChain(new InvalidCharactersValidator(), new FilenamesMayNotContainSlashesValidator(), new ObjectPermissionValidator(this));
    }

    private TimedResult<DocumentMetadata> getDocuments(Context context, final User user, UserPermissionBits permissionBits, final long folderId, Metadata[] columns, Metadata sort, int order, int start, int end) throws OXException {
        InfostoreIterator iterator;
        EffectiveInfostoreFolderPermission folderPermission;
        Metadata[] cols = this.addLastModifiedIfNeeded(columns);
        final long sharedFilesFolderID = this.getSharedFilesFolderID(context, user);
        if (sharedFilesFolderID == folderId) {
            folderPermission = null;
            iterator = InfostoreIterator.sharedDocumentsForUser(context, user, 1, cols, sort, order, start, end, this.db);
            iterator.setCustomizer(new DocumentCustomizer(){

                @Override
                public DocumentMetadata handle(DocumentMetadata document) {
                    document.setOriginalFolderId(document.getFolderId());
                    document.setFolderId(sharedFilesFolderID);
                    return document;
                }
            });
        } else {
            folderPermission = this.security.getFolderPermission(folderId, context, user, permissionBits);
            if (folderPermission.canReadAllObjects()) {
                iterator = InfostoreIterator.documents(folderId, cols, sort, order, start, end, this, context);
            } else if (folderPermission.canReadOwnObjects()) {
                iterator = InfostoreIterator.documentsByCreator(folderId, user.getId(), cols, sort, order, start, end, this, context);
            } else {
                throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
            }
        }
        boolean addLocked = Arrays.contains((Object[])columns, (Object)Metadata.LOCKED_UNTIL_LITERAL);
        boolean addNumberOfVersions = Arrays.contains((Object[])columns, (Object)Metadata.NUMBER_OF_VERSIONS_LITERAL);
        boolean addObjectPermissions = Arrays.contains((Object[])columns, (Object)Metadata.OBJECT_PERMISSIONS_LITERAL);
        boolean addShareable = Arrays.contains((Object[])columns, (Object)Metadata.SHAREABLE_LITERAL);
        if (!(addLocked || addNumberOfVersions || addObjectPermissions || addShareable)) {
            return new InfostoreTimedResult(iterator);
        }
        final List<DocumentMetadata> documents = iterator.asList();
        if (0 == documents.size()) {
            return Results.emptyTimedResult();
        }
        long maxSequenceNumber = 0L;
        ArrayList<Integer> objectIDs = new ArrayList<Integer>(documents.size());
        for (DocumentMetadata document : documents) {
            maxSequenceNumber = Math.max(maxSequenceNumber, document.getSequenceNumber());
            objectIDs.add(document.getId());
        }
        final long sequenceNumber = maxSequenceNumber;
        TimedResult<DocumentMetadata> timedResult = new TimedResult<DocumentMetadata>(){

            public SearchIterator<DocumentMetadata> results() throws OXException {
                return new SearchIteratorAdapter(documents.iterator());
            }

            public long sequenceNumber() throws OXException {
                return sequenceNumber;
            }
        };
        if (addObjectPermissions) {
            timedResult = this.objectPermissionLoader.add(timedResult, context, objectIDs);
        }
        if (addLocked) {
            timedResult = this.lockedUntilLoader.add(timedResult, context, objectIDs);
        }
        if (addNumberOfVersions) {
            timedResult = this.numberOfVersionsLoader.add(timedResult, context, objectIDs);
        }
        if (addShareable) {
            final boolean hasSharedFolderAccess = permissionBits.hasFullSharedFolderAccess();
            timedResult = new TimedResult<DocumentMetadata>(timedResult, (Customizer)new Customizer<DocumentMetadata>(){

                public DocumentMetadata customize(DocumentMetadata document) throws OXException {
                    if (!hasSharedFolderAccess || sharedFilesFolderID == folderId) {
                        document.setShareable(false);
                    } else {
                        document.setShareable(folderPermission.canWriteAllObjects() || folderPermission.canWriteOwnObjects() && document.getCreatedBy() == user.getId());
                    }
                    return document;
                }
            });
        }
        return timedResult;
    }

    private int getSharedFilesFolderID(ServerSession session) {
        return this.getSharedFilesFolderID(session.getContext(), session.getUser());
    }

    private int getSharedFilesFolderID(Context context, User user) {
        return 10;
    }

    private static interface ResultProcessor<T> {
        public T process(ResultSet var1) throws SQLException;
    }

    private static enum ServiceMethod {
        COMMIT,
        FINISH,
        ROLLBACK,
        SET_REQUEST_TRANSACTIONAL,
        START_TRANSACTION,
        SET_PROVIDER;


        public void call(Object o, Object ... args) {
            if (!(o instanceof DBService)) {
                return;
            }
            DBService service = (DBService)o;
            switch (this) {
                default: {
                    return;
                }
                case SET_REQUEST_TRANSACTIONAL: {
                    service.setRequestTransactional((Boolean)args[0]);
                    break;
                }
                case SET_PROVIDER: {
                    service.setProvider((DBProvider)args[0]);
                }
            }
        }

        public void callUnsafe(Object o, Object ... args) throws OXException {
            if (!(o instanceof DBService)) {
                return;
            }
            DBService service = (DBService)o;
            switch (this) {
                default: {
                    this.call(o, args);
                    break;
                }
                case COMMIT: {
                    service.commit();
                    break;
                }
                case FINISH: {
                    service.finish();
                    break;
                }
                case ROLLBACK: {
                    service.rollback();
                    break;
                }
                case START_TRANSACTION: {
                    service.startTransaction();
                }
            }
        }
    }

    private static class FileRemoveInfo {
        final String fileId;
        final int folderAdmin;
        final int contextId;

        FileRemoveInfo(String fileId, int folderAdmin, int contextId) {
            this.fileId = fileId;
            this.folderAdmin = folderAdmin;
            this.contextId = contextId;
        }
    }
}

