/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.facade.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageEventHelper;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.filestore.QuotaFileStorage;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.EffectiveInfostorePermission;
import com.openexchange.groupware.infostore.EventFiringInfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.java.Streams;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.session.ServerSession;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class EventFiringInfostoreFacadeImpl
extends InfostoreFacadeImpl
implements EventFiringInfostoreFacade {
    private static final String SERVICE_ID = "com.openexchange.infostore";
    private static final String ACCOUNT_ID = "infostore";

    public EventFiringInfostoreFacadeImpl() {
    }

    public EventFiringInfostoreFacadeImpl(DBProvider provider) {
        super(provider);
    }

    @Override
    public InputStream getDocument(int id, int version2, long offset, long length, ServerSession session) throws OXException {
        DocumentMetadata dm = this.load(id, version2, session.getContext());
        EffectiveInfostorePermission infoPerm = this.security.getInfostorePermission(session, dm);
        if (!infoPerm.canReadObject()) {
            throw InfostoreExceptionCodes.NO_READ_PERMISSION.create();
        }
        QuotaFileStorage fs = this.getFileStorage(infoPerm.getFolderOwner(), session.getContextId());
        InputStream document = dm.getFilestoreLocation() == null ? Streams.newByteArrayInputStream((byte[])new byte[0]) : (0L == offset && -1L == length ? fs.getFile(dm.getFilestoreLocation()) : fs.getFile(dm.getFilestoreLocation(), offset, length));
        EventFiringInfostoreFacadeImpl.fireEvent(FileStorageEventHelper.buildAccessEvent((Session)session, (String)SERVICE_ID, (String)ACCOUNT_ID, (String)EventFiringInfostoreFacadeImpl.getFolderID(dm), (String)EventFiringInfostoreFacadeImpl.getFileID(dm), (String)dm.getFileName(), (FileStorageEventHelper.EventProperty[])new FileStorageEventHelper.EventProperty[0]));
        return document;
    }

    @Override
    public FileStorageFileAccess.IDTuple saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, ServerSession session) throws OXException {
        boolean wasCreation = -1 == document.getId();
        FileStorageFileAccess.IDTuple result = super.saveDocument(document, data, sequenceNumber, session);
        if (wasCreation) {
            EventFiringInfostoreFacadeImpl.fireEvent(FileStorageEventHelper.buildCreateEvent((Session)session, (String)SERVICE_ID, (String)ACCOUNT_ID, (String)EventFiringInfostoreFacadeImpl.getFolderID(document), (String)EventFiringInfostoreFacadeImpl.getFileID(document), (String)document.getFileName(), (FileStorageEventHelper.EventProperty[])new FileStorageEventHelper.EventProperty[0]));
        }
        return result;
    }

    @Override
    protected FileStorageFileAccess.IDTuple saveDocument(DocumentMetadata document, InputStream data, long sequenceNumber, Metadata[] modifiedColumns, boolean ignoreVersion, long offset, ServerSession session) throws OXException {
        boolean wasCreation = -1 == document.getId();
        FileStorageFileAccess.IDTuple result = super.saveDocument(document, data, sequenceNumber, modifiedColumns, ignoreVersion, offset, session);
        if (!wasCreation) {
            EventFiringInfostoreFacadeImpl.fireEvent(FileStorageEventHelper.buildUpdateEvent((Session)session, (String)SERVICE_ID, (String)ACCOUNT_ID, (String)EventFiringInfostoreFacadeImpl.getFolderID(document), (String)EventFiringInfostoreFacadeImpl.getFileID(document), (String)document.getFileName(), (FileStorageEventHelper.EventProperty[])new FileStorageEventHelper.EventProperty[0]));
        }
        return result;
    }

    @Override
    protected void removeDocuments(List<DocumentMetadata> allDocuments, List<DocumentMetadata> allVersions, long date, ServerSession sessionObj, List<DocumentMetadata> rejected) throws OXException {
        super.removeDocuments(allDocuments, allVersions, date, sessionObj, rejected);
        if (null != allDocuments && 0 < allDocuments.size()) {
            for (DocumentMetadata document : allDocuments) {
                if (null != rejected && rejected.contains(document)) continue;
                EventFiringInfostoreFacadeImpl.fireEvent(FileStorageEventHelper.buildDeleteEvent((Session)sessionObj, (String)SERVICE_ID, (String)ACCOUNT_ID, (String)EventFiringInfostoreFacadeImpl.getFolderID(document), (String)EventFiringInfostoreFacadeImpl.getFileID(document), (String)document.getFileName(), null, (FileStorageEventHelper.EventProperty[])new FileStorageEventHelper.EventProperty[0]));
            }
        }
    }

    @Override
    protected List<DocumentMetadata> moveDocuments(ServerSession session, List<DocumentMetadata> documents, long destinationFolderID, long sequenceNumber, boolean adjustFilenamesAsNeeded) throws OXException {
        List<DocumentMetadata> rejectedDocuments = super.moveDocuments(session, documents, destinationFolderID, sequenceNumber, adjustFilenamesAsNeeded);
        if (null != documents && 0 < documents.size()) {
            for (DocumentMetadata document : documents) {
                if (null != rejectedDocuments && rejectedDocuments.contains(document)) continue;
                EventFiringInfostoreFacadeImpl.fireEvent(FileStorageEventHelper.buildUpdateEvent((Session)session, (String)SERVICE_ID, (String)ACCOUNT_ID, (String)new FolderID(SERVICE_ID, ACCOUNT_ID, String.valueOf(destinationFolderID)).toUniqueID(), (String)EventFiringInfostoreFacadeImpl.getFileID(document), (String)document.getFileName(), (FileStorageEventHelper.EventProperty[])new FileStorageEventHelper.EventProperty[0]));
            }
        }
        return rejectedDocuments;
    }

    @Override
    public int[] removeVersion(int id, int[] versionIds, ServerSession session) throws OXException {
        if (null == versionIds || 0 == versionIds.length) {
            return super.removeVersion(id, versionIds, session);
        }
        DocumentMetadata document = this.load(id, -1, session.getContext());
        int[] notRemoved = super.removeVersion(id, versionIds, session);
        HashSet<String> deletedVersions = new HashSet<String>(versionIds.length);
        for (int versionID : versionIds) {
            if (null != notRemoved && Arrays.contains((int[])notRemoved, (int)versionID)) continue;
            deletedVersions.add(String.valueOf(versionID));
        }
        if (0 < deletedVersions.size()) {
            EventFiringInfostoreFacadeImpl.fireEvent(FileStorageEventHelper.buildDeleteEvent((Session)session, (String)SERVICE_ID, (String)ACCOUNT_ID, (String)EventFiringInfostoreFacadeImpl.getFolderID(document), (String)EventFiringInfostoreFacadeImpl.getFileID(document), (String)document.getFileName(), deletedVersions, (FileStorageEventHelper.EventProperty[])new FileStorageEventHelper.EventProperty[0]));
        }
        return notRemoved;
    }

    private static void fireEvent(Event event) {
        EventAdmin eventAdmin = ServerServiceRegistry.getServize(EventAdmin.class);
        if (null != eventAdmin) {
            eventAdmin.postEvent(event);
        }
    }

    private static String getFileID(DocumentMetadata document) {
        return new FileID(SERVICE_ID, ACCOUNT_ID, String.valueOf(document.getFolderId()), String.valueOf(document.getId())).toUniqueID();
    }

    private static String getFolderID(DocumentMetadata document) {
        return new FolderID(SERVICE_ID, ACCOUNT_ID, String.valueOf(document.getFolderId())).toUniqueID();
    }
}

