/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.AbstractDBAction;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.ObjectPermission;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.AbstractObjectPermissionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DeleteObjectPermissionAction
extends AbstractObjectPermissionAction {
    private final List<DocumentMetadata> documents;

    public DeleteObjectPermissionAction(DBProvider provider, Context context, List<DocumentMetadata> documents) {
        super(provider, context);
        this.documents = documents;
    }

    public void perform() throws OXException {
        ArrayList<AbstractDBAction.UpdateBlock> updates = new ArrayList<AbstractDBAction.UpdateBlock>();
        for (final DocumentMetadata document : this.documents) {
            List<ObjectPermission> objectPermissions = document.getObjectPermissions();
            if (null == objectPermissions) continue;
            updates.add(new AbstractDBAction.Update("DELETE FROM object_permission WHERE cid=? AND object_id=?;"){

                @Override
                public void fillStatement() throws SQLException {
                    this.stmt.setInt(1, DeleteObjectPermissionAction.this.getContext().getContextId());
                    this.stmt.setInt(2, document.getId());
                }
            });
            for (final ObjectPermission objectPermission : objectPermissions) {
                updates.add(new AbstractDBAction.Update("REPLACE INTO del_object_permission (cid,permission_id,module,folder_id,object_id,created_by,shared_by,bits,last_modified,group_flag) VALUES (?,?,?,?,?,?,?,?,?,?);"){

                    @Override
                    public void fillStatement() throws SQLException {
                        this.stmt.setInt(1, DeleteObjectPermissionAction.this.getContext().getContextId());
                        this.stmt.setInt(2, objectPermission.getEntity());
                        this.stmt.setInt(3, 8);
                        this.stmt.setInt(4, (int)document.getFolderId());
                        this.stmt.setInt(5, document.getId());
                        this.stmt.setInt(6, document.getModifiedBy());
                        this.stmt.setInt(7, document.getCreatedBy());
                        this.stmt.setInt(8, objectPermission.getPermissions());
                        this.stmt.setLong(9, document.getLastModified().getTime());
                        this.stmt.setBoolean(10, objectPermission.isGroup());
                    }
                });
            }
        }
        this.doUpdates(updates);
    }

    protected void undoAction() throws OXException {
        ArrayList<AbstractDBAction.UpdateBlock> updates = new ArrayList<AbstractDBAction.UpdateBlock>();
        for (final DocumentMetadata document : this.documents) {
            List<ObjectPermission> objectPermissions = document.getObjectPermissions();
            if (null == objectPermissions) continue;
            for (final ObjectPermission objectPermission : objectPermissions) {
                updates.add(new AbstractDBAction.Update("INSERT INTO object_permission (cid,permission_id,module,folder_id,object_id,created_by,shared_by,bits,last_modified,group_flag) VALUES (?,?,?,?,?,?,?,?,?,?);"){

                    @Override
                    public void fillStatement() throws SQLException {
                        this.stmt.setInt(1, DeleteObjectPermissionAction.this.getContext().getContextId());
                        this.stmt.setInt(2, objectPermission.getEntity());
                        this.stmt.setInt(3, 8);
                        this.stmt.setInt(4, (int)document.getFolderId());
                        this.stmt.setInt(5, document.getId());
                        this.stmt.setInt(6, document.getModifiedBy());
                        this.stmt.setInt(7, document.getCreatedBy());
                        this.stmt.setInt(8, objectPermission.getPermissions());
                        this.stmt.setLong(9, document.getLastModified().getTime());
                        this.stmt.setBoolean(10, objectPermission.isGroup());
                    }
                });
                updates.add(new AbstractDBAction.Update("DELETE FROM del_object_permission WHERE cid=? AND object_id=? AND permission_id=?;"){

                    @Override
                    public void fillStatement() throws SQLException {
                        this.stmt.setInt(1, DeleteObjectPermissionAction.this.getContext().getContextId());
                        this.stmt.setInt(2, document.getId());
                        this.stmt.setInt(3, objectPermission.getEntity());
                    }
                });
            }
        }
        this.doUpdates(updates);
    }
}

