/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.database.IncorrectStringSQLException;
import com.openexchange.database.tx.AbstractDBAction;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.utils.GetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.session.Session;
import com.openexchange.tools.exceptions.SimpleIncorrectStringAttribute;
import com.openexchange.tools.session.ServerSession;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONInputStream;
import org.json.JSONObject;
import org.json.JSONValue;

public abstract class AbstractInfostoreAction
extends AbstractDBAction {
    protected final Session optSession;
    private InfostoreQueryCatalog queries;

    protected AbstractInfostoreAction(Session optSession) {
        this.optSession = optSession;
    }

    private static User getUser(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser();
        }
        return UserStorage.getInstance().getUser(session.getUserId(), session.getContextId());
    }

    public static OXException launderOXException(OXException e, Session optSession) throws OXException {
        Throwable cause = e.getCause();
        if (!(cause instanceof IncorrectStringSQLException)) {
            return e;
        }
        return AbstractInfostoreAction.handleIncorrectStringError((IncorrectStringSQLException)cause, optSession);
    }

    public static OXException handleIncorrectStringError(IncorrectStringSQLException incorrectStringError, Session optSession) throws OXException {
        Metadata metadata = Metadata.get(incorrectStringError.getColumn());
        if (null == metadata) {
            return InfostoreExceptionCodes.INVALID_CHARACTER_SIMPLE.create((Throwable)incorrectStringError, new Object[0]);
        }
        return AbstractInfostoreAction.handleIncorrectStringError(incorrectStringError, metadata, optSession);
    }

    public static OXException handleIncorrectStringError(IncorrectStringSQLException incorrectStringError, Metadata metadata, Session optSession) throws OXException {
        if (null == optSession) {
            return InfostoreExceptionCodes.INVALID_CHARACTER.create((Throwable)incorrectStringError, incorrectStringError.getIncorrectString(), incorrectStringError.getColumn());
        }
        String displayName = metadata.getDisplayName();
        if (null == displayName) {
            return InfostoreExceptionCodes.INVALID_CHARACTER.create((Throwable)incorrectStringError, incorrectStringError.getIncorrectString(), incorrectStringError.getColumn());
        }
        String translatedName = StringHelper.valueOf(AbstractInfostoreAction.getUser(optSession).getLocale()).getString(displayName);
        OXException oxe = InfostoreExceptionCodes.INVALID_CHARACTER.create((Throwable)incorrectStringError, incorrectStringError.getIncorrectString(), translatedName);
        oxe.addProblematic((OXException.ProblematicAttribute)new SimpleIncorrectStringAttribute(metadata.getId(), incorrectStringError.getIncorrectString()));
        return oxe;
    }

    @Override
    protected int doUpdates(List<AbstractDBAction.UpdateBlock> updates) throws OXException {
        try {
            return super.doUpdates(updates);
        }
        catch (OXException e) {
            throw AbstractInfostoreAction.launderOXException(e, this.optSession);
        }
    }

    @Override
    protected int doUpdates(AbstractDBAction.UpdateBlock ... updates) throws OXException {
        try {
            return super.doUpdates(updates);
        }
        catch (OXException e) {
            throw AbstractInfostoreAction.launderOXException(e, this.optSession);
        }
    }

    protected final void fillStmt(PreparedStatement stmt, Metadata[] fields, DocumentMetadata doc, Object ... additional) throws SQLException {
        this.fillStmt(1, stmt, fields, doc, additional);
    }

    protected final int fillStmt(int parameterIndex, PreparedStatement stmt, Metadata[] fields, DocumentMetadata doc, Object ... additional) throws SQLException {
        GetSwitch get = new GetSwitch(doc);
        int index = parameterIndex;
        for (Metadata m : fields) {
            if (Metadata.META_LITERAL.getId() == m.getId()) {
                this.setMeta(index++, stmt, doc);
                continue;
            }
            stmt.setObject(index++, this.process(m, m.doSwitch(get)));
        }
        for (Object o : additional) {
            stmt.setObject(index++, o);
        }
        return index;
    }

    private final Object process(Metadata field, Object value) {
        switch (field.getId()) {
            default: {
                return value;
            }
            case 4: 
            case 6: 
            case 707: {
                return ((Date)value).getTime();
            }
            case 5: 
        }
        return value != null ? Long.valueOf(((Date)value).getTime()) : Long.valueOf(System.currentTimeMillis());
    }

    private final void setMeta(int parameterIndex, PreparedStatement stmt, DocumentMetadata doc) throws SQLException {
        Map<String, Object> meta = doc.getMeta();
        if (null == meta || meta.isEmpty()) {
            stmt.setNull(parameterIndex, 2004);
        } else {
            try {
                Object coerced = JSONCoercion.coerceToJSON(meta);
                if (null == coerced || JSONObject.NULL.equals(coerced)) {
                    stmt.setNull(parameterIndex, 2004);
                } else {
                    stmt.setBinaryStream(parameterIndex, (InputStream)new JSONInputStream((JSONValue)coerced, "US-ASCII"));
                }
            }
            catch (JSONException e) {
                throw new SQLException("Meta information could not be coerced to a JSON equivalent.", e);
            }
        }
    }

    public void setQueryCatalog(InfostoreQueryCatalog queries) {
        this.queries = queries;
    }

    public InfostoreQueryCatalog getQueryCatalog() {
        return this.queries;
    }
}

