/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.groupware.container.EffectiveObjectPermission;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.ldap.User;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;

public class EffectiveInfostorePermission {
    private final EffectiveObjectPermission objectPermission;
    private final EffectivePermission permission;
    private final User user;
    private final DocumentMetadata document;
    private final int folderOwner;

    public EffectiveInfostorePermission(EffectivePermission permission, DocumentMetadata document, User user, int folderOwner) {
        this.document = document;
        this.user = user;
        this.permission = permission;
        this.objectPermission = null;
        this.folderOwner = folderOwner;
    }

    public EffectiveInfostorePermission(EffectivePermission permission, EffectiveObjectPermission objectPermission, DocumentMetadata document, User user, int folderOwner) {
        this.document = document;
        this.user = user;
        this.permission = permission;
        this.objectPermission = objectPermission;
        this.folderOwner = folderOwner;
    }

    public int getFolderOwner() {
        return this.folderOwner;
    }

    public boolean canReadObject() {
        return this.canReadObjectInFolder() || this.objectPermission != null && this.objectPermission.canRead();
    }

    public boolean canReadObjectInFolder() {
        return this.permission.canReadAllObjects() || this.permission.canReadOwnObjects() && this.document.getCreatedBy() == this.user.getId();
    }

    public boolean canDeleteObject() {
        return this.canDeleteObjectInFolder() || this.objectPermission != null && this.objectPermission.canDelete();
    }

    public boolean canDeleteObjectInFolder() {
        return this.permission.canDeleteAllObjects() || this.permission.canDeleteOwnObjects() && this.document.getCreatedBy() == this.user.getId();
    }

    public boolean canWriteObject() {
        return this.canWriteObjectInFolder() || this.objectPermission != null && this.objectPermission.canWrite();
    }

    public boolean canShareObject() {
        return this.canShareObjectInFolder() || null != this.objectPermission && this.objectPermission.canShare();
    }

    public boolean canShareObjectInFolder() {
        return this.permission.hasFullSharedFolderAccess() && this.canWriteObjectInFolder();
    }

    public boolean canWriteObjectInFolder() {
        return this.permission.canWriteAllObjects() || this.permission.canWriteOwnObjects() && this.document.getCreatedBy() == this.user.getId();
    }

    public boolean canCreateObjects() {
        return this.permission.canCreateObjects();
    }

    public boolean canCreateSubfolders() {
        return this.permission.canCreateSubfolders();
    }

    public boolean canDeleteAllObjects() {
        return this.permission.canDeleteAllObjects();
    }

    public boolean canDeleteOwnObjects() {
        return this.permission.canDeleteOwnObjects();
    }

    public boolean canReadAllObjects() {
        return this.permission.canReadAllObjects();
    }

    public boolean canReadOwnObjects() {
        return this.permission.canReadOwnObjects();
    }

    public boolean canWriteAllObjects() {
        return this.permission.canWriteAllObjects();
    }

    public boolean canWriteOwnObjects() {
        return this.permission.canWriteOwnObjects();
    }

    public boolean equals(Object obj) {
        return this.permission.equals(obj);
    }

    public int getDeletePermission() {
        return this.permission.getDeletePermission();
    }

    public int getEntity() {
        return this.permission.getEntity();
    }

    public int getFolderPermission() {
        return this.permission.getFolderPermission();
    }

    public int getFuid() {
        return this.permission.getFuid();
    }

    public String getName() {
        return this.permission.getName();
    }

    public int getReadPermission() {
        return this.permission.getReadPermission();
    }

    public OCLPermission getUnderlyingPermission() {
        return this.permission.getUnderlyingPermission();
    }

    public int getWritePermission() {
        return this.permission.getWritePermission();
    }

    public int hashCode() {
        return this.permission.hashCode();
    }

    public boolean hasModuleAccess(int folderModule) {
        return this.permission.hasModuleAccess(folderModule);
    }

    public boolean isFolderAdmin() {
        return this.permission.isFolderAdmin();
    }

    public boolean isFolderVisible() {
        return this.permission.isFolderVisible();
    }

    public boolean isGroupPermission() {
        return this.permission.isGroupPermission();
    }

    public boolean setAllObjectPermission(int pr, int pw, int pd) {
        return this.permission.setAllObjectPermission(pr, pw, pd);
    }

    public boolean setAllPermission(int fp, int opr, int opw, int opd) {
        return this.permission.setAllPermission(fp, opr, opw, opd);
    }

    public boolean setDeleteObjectPermission(int p) {
        return this.permission.setDeleteObjectPermission(p);
    }

    public void setEntity(int entity) {
        this.permission.setEntity(entity);
    }

    public void setFolderAdmin(boolean folderAdmin) {
        this.permission.setFolderAdmin(folderAdmin);
    }

    public boolean setFolderPermission(int p) {
        return this.permission.setFolderPermission(p);
    }

    public void setFuid(int pid) {
        this.permission.setFuid(pid);
    }

    public void setGroupPermission(boolean groupPermission) {
        this.permission.setGroupPermission(groupPermission);
    }

    public void setName(String name) {
        this.permission.setName(name);
    }

    public boolean setReadObjectPermission(int p) {
        return this.permission.setReadObjectPermission(p);
    }

    public boolean setWriteObjectPermission(int p) {
        return this.permission.setWriteObjectPermission(p);
    }

    public EffectivePermission getEffectivePermission() {
        return this.permission;
    }

    public String toString() {
        return this.permission.toString();
    }

    public int getObjectID() {
        return this.document.getId();
    }

    public DocumentMetadata getObject() {
        return this.document;
    }
}

