/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.impl.FolderLock;
import com.openexchange.groupware.impl.FolderLockManager;
import com.openexchange.groupware.impl.FolderTreeUtilImpl;
import com.openexchange.groupware.infostore.webdav.Lock;
import com.openexchange.groupware.infostore.webdav.LockManager;
import com.openexchange.groupware.infostore.webdav.LockManagerImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class FolderLockManagerImpl
extends LockManagerImpl<FolderLock>
implements FolderLockManager {
    private static final String findLocks = "SELECT * FROM oxfolder_lock WHERE cid = ? AND ((entity = ?) OR (entity = ? AND depth = 1) OR (entity IN (%%path%%) AND depth = -1 ) )";

    public FolderLockManagerImpl() {
        super("oxfolder_lock");
    }

    public FolderLockManagerImpl(DBProvider provider) {
        super(provider, "oxfolder_lock");
    }

    @Override
    public List<Lock> findLocks(int entity, Session session) throws OXException {
        Context context = this.getContextFrom(session);
        User user = UserStorage.getInstance().getUser(session.getUserId(), context);
        return new ArrayList<Lock>((Collection)this.loadOwnLocks(Arrays.asList(entity), context, user).get(entity));
    }

    @Override
    public List<FolderLock> findAllLocks(int entity, Context ctx, User user) throws OXException {
        return this.findFolderLocks(entity, ctx, user);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<FolderLock> findFolderLocks(int entity, Context ctx, User user) throws OXException {
        ArrayList<FolderLock> arrayList;
        FolderTreeUtilImpl treeUtil = new FolderTreeUtilImpl(this);
        List<Integer> path = treeUtil.getPath(entity, ctx, user);
        int parent = path.get(path.size() - 2);
        path = path.subList(0, path.size() - 2);
        String query = findLocks.replaceAll("%%path%%", this.join(path, new StringBuilder()).toString());
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = this.getReadConnection(ctx);
            stmt = readCon.prepareStatement(query);
            this.set(1, stmt, null, ctx.getContextId(), entity, parent);
            rs = stmt.executeQuery();
            ArrayList<FolderLock> locks = new ArrayList<FolderLock>();
            while (rs.next()) {
                FolderLock lock = this.newLock();
                this.fillLock(lock, rs);
                if (lock.getTimeout() < 1L) {
                    this.removeLock(lock.getId(), ctx);
                    this.lockExpired(lock);
                    continue;
                }
                locks.add(lock);
            }
            arrayList = locks;
        }
        catch (SQLException x) {
            try {
                throw new OXException();
                catch (OXException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, readCon);
                throw throwable;
            }
        }
        this.close(stmt, rs);
        this.releaseReadConnection(ctx, readCon);
        return arrayList;
    }

    @Override
    public Map<Integer, List<FolderLock>> loadOwnLocks(List<Integer> entities, Context ctx, User user) throws OXException {
        return this.findLocksByEntity(entities, ctx);
    }

    @Override
    public void insertLock(int entity, Lock lock, Session session) throws OXException {
        Context ctx = this.getContextFrom(session);
        User user = UserStorage.getInstance().getUser(session.getUserId(), ctx);
        this.createLockForceId(entity, lock.getId(), lock.getTimeout(), lock.getScope(), lock.getType(), lock.getOwnerDescription(), ctx, user, ((FolderLock)lock).getDepth());
    }

    @Override
    public int lock(int entity, long timeout, LockManager.Scope scope, LockManager.Type type, int depth, String ownerDesc, Context ctx, User user) throws OXException {
        return this.createLock(entity, timeout, scope, type, ownerDesc, ctx, user, depth);
    }

    @Override
    public void unlock(int id, Session session) throws OXException {
        Context ctx = this.getContextFrom(session);
        this.removeLock(id, ctx);
    }

    @Override
    protected FolderLock newLock() {
        return new FolderLock();
    }

    @Override
    protected void fillLock(FolderLock lock, ResultSet rs) throws SQLException {
        super.fillLock(lock, rs);
        lock.setDepth(rs.getInt("depth"));
    }

    @Override
    protected String initAdditionalFIND_BY_ENTITY(String findByEntity) {
        return findByEntity.replaceAll("%%additional_fields%%", ", depth");
    }

    @Override
    protected String initAdditionalINSERT(String insert) {
        insert = this.initAdditionalFIND_BY_ENTITY(insert);
        return insert.replaceAll("%%additional_question_marks%%", ", ?");
    }

    @Override
    protected int getType() {
        return 137;
    }

    @Override
    public void removeAll(int entity, Session session) throws OXException {
        Context ctx = this.getContextFrom(session);
        this.removeAllFromEntity(entity, ctx);
    }

    private Context getContextFrom(Session session) throws OXException {
        return session instanceof ServerSession ? ((ServerSession)session).getContext() : ContextStorage.getInstance().getContext(session);
    }
}

