/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.osgi;

import com.openexchange.config.ConfigurationService;
import java.io.File;
import java.io.FileFilter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class TmpFileCleaner
implements ServiceTrackerCustomizer<ConfigurationService, ConfigurationService> {
    private final BundleContext context;

    public TmpFileCleaner(BundleContext context) {
        this.context = context;
    }

    public ConfigurationService addingService(ServiceReference<ConfigurationService> reference) {
        File dir;
        ConfigurationService service = (ConfigurationService)this.context.getService(reference);
        String directory = service.getProperty("UPLOAD_DIRECTORY");
        if (null != directory && (dir = new File(directory)).isDirectory() && dir.canWrite()) {
            File[] tmpFiles;
            for (File file : tmpFiles = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    return name.startsWith("open-xchange-") || name.startsWith("openexchange");
                }
            })) {
                try {
                    file.delete();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
        }
        this.context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference<ConfigurationService> reference, ConfigurationService service) {
    }

    public void removedService(ServiceReference<ConfigurationService> reference, ConfigurationService service) {
    }
}

