/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.PropertyEvent;
import com.openexchange.config.PropertyListener;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.DistributedFileManagement;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileExceptionErrorMessage;
import com.openexchange.filemanagement.ManagedFileFilter;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.filemanagement.internal.ManagedFileImpl;
import com.openexchange.filemanagement.internal.ManagedInputStream;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManagedFileManagementImpl
implements ManagedFileManagement {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedFileManagementImpl.class);
    private static final int DELAY = 120000;
    private static final String PREFIX = "open-xchange-managedfile-" + OXException.getServerId() + "-";
    private static final String PREFIX_WO_EVICT = "open-xchange-newfile-" + OXException.getServerId() + "-";
    private static final String SUFFIX = ".tmp";
    private final ConfigurationService cs;
    private final TimerService timer;
    private final DispatcherPrefixService dispatcherPrefixService;
    private final ConcurrentMap<String, ManagedFileImpl> files;
    private final ReadWriteLock creationRwLock;
    private final PropertyListener propertyListener;
    private final AtomicReference<File> tmpDirReference;
    private final AtomicReference<ScheduledTimerTask> timerTaskReference;

    public ManagedFileManagementImpl(ConfigurationService cs, TimerService timer, DispatcherPrefixService dispatcherPrefixService) {
        this.cs = cs;
        this.timer = timer;
        this.dispatcherPrefixService = dispatcherPrefixService;
        this.files = new ConcurrentHashMap<String, ManagedFileImpl>();
        this.creationRwLock = new ReentrantReadWriteLock();
        AtomicReference<File> tmpDirReference = new AtomicReference<File>();
        this.tmpDirReference = tmpDirReference;
        this.propertyListener = new FileManagementPropertyListener(tmpDirReference);
        String path = cs.getProperty("UPLOAD_DIRECTORY", this.propertyListener);
        tmpDirReference.set(this.getTmpDirByPath(path));
        ScheduledTimerTask timerTask = timer.scheduleWithFixedDelay((Runnable)new FileManagementTask(this.files, this.creationRwLock.writeLock(), 300000, tmpDirReference, PREFIX, LOG), 120000L, 120000L);
        this.timerTaskReference = new AtomicReference<ScheduledTimerTask>(timerTask);
    }

    public InputStream createInputStream(byte[] bytes) throws OXException {
        return new ManagedInputStream(bytes, (ManagedFileManagement)this);
    }

    public InputStream createInputStream(byte[] bytes, int capacity) throws OXException {
        return new ManagedInputStream(bytes, capacity, (ManagedFileManagement)this);
    }

    public InputStream createInputStream(InputStream in) throws OXException {
        return new ManagedInputStream(in, (ManagedFileManagement)this);
    }

    public InputStream createInputStream(InputStream in, int capacity) throws OXException {
        return new ManagedInputStream(in, capacity, (ManagedFileManagement)this);
    }

    public InputStream createInputStream(InputStream in, int size, int capacity) throws OXException {
        return new ManagedInputStream(in, size, capacity, this);
    }

    public void clear() {
        for (ManagedFileImpl managedFileImpl : this.files.values()) {
            managedFileImpl.delete();
        }
        this.files.clear();
    }

    public File newTempFile() throws OXException {
        return this.newTempFile(PREFIX_WO_EVICT, SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File newTempFile(String prefix, String suffix) throws OXException {
        String prfx = prefix;
        if (PREFIX.equals(prfx)) {
            prfx = PREFIX_WO_EVICT;
        }
        Lock creationLock = this.creationRwLock.readLock();
        creationLock.lock();
        try {
            File tmpFile = null;
            File directory = null;
            do {
                directory = this.tmpDirReference.get();
                try {
                    if (null == tmpFile) {
                        tmpFile = File.createTempFile(prfx, suffix, directory);
                        tmpFile.deleteOnExit();
                        continue;
                    }
                    File tmp = File.createTempFile(prfx, suffix, directory);
                    if (!tmpFile.delete()) {
                        LOG.warn("Temporary file could not be deleted: {}", (Object)tmpFile.getPath());
                    }
                    tmpFile = tmp;
                    tmpFile.deleteOnExit();
                }
                catch (IOException e) {
                    if (tmpFile != null && !tmpFile.delete()) {
                        LOG.warn("Temporary file could not be deleted: {}", (Object)tmpFile.getPath(), (Object)e);
                    }
                    throw ManagedFileExceptionErrorMessage.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            } while (!this.tmpDirReference.compareAndSet(directory, directory));
            File file = tmpFile;
            return file;
        }
        finally {
            creationLock.unlock();
        }
    }

    public ManagedFile createManagedFile(File temporaryFile) throws OXException {
        return this.createManagedFile(temporaryFile, -1);
    }

    public ManagedFile createManagedFile(File temporaryFile, int ttl) throws OXException {
        ManagedFileImpl mf = new ManagedFileImpl(this, UUID.randomUUID().toString(), temporaryFile, ttl, this.dispatcherPrefixService.getPrefix());
        mf.setSize(temporaryFile.length());
        this.files.put(mf.getID(), mf);
        return mf;
    }

    public ManagedFile createManagedFile(byte[] bytes) throws OXException {
        return this.createManagedFile0(null, (InputStream)new UnsynchronizedByteArrayInputStream(bytes), false, null, -1);
    }

    public ManagedFile createManagedFile(byte[] bytes, boolean distribute) throws OXException {
        return this.createManagedFile0(null, (InputStream)new UnsynchronizedByteArrayInputStream(bytes), false, null, -1, distribute);
    }

    public ManagedFile createManagedFile(InputStream inputStream) throws OXException {
        return this.createManagedFile(null, inputStream);
    }

    public ManagedFile createManagedFile(InputStream inputStream, boolean distribute) throws OXException {
        return this.createManagedFile(null, inputStream, distribute);
    }

    public ManagedFile createManagedFile(String id, InputStream inputStream) throws OXException {
        return this.createManagedFile0(id, inputStream, true, null, -1);
    }

    public ManagedFile createManagedFile(String id, InputStream inputStream, boolean distribute) throws OXException {
        return this.createManagedFile0(id, inputStream, true, null, -1, distribute);
    }

    public ManagedFile createManagedFile(String id, InputStream inputStream, int ttl) throws OXException {
        return this.createManagedFile0(id, inputStream, true, null, ttl);
    }

    public ManagedFile createManagedFile(InputStream inputStream, String optExtension) throws OXException {
        return this.createManagedFile0(null, inputStream, true, optExtension, -1);
    }

    public ManagedFile createManagedFile(InputStream inputStream, String optExtension, int ttl) throws OXException {
        return this.createManagedFile0(null, inputStream, true, optExtension, ttl);
    }

    public ManagedFile createManagedFile(InputStream inputStream, int ttl) throws OXException {
        return this.createManagedFile0(null, inputStream, true, null, ttl);
    }

    private ManagedFile createManagedFile0(String identifier, InputStream inputStream, boolean closeStream, String optExtension, int optTtl) throws OXException {
        return this.createManagedFile0(identifier, inputStream, closeStream, optExtension, optTtl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedFile createManagedFile0(String identifier, InputStream inputStream, boolean closeStream, String optExtension, int optTtl, boolean distribute) throws OXException {
        if (null == inputStream) {
            throw new IllegalArgumentException("Missing input stream.");
        }
        Lock creationLock = this.creationRwLock.readLock();
        creationLock.lock();
        try {
            DistributedFileManagement distributed;
            ManagedFileImpl mf = null;
            File tmpFile = null;
            File directory = null;
            String id = identifier;
            do {
                directory = this.tmpDirReference.get();
                boolean errorDuringFileCreation = true;
                try {
                    if (null == tmpFile) {
                        tmpFile = File.createTempFile(PREFIX, null == optExtension ? SUFFIX : optExtension, directory);
                        tmpFile.deleteOnExit();
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpFile, false));
                        try {
                            int read;
                            int blen = 65536;
                            byte[] buf = new byte[blen];
                            while ((read = inputStream.read(buf, 0, blen)) > 0) {
                                ((OutputStream)out).write(buf, 0, read);
                            }
                            ((OutputStream)out).flush();
                        }
                        finally {
                            Streams.close((Closeable)out);
                        }
                    }
                    File newTmpFile = File.createTempFile(PREFIX, null == optExtension ? SUFFIX : optExtension, directory);
                    newTmpFile.deleteOnExit();
                    boolean errorDuringCopy = true;
                    try {
                        ManagedFileManagementImpl.copyFile(tmpFile, newTmpFile);
                        errorDuringCopy = false;
                    }
                    finally {
                        if (errorDuringCopy && !newTmpFile.delete()) {
                            LOG.warn("Temporary file could not be deleted: {}", (Object)newTmpFile.getPath());
                        }
                    }
                    if (!tmpFile.delete()) {
                        LOG.warn("Temporary file could not be deleted: {}", (Object)tmpFile.getPath());
                    }
                    tmpFile = newTmpFile;
                    errorDuringFileCreation = false;
                }
                catch (IOException e) {
                    throw ManagedFileExceptionErrorMessage.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (RuntimeException e) {
                    throw ManagedFileExceptionErrorMessage.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                finally {
                    if (closeStream) {
                        Streams.close((Closeable)inputStream);
                    }
                    if (errorDuringFileCreation && null != tmpFile && !tmpFile.delete()) {
                        LOG.warn("Temporary file could not be deleted: {}", (Object)tmpFile.getPath());
                    }
                }
                if (Strings.isEmpty((String)id)) {
                    id = UUID.randomUUID().toString();
                }
                mf = new ManagedFileImpl(this, id, tmpFile, optTtl, this.dispatcherPrefixService.getPrefix());
                mf.setFileName(tmpFile.getName());
                mf.setSize(tmpFile.length());
            } while (!this.tmpDirReference.compareAndSet(directory, directory));
            this.files.put(mf.getID(), mf);
            if (distribute && (distributed = this.getDistributed()) != null && !distributed.exists(id)) {
                distributed.register(id);
            }
            ManagedFileImpl managedFileImpl = mf;
            return managedFileImpl;
        }
        finally {
            creationLock.unlock();
        }
    }

    public boolean containsLocal(String id) {
        ManagedFile mf = (ManagedFile)this.files.get(id);
        if (null == mf || mf.isDeleted()) {
            return false;
        }
        mf.touch();
        return true;
    }

    public boolean contains(String id) {
        ManagedFile mf = (ManagedFile)this.files.get(id);
        if (null == mf || mf.isDeleted()) {
            return this.containsDistributed(id);
        }
        mf.touch();
        return true;
    }

    private boolean containsDistributed(String id) {
        DistributedFileManagement distributedFileManagement = this.getDistributed();
        if (distributedFileManagement == null) {
            return false;
        }
        try {
            if (distributedFileManagement.exists(id)) {
                distributedFileManagement.touch(id);
                return true;
            }
        }
        catch (OXException e) {
            return false;
        }
        return false;
    }

    public List<ManagedFile> getManagedFiles() throws OXException {
        return this.getManagedFiles(null);
    }

    public List<ManagedFile> getManagedFiles(ManagedFileFilter filter) throws OXException {
        if (null == filter) {
            return new ArrayList<ManagedFile>(this.files.values());
        }
        ArrayList<ManagedFile> list = new ArrayList<ManagedFile>(this.files.size());
        for (ManagedFile managedFile : this.files.values()) {
            if (!filter.accept(managedFile)) continue;
            list.add(managedFile);
        }
        return list;
    }

    public ManagedFile getByID(String id) throws OXException {
        ManagedFile mf = this.optByID(id);
        if (null == mf) {
            throw ManagedFileExceptionErrorMessage.NOT_FOUND.create(new Object[]{id});
        }
        return mf;
    }

    public ManagedFile optByID(String id) {
        ManagedFile mf = (ManagedFile)this.files.get(id);
        if (null != mf) {
            if (mf.isDeleted()) {
                return null;
            }
            mf.touch();
            return mf;
        }
        mf = this.getByIDDistributed(id);
        if (null == mf || mf.isDeleted()) {
            return null;
        }
        mf.touch();
        return mf;
    }

    private ManagedFile getByIDDistributed(String id) {
        DistributedFileManagement distributedFileManagement = this.getDistributed();
        if (distributedFileManagement == null) {
            return null;
        }
        try {
            if (!distributedFileManagement.exists(id)) {
                return null;
            }
            ManagedFile managedFile = this.createManagedFile(id, distributedFileManagement.get(id));
            try {
                distributedFileManagement.touch(id);
            }
            catch (Exception e) {
                // empty catch block
            }
            return managedFile;
        }
        catch (OXException e) {
            LOG.warn("Could not load remote file: {}", (Object)id, (Object)e);
            return null;
        }
    }

    File getTmpDirByPath(String path) {
        if (null == path) {
            throw new IllegalArgumentException("Path is null. Probably property \"UPLOAD_DIRECTORY\" is not set.");
        }
        File tmpDir = new File(path);
        if (!tmpDir.exists()) {
            throw new IllegalArgumentException("Directory " + path + " does not exist.");
        }
        if (!tmpDir.isDirectory()) {
            throw new IllegalArgumentException(path + " is not a directory.");
        }
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByID(String id) {
        ManagedFile mf = (ManagedFile)this.files.get(id);
        if (null == mf) {
            this.removeByIDDistributed(id);
            return;
        }
        try {
            if (!mf.isDeleted()) {
                mf.delete();
                DistributedFileManagement distributedFileManagement = this.getDistributed();
                if (distributedFileManagement != null) {
                    distributedFileManagement.unregister(id);
                }
            }
        }
        catch (OXException oXException) {
        }
        finally {
            this.files.remove(mf.getID());
        }
    }

    private void removeByIDDistributed(String id) {
        DistributedFileManagement distributedFileManagement = this.getDistributed();
        if (distributedFileManagement == null) {
            return;
        }
        try {
            distributedFileManagement.remove(id);
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }

    void removeFromFiles(String id) {
        DistributedFileManagement distributedFileManagement = this.getDistributed();
        if (distributedFileManagement != null) {
            try {
                distributedFileManagement.unregister(id);
            }
            catch (OXException oXException) {
                // empty catch block
            }
        }
        this.files.remove(id);
    }

    public void shutDown() {
        this.shutDown(true);
    }

    void shutDown(boolean complete) {
        if (complete && this.propertyListener != null) {
            this.cs.removePropertyListener("UPLOAD_DIRECTORY", this.propertyListener);
        }
        this.stopTimerTask();
        this.tmpDirReference.set(null);
        this.clear();
    }

    private boolean stopTimerTask() {
        ScheduledTimerTask timerTask;
        do {
            if (null != (timerTask = this.timerTaskReference.get())) continue;
            return false;
        } while (!this.timerTaskReference.compareAndSet(timerTask, null));
        timerTask.cancel(true);
        this.timer.purge();
        return true;
    }

    void startUp() {
        if (this.stopTimerTask()) {
            this.timerTaskReference.set(this.timer.scheduleWithFixedDelay((Runnable)new FileManagementTask(this.files, this.creationRwLock.writeLock(), 300000, this.tmpDirReference, PREFIX, LOG), 120000L, 120000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private DistributedFileManagement getDistributed() {
        return ServerServiceRegistry.getInstance().getService(DistributedFileManagement.class);
    }

    private static class FileManagementTask
    implements Runnable {
        private final Logger logger;
        private final ConcurrentMap<String, ManagedFileImpl> tfiles;
        private final int time2live;
        private final AtomicReference<File> tmpDirReference;
        private final FileFilter defaultPrefixFilter;
        private final Lock exclusiveCreationLock;

        FileManagementTask(ConcurrentMap<String, ManagedFileImpl> files, Lock exclusiveCreationLock, int time2live, AtomicReference<File> tmpDirReference, final String defaultPrefix, Logger logger) {
            this.tfiles = files;
            this.exclusiveCreationLock = exclusiveCreationLock;
            this.time2live = time2live;
            this.tmpDirReference = tmpDirReference;
            this.defaultPrefixFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().startsWith(defaultPrefix, 0);
                }
            };
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.exclusiveCreationLock.lock();
            try {
                HashMap<String, File> existentFiles = new HashMap<String, File>(256, 0.9f);
                File directory = this.tmpDirReference.get();
                if (!directory.canRead()) {
                    this.logger.warn("Unable to read directory {}. {} run aborted...", (Object)directory.getAbsolutePath(), (Object)FileManagementTask.class.getSimpleName());
                    return;
                }
                File[] listedFiles = directory.listFiles(this.defaultPrefixFilter);
                if (listedFiles.length == 0) {
                    return;
                }
                for (File tmpFile : listedFiles) {
                    existentFiles.put(tmpFile.getName(), tmpFile);
                }
                long now = System.currentTimeMillis();
                Iterator iter = this.tfiles.values().iterator();
                while (iter.hasNext()) {
                    ManagedFileImpl cur = (ManagedFileImpl)iter.next();
                    if (null == cur) {
                        iter.remove();
                        continue;
                    }
                    int optTimeToLive = cur.optTimeToLive();
                    long timeElapsed = now - cur.getLastAccess();
                    if (cur.isDeleted() || timeElapsed > (long)(optTimeToLive > 0 ? optTimeToLive : this.time2live)) {
                        File file = cur.getFilePlain();
                        String fname = null != file && file.exists() ? file.getName() : "";
                        cur.delete();
                        iter.remove();
                        this.logger.debug("Removed expired managed file {}", (Object)fname);
                        continue;
                    }
                    existentFiles.remove(cur.getFilePlain().getName());
                }
                for (Map.Entry entry : existentFiles.entrySet()) {
                    String name = (String)entry.getKey();
                    File orphaned = (File)entry.getValue();
                    if (!orphaned.delete()) {
                        this.logger.warn("Temporary file could not be deleted: {}", (Object)name);
                    }
                    this.logger.debug("Removed orphaned managed file {}", (Object)name);
                }
            }
            catch (Exception t) {
                this.logger.error("", (Throwable)t);
            }
            finally {
                this.exclusiveCreationLock.unlock();
            }
        }
    }

    private class FileManagementPropertyListener
    implements PropertyListener {
        private final AtomicReference<File> ttmpDirReference;

        public FileManagementPropertyListener(AtomicReference<File> tmpDirReference) {
            this.ttmpDirReference = tmpDirReference;
        }

        public void onPropertyChange(PropertyEvent event) {
            if (PropertyEvent.Type.CHANGED.equals((Object)event.getType())) {
                this.ttmpDirReference.set(ManagedFileManagementImpl.this.getTmpDirByPath(event.getValue()));
                ManagedFileManagementImpl.this.startUp();
            } else {
                ManagedFileManagementImpl.this.shutDown(false);
            }
        }
    }
}

