/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.context.mbean;

import com.openexchange.context.mbean.ContextMBean;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import gnu.trove.list.linked.TIntLinkedList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextMBeanImpl
extends StandardMBean
implements ContextMBean {
    public ContextMBeanImpl() throws NotCompliantMBeanException {
        super(ContextMBean.class);
    }

    @Override
    public void checkLogin2ContextMapping() throws MBeanException {
        DatabaseService databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (null == databaseService) {
            OXException oxe = ServiceExceptionCode.absentService(DatabaseService.class);
            throw new MBeanException((Exception)((Object)oxe), oxe.getMessage());
        }
        Connection con = null;
        try {
            con = databaseService.getWritable();
            TIntLinkedList contextIds = new TIntLinkedList();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = con.prepareStatement("SELECT DISTINCT t1.cid FROM login2context AS t1 WHERE CONCAT('', t1.cid) NOT IN (SELECT t2.login_info FROM login2context AS t2 WHERE t2.cid = t1.cid)");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    contextIds.add(rs.getInt(1));
                }
            }
            catch (SQLException e) {
                try {
                    throw new MBeanException(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    Databases.closeSQLStuff(rs, (Statement)stmt);
                    throw throwable;
                }
            }
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            if (!contextIds.isEmpty()) {
                Logger logger = LoggerFactory.getLogger(ContextMBeanImpl.class);
                for (int contextId : contextIds.toArray()) {
                    PreparedStatement stmt2 = null;
                    try {
                        stmt2 = con.prepareStatement("INSERT INTO login2context (cid, login_info) VALUES (?, ?)");
                        stmt2.setInt(1, contextId);
                        stmt2.setString(2, Integer.toString(contextId));
                        try {
                            stmt2.executeUpdate();
                        }
                        catch (Exception e) {
                            logger.warn("Couldn't add context identifier to login2context mappings for context {}", (Object)contextId, (Object)e);
                        }
                    }
                    catch (SQLException e) {
                        throw new MBeanException(e, e.getMessage());
                    }
                    finally {
                        Databases.closeSQLStuff((Statement)stmt2);
                    }
                }
                ContextStorage cs = ContextStorage.getInstance();
                for (int contextId : contextIds.toArray()) {
                    try {
                        cs.invalidateContext(contextId);
                    }
                    catch (Exception e) {
                        logger.warn("Error invalidating cached infos of context {} in context storage", (Object)contextId, (Object)e);
                    }
                }
            }
        }
        catch (OXException e) {
            throw new MBeanException((Exception)((Object)e), e.getMessage());
        }
        finally {
            databaseService.backWritable(con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkLogin2ContextMapping(int contextId) throws MBeanException {
        DatabaseService databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (null == databaseService) {
            OXException oxe = ServiceExceptionCode.absentService(DatabaseService.class);
            throw new MBeanException((Exception)((Object)oxe), oxe.getMessage());
        }
        Connection con = null;
        PreparedStatement stmt = null;
        con = databaseService.getWritable();
        stmt = con.prepareStatement("INSERT INTO login2context (cid, login_info) VALUES (?, ?)");
        stmt.setInt(1, contextId);
        stmt.setString(2, Integer.toString(contextId));
        stmt.executeUpdate();
        Databases.closeSQLStuff((Statement)stmt);
        databaseService.backWritable(con);
        ContextStorage cs = ContextStorage.getInstance();
        try {
            cs.invalidateContext(contextId);
            return;
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(ContextMBeanImpl.class);
            logger.warn("Error invalidating cached infos of context {} in context storage", (Object)contextId, (Object)e);
            return;
        }
        catch (SQLException e) {
            try {
                throw new MBeanException(e, e.getMessage());
                catch (OXException e2) {
                    throw new MBeanException((Exception)((Object)e2), e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(stmt);
                databaseService.backWritable(con);
                throw throwable;
            }
        }
    }
}

