/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.osgi;

import com.openexchange.ajax.Multiple;
import com.openexchange.ajax.osgi.AbstractSessionServletActivator;
import com.openexchange.ajax.requesthandler.AJAXActionAnnotationProcessor;
import com.openexchange.ajax.requesthandler.AJAXActionCustomizer;
import com.openexchange.ajax.requesthandler.AJAXActionCustomizerFactory;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXResultDecorator;
import com.openexchange.ajax.requesthandler.AJAXResultDecoratorRegistry;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.DefaultConverter;
import com.openexchange.ajax.requesthandler.DefaultDispatcher;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.DispatcherNotesProcessor;
import com.openexchange.ajax.requesthandler.DispatcherServlet;
import com.openexchange.ajax.requesthandler.Dispatchers;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.cache.PreviewFilestoreLocationUpdater;
import com.openexchange.ajax.requesthandler.converters.BasicTypeAPIResultConverter;
import com.openexchange.ajax.requesthandler.converters.BasicTypeJsonConverter;
import com.openexchange.ajax.requesthandler.converters.DebugConverter;
import com.openexchange.ajax.requesthandler.converters.Native2JSONConverter;
import com.openexchange.ajax.requesthandler.converters.NativeConverter;
import com.openexchange.ajax.requesthandler.converters.cover.CoverExtractor;
import com.openexchange.ajax.requesthandler.converters.cover.CoverExtractorRegistry;
import com.openexchange.ajax.requesthandler.converters.cover.CoverResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.DownloadPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.FilteredHTMLPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.HTMLPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.MailFilteredHTMLPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.MailTextPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewImageResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewThumbResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.TextPreviewResultConverter;
import com.openexchange.ajax.requesthandler.customizer.ConversionCustomizer;
import com.openexchange.ajax.requesthandler.oauth.OAuthAnnotationProcessor;
import com.openexchange.ajax.requesthandler.oauth.OAuthDispatcherServlet;
import com.openexchange.ajax.requesthandler.osgi.BodyParserRegistry;
import com.openexchange.ajax.requesthandler.osgi.DecoratingAJAXActionCustomizer;
import com.openexchange.ajax.requesthandler.osgi.OSGiAJAXResultDecoratorRegistry;
import com.openexchange.ajax.requesthandler.osgi.OSGiCoverExtractorRegistry;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.FileResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.PreviewResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.StringResponseRenderer;
import com.openexchange.ajax.response.IncludeStackTraceService;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.config.ConfigurationService;
import com.openexchange.context.ContextService;
import com.openexchange.continuation.ContinuationRegistryService;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.groupware.filestore.FileLocationHandler;
import com.openexchange.mail.mime.utils.ImageMatcher;
import com.openexchange.oauth.provider.OAuthResourceService;
import com.openexchange.oauth.provider.OAuthSessionProvider;
import com.openexchange.oauth.provider.annotations.OAuthModule;
import com.openexchange.osgi.SimpleRegistryListener;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.images.ImageTransformationService;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class DispatcherActivator
extends AbstractSessionServletActivator {
    final Set<String> servlets = new HashSet<String>();
    volatile String prefix;

    protected void startBundle() throws Exception {
        DispatcherPrefixService dispatcherPrefixService = (DispatcherPrefixService)this.getService(DispatcherPrefixService.class);
        this.prefix = dispatcherPrefixService.getPrefix();
        Dispatchers.setDispatcherPrefixService(dispatcherPrefixService);
        Dispatcher.PREFIX.set(this.prefix);
        final DefaultDispatcher dispatcher = new DefaultDispatcher();
        final DefaultConverter defaultConverter = new DefaultConverter();
        this.registerService(Converter.class, defaultConverter);
        defaultConverter.addConverter(new DebugConverter());
        defaultConverter.addConverter(new NativeConverter());
        defaultConverter.addConverter(new Native2JSONConverter());
        for (ResultConverter converter : BasicTypeAPIResultConverter.CONVERTERS) {
            defaultConverter.addConverter(converter);
        }
        for (ResultConverter converter : BasicTypeJsonConverter.CONVERTERS) {
            defaultConverter.addConverter(converter);
        }
        defaultConverter.addConverter(new CoverResultConverter());
        TextPreviewResultConverter textPreviewResultConverter = new TextPreviewResultConverter();
        FilteredHTMLPreviewResultConverter filteredHTMLPreviewResultConverter = new FilteredHTMLPreviewResultConverter();
        defaultConverter.addConverter(new HTMLPreviewResultConverter());
        defaultConverter.addConverter(textPreviewResultConverter);
        defaultConverter.addConverter(filteredHTMLPreviewResultConverter);
        defaultConverter.addConverter(new DownloadPreviewResultConverter());
        defaultConverter.addConverter(new PreviewImageResultConverter());
        defaultConverter.addConverter(new PreviewThumbResultConverter((ConfigurationService)this.getOptionalService(ConfigurationService.class)));
        defaultConverter.addConverter(new MailTextPreviewResultConverter(textPreviewResultConverter));
        defaultConverter.addConverter(new MailFilteredHTMLPreviewResultConverter(filteredHTMLPreviewResultConverter));
        this.track(ResultConverter.class, (SimpleRegistryListener)new SimpleRegistryListener<ResultConverter>(){

            public void added(ServiceReference<ResultConverter> ref, ResultConverter thing) {
                defaultConverter.addConverter(thing);
            }

            public void removed(ServiceReference<ResultConverter> ref, ResultConverter thing) {
                defaultConverter.removeConverter(thing);
            }
        });
        BundleContext context = this.context;
        BodyParserRegistry registry = new BodyParserRegistry(context);
        this.rememberTracker(registry);
        AJAXRequestDataTools.setBodyParserRegistry(registry);
        OSGiCoverExtractorRegistry coverExtractorRegistry = new OSGiCoverExtractorRegistry(context);
        this.track(CoverExtractor.class, coverExtractorRegistry);
        this.registerService(CoverExtractorRegistry.class, coverExtractorRegistry);
        ServerServiceRegistry.getInstance().addService(CoverExtractorRegistry.class, coverExtractorRegistry);
        CoverExtractorRegistry.REGISTRY_REFERENCE.set(coverExtractorRegistry);
        OSGiAJAXResultDecoratorRegistry decoratorRegistry = new OSGiAJAXResultDecoratorRegistry(context);
        this.track(AJAXResultDecorator.class, decoratorRegistry);
        this.registerService(AJAXResultDecoratorRegistry.class, decoratorRegistry);
        ServerServiceRegistry.getInstance().addService(AJAXResultDecoratorRegistry.class, decoratorRegistry);
        DecoratingAJAXActionCustomizer.REGISTRY_REF.set(decoratorRegistry);
        dispatcher.addCustomizer(new ConversionCustomizer(defaultConverter));
        dispatcher.addCustomizer(new AJAXActionCustomizerFactory(){

            @Override
            public AJAXActionCustomizer createCustomizer(AJAXRequestData request, ServerSession session) {
                return DecoratingAJAXActionCustomizer.getInstance();
            }
        });
        Multiple.setDispatcher(dispatcher);
        DispatcherServlet.setDispatcher(dispatcher);
        DispatcherServlet.registerRenderer(new APIResponseRenderer());
        final FileResponseRenderer fileRenderer = new FileResponseRenderer();
        DispatcherServlet.registerRenderer(fileRenderer);
        DispatcherServlet.registerRenderer(new StringResponseRenderer());
        DispatcherServlet.registerRenderer(new PreviewResponseRenderer());
        this.registerService(AJAXActionAnnotationProcessor.class, new DispatcherNotesProcessor());
        this.registerService(AJAXActionAnnotationProcessor.class, new OAuthAnnotationProcessor());
        final DispatcherServlet dispatcherServlet = new DispatcherServlet(this.prefix);
        final OAuthDispatcherServlet oAuthDispatcherServlet = new OAuthDispatcherServlet((ServiceLookup)this, this.prefix);
        this.trackService(OAuthResourceService.class);
        this.trackService(OAuthSessionProvider.class);
        this.trackService(ContextService.class);
        this.trackService(UserService.class);
        this.trackService(SessiondService.class);
        this.track(ResponseRenderer.class, (SimpleRegistryListener)new SimpleRegistryListener<ResponseRenderer>(){

            public void added(ServiceReference<ResponseRenderer> ref, ResponseRenderer thing) {
                DispatcherServlet.registerRenderer(thing);
            }

            public void removed(ServiceReference<ResponseRenderer> ref, ResponseRenderer thing) {
                DispatcherServlet.unregisterRenderer(thing);
            }
        });
        this.track(IncludeStackTraceService.class, (SimpleRegistryListener)new SimpleRegistryListener<IncludeStackTraceService>(){

            public void added(ServiceReference<IncludeStackTraceService> ref, IncludeStackTraceService thing) {
                ResponseWriter.setIncludeStackTraceService(thing);
            }

            public void removed(ServiceReference<IncludeStackTraceService> ref, IncludeStackTraceService thing) {
                ResponseWriter.setIncludeStackTraceService(null);
            }
        });
        this.track(AJAXActionServiceFactory.class, (SimpleRegistryListener)new SimpleRegistryListener<AJAXActionServiceFactory>(){

            public void added(ServiceReference<AJAXActionServiceFactory> ref, AJAXActionServiceFactory service) {
                String module = (String)ref.getProperty("module");
                dispatcher.register(module, service);
                if (DispatcherActivator.this.servlets.add(module)) {
                    DispatcherActivator.this.registerSessionServlet(DispatcherActivator.this.prefix + module, dispatcherServlet, new String[0]);
                    if (service.getClass().isAnnotationPresent(OAuthModule.class)) {
                        DispatcherActivator.this.registerSessionServlet(DispatcherActivator.this.prefix + "oauth/modules/" + module, oAuthDispatcherServlet, new String[0]);
                    }
                }
            }

            public void removed(ServiceReference<AJAXActionServiceFactory> ref, AJAXActionServiceFactory service) {
                String module = (String)ref.getProperty("module");
                if (DispatcherActivator.this.servlets.remove(module)) {
                    DispatcherActivator.this.unregisterServlet(DispatcherActivator.this.prefix + module);
                    if (service.getClass().isAnnotationPresent(OAuthModule.class)) {
                        DispatcherActivator.this.unregisterServlet(DispatcherActivator.this.prefix + "oauth/modules/" + module);
                    }
                }
                dispatcher.remove(module, service);
            }
        });
        this.track(AJAXActionAnnotationProcessor.class, (SimpleRegistryListener)new SimpleRegistryListener<AJAXActionAnnotationProcessor>(){

            public void added(ServiceReference<AJAXActionAnnotationProcessor> ref, AJAXActionAnnotationProcessor service) {
                dispatcher.addAnnotationProcessor(service);
            }

            public void removed(ServiceReference<AJAXActionAnnotationProcessor> ref, AJAXActionAnnotationProcessor service) {
                dispatcher.removeAnnotationProcessor(service);
            }
        });
        this.track(ImageTransformationService.class, (SimpleRegistryListener)new SimpleRegistryListener<ImageTransformationService>(){

            public void added(ServiceReference<ImageTransformationService> ref, ImageTransformationService thing) {
                fileRenderer.setScaler(thing);
            }

            public void removed(ServiceReference<ImageTransformationService> ref, ImageTransformationService thing) {
                fileRenderer.setScaler(null);
            }
        });
        this.track(ContinuationRegistryService.class, (SimpleRegistryListener)new SimpleRegistryListener<ContinuationRegistryService>(){

            public void added(ServiceReference<ContinuationRegistryService> ref, ContinuationRegistryService thing) {
                ServerServiceRegistry.getInstance().addService(ContinuationRegistryService.class, thing);
            }

            public void removed(ServiceReference<ContinuationRegistryService> ref, ContinuationRegistryService thing) {
                ServerServiceRegistry.getInstance().removeService(ContinuationRegistryService.class);
            }
        });
        this.track(AJAXActionCustomizerFactory.class, (SimpleRegistryListener)new SimpleRegistryListener<AJAXActionCustomizerFactory>(){

            public void added(ServiceReference<AJAXActionCustomizerFactory> ref, AJAXActionCustomizerFactory service) {
                dispatcher.addCustomizer(service);
            }

            public void removed(ServiceReference<AJAXActionCustomizerFactory> ref, AJAXActionCustomizerFactory service) {
                dispatcher.removeCustomizer(service);
            }
        });
        this.openTrackers();
        this.registerService(Dispatcher.class, dispatcher);
        this.registerService(FileLocationHandler.class, new PreviewFilestoreLocationUpdater());
    }

    protected void stopBundle() throws Exception {
        super.stopBundle();
        DispatcherServlet.clearRenderer();
        DispatcherServlet.setDispatcher(null);
        ServerServiceRegistry.getInstance().removeService(AJAXResultDecoratorRegistry.class);
        DecoratingAJAXActionCustomizer.REGISTRY_REF.set(null);
        CoverExtractorRegistry.REGISTRY_REFERENCE.set(null);
        this.unregisterServlet(this.prefix);
        this.prefix = null;
        ServerServiceRegistry.getInstance().removeService(DispatcherPrefixService.class);
        ImageMatcher.setPrefixService(null);
        Multiple.setDispatcher(null);
        AJAXRequestDataTools.setBodyParserRegistry(null);
        Dispatchers.setDispatcherPrefixService(null);
        Dispatcher.PREFIX.set("/ajax/");
    }

    public void forgetTracker(ServiceTracker<?, ?> tracker) {
        super.forgetTracker(tracker);
    }

    public void rememberTracker(ServiceTracker<?, ?> tracker) {
        super.rememberTracker(tracker);
    }

    @Override
    protected Class<?>[] getAdditionalNeededServices() {
        return new Class[]{DispatcherPrefixService.class};
    }

    @Override
    public void registerSessionServlet(String alias, HttpServlet servlet, String ... configKeys) {
        super.registerSessionServlet(alias, servlet, configKeys);
    }

    @Override
    public void unregisterServlet(String alias) {
        super.unregisterServlet(alias);
    }
}

