/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewAndCacheTask;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewImageGenerator;
import com.openexchange.ajax.requesthandler.converters.preview.cache.PreviewThumbCacheKeyGenerator;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.preview.PreviewService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewThumbResultConverter
extends AbstractPreviewResultConverter {
    private static final Logger LOG = LoggerFactory.getLogger(PreviewThumbResultConverter.class);
    private static final String BLOCKING_WORKER_NAME = "com.openexchange.preview.thumbnail.blockingWorker";
    private static final long THRESHOLD = 10000L;
    private static final long LENIENT_EXPIRY = 3000L;
    private static final String WIDTH = "width";
    private static final int DEFAULT_THUMB_WIDTH = 160;
    private static final String HEIGHT = "height";
    private static final int DEFAULT_THUMB_HEIGHT = 160;
    private static final DateFormat HEADER_DATEFORMAT = new SimpleDateFormat("EEE',' dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private static final String CACHE_VALUE = "no-store, no-cache, must-revalidate, post-check=0, pre-check=0";
    private static final String PRAGMA_VALUE = "no-cache";
    private final boolean isBlockingWorkerAllowed;

    public PreviewThumbResultConverter(ConfigurationService configService) {
        this.isBlockingWorkerAllowed = configService == null ? false : configService.getBoolProperty(BLOCKING_WORKER_NAME, false);
    }

    @Override
    public String getOutputFormat() {
        return "thumbnail_image";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public PreviewOutput getOutput() {
        return PreviewOutput.IMAGE;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        int contextId = session.getContextId();
        int userId = session.getUserId();
        this.validateRequest(requestData);
        PreviewThumbCacheKeyGenerator cacheKeyGenerator = new PreviewThumbCacheKeyGenerator(result, requestData);
        PreviewService previewService = ServerServiceRegistry.getInstance().getService(PreviewService.class);
        try {
            byte[] thumbnailBytes;
            String fileName;
            InputStream thumbnail;
            PreviewDocument previewDocument;
            ResourceCache resourceCache;
            if (PreviewThumbResultConverter.useCache(requestData) && (resourceCache = PreviewThumbResultConverter.getResourceCache(contextId, userId)) != null) {
                CachedResource cachedPreview = PreviewThumbResultConverter.getCachedResourceForContext(session, cacheKeyGenerator.generateCacheKey(), resourceCache);
                if (cachedPreview == null) {
                    cachedPreview = PreviewThumbResultConverter.getCachedResourceFromPreviewService(session, new AJAXRequestResult(result), requestData.copyOf(), previewService, this.getOutput());
                }
                if (cachedPreview != null) {
                    this.applyCachedPreview(requestData, result, cachedPreview);
                    PreviewThumbResultConverter.preventTransformations(requestData);
                    LOG.debug("Returned preview for file {} with MIME type {} from cache using ETag {} for user {} in context {}", new Object[]{cachedPreview.getFileName(), cachedPreview.getFileType(), result.getHeader("ETag"), session.getUserId(), session.getContextId()});
                } else {
                    PreviewAndCacheTask previewAndCache = new PreviewAndCacheTask(new AJAXRequestResult(result), requestData.copyOf(), session, previewService, 10000L, true, cacheKeyGenerator);
                    ThreadPools.getExecutorService().submit(previewAndCache);
                    this.indicateRequestAccepted(result, requestData);
                }
                return;
            }
            if (this.isBlockingWorkerAllowed) {
                previewDocument = PreviewImageGenerator.getPreviewDocument(result, requestData, session, previewService, 10000L, false);
                if (previewDocument == null) {
                    throw PreviewExceptionCodes.THUMBNAIL_NOT_AVAILABLE.create(new Object[]{"PreviewDocument is null"});
                }
                thumbnail = previewDocument.getThumbnail();
                if (thumbnail == null) {
                    throw PreviewExceptionCodes.THUMBNAIL_NOT_AVAILABLE.create(new Object[]{"PreviewDocument's thumbnail input stream is null"});
                }
                fileName = (String)previewDocument.getMetaData().get("resourcename");
                try {
                    thumbnailBytes = Streams.stream2bytes((InputStream)thumbnail);
                }
                catch (IOException ioex) {
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(ioex, ioex.getMessage());
                }
            } else {
                throw PreviewExceptionCodes.THUMBNAIL_NOT_AVAILABLE.create(new Object[]{"Blocking worker not allowed"});
            }
            FileHolder responseFileHolder = new FileHolder(thumbnail, (long)thumbnailBytes.length, "image/jpeg", fileName);
            result.setResultObject(responseFileHolder, "file");
            PreviewThumbResultConverter.preventTransformations(requestData, previewDocument);
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    protected void applyCachedPreview(AJAXRequestData requestData, AJAXRequestResult result, CachedResource cachedPreview) {
        if (null != cachedPreview) {
            Object responseFileHolder;
            InputStream inputStream;
            requestData.setFormat("file");
            String contentType = cachedPreview.getFileType();
            if (null == contentType) {
                contentType = "image/jpeg";
            }
            if (null == (inputStream = cachedPreview.getInputStream())) {
                ByteArrayFileHolder bafh = new ByteArrayFileHolder(cachedPreview.getBytes());
                bafh.setContentType(contentType);
                bafh.setName(cachedPreview.getFileName());
                responseFileHolder = bafh;
            } else {
                responseFileHolder = new FileHolder(inputStream, cachedPreview.getSize(), contentType, cachedPreview.getFileName());
            }
            result.setResultObject(responseFileHolder, "file");
        }
    }

    protected void validateRequest(AJAXRequestData requestData) {
        if (Strings.isEmpty((String)requestData.getParameter(WIDTH))) {
            requestData.putParameter(WIDTH, String.valueOf(160));
        }
        if (Strings.isEmpty((String)requestData.getParameter(HEIGHT))) {
            requestData.putParameter(HEIGHT, String.valueOf(160));
        }
    }

    protected void indicateRequestAccepted(AJAXRequestResult result, AJAXRequestData requestData) {
        PreviewThumbResultConverter.setMissingThumbnail(requestData, result);
        this.preventCaching(requestData, result);
        PreviewThumbResultConverter.preventTransformations(requestData);
    }

    private void preventCaching(AJAXRequestData requestData, AJAXRequestResult result) {
        requestData.putParameter("keepCachingHeaders", Boolean.toString(Boolean.TRUE));
        result.removeHeader("ETag");
        result.setExpires(3000L);
        result.setHeader("Cache-Control", CACHE_VALUE);
        result.setHeader("Pragma", PRAGMA_VALUE);
    }

    static {
        HEADER_DATEFORMAT.setTimeZone(TimeZoneUtils.getTimeZone("GMT"));
    }
}

