/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.Module;
import com.openexchange.exception.OXException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CombinedActionFactory
implements AJAXActionServiceFactory {
    private static final Object PRESENT = new Object();
    private final ConcurrentMap<AJAXActionServiceFactory, Object> facs = new ConcurrentHashMap<AJAXActionServiceFactory, Object>(2, 0.9f, 1);
    private final ConcurrentMap<String, Object> actions = new ConcurrentHashMap<String, Object>(6, 0.9f, 1);

    public boolean isEmpty() {
        return this.facs.isEmpty();
    }

    public void add(AJAXActionServiceFactory factory) {
        if (null == this.facs.put(factory, PRESENT)) {
            Set<String> actions = CombinedActionFactory.getActionsFrom(factory);
            ConcurrentMap<String, Object> thisActions = this.actions;
            for (String action : actions) {
                if (thisActions.containsKey(action)) {
                    throw new IllegalArgumentException("Conflicting action \"" + action + "\" provided by factory \"" + factory.getClass() + "\".");
                }
                thisActions.put(action, PRESENT);
            }
        }
    }

    private static Set<String> getActionsFrom(AJAXActionServiceFactory factory) {
        Module moduleAnnotation = factory.getClass().getAnnotation(Module.class);
        if (null == moduleAnnotation) {
            throw new IllegalArgumentException("Specified factory has no \"" + Module.class.getName() + "\" annotation: " + factory.getClass());
        }
        return new HashSet<String>(Arrays.asList(moduleAnnotation.actions()));
    }

    public void remove(AJAXActionServiceFactory factory) {
        this.facs.remove(factory);
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        for (AJAXActionServiceFactory factory : this.facs.keySet()) {
            try {
                AJAXActionService service = factory.createActionService(action);
                if (null == service) continue;
                return service;
            }
            catch (OXException e) {
            }
        }
        return null;
    }

    public Collection<?> getSupportedServices() {
        ArrayList supportedServices = new ArrayList();
        for (AJAXActionServiceFactory factory : this.facs.keySet()) {
            supportedServices.addAll(factory.getSupportedServices());
        }
        return supportedServices;
    }
}

