/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXActionAnnotationProcessor;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.exception.OXException;
import com.openexchange.tools.session.ServerSession;
import java.lang.annotation.Annotation;

public abstract class AbstractAJAXActionAnnotationProcessor<T extends Annotation>
implements AJAXActionAnnotationProcessor {
    @Override
    public boolean handles(AJAXActionService action) {
        return action.getClass().isAnnotationPresent(this.getAnnotation());
    }

    @Override
    public void process(AJAXActionService action, AJAXRequestData requestData, ServerSession session) throws OXException {
        T annotation = action.getClass().getAnnotation(this.getAnnotation());
        if (annotation == null) {
            throw new IllegalArgumentException("Action '" + action.getClass().getName() + "' is not annotated with '" + this.getAnnotation().getName() + "'. You must call AJAXActionAnnotationProcessor.handles() first!");
        }
        this.doProcess(annotation, action, requestData, session);
    }

    protected abstract Class<T> getAnnotation();

    protected abstract void doProcess(T var1, AJAXActionService var2, AJAXRequestData var3, ServerSession var4) throws OXException;
}

