/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.actions.GetMultipleAttachmentAction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class GetMultipleAttachmentActionTest {
    @InjectMocks
    private GetMultipleAttachmentAction action;
    @Mock
    private MailMessage message;
    private String subject = "subject";
    private String fileName = this.subject + ".zip";
    private String defaultFileName = "[No Subject].zip";

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.message.getSubject()).thenReturn((Object)this.subject);
    }

    @Test
    public void testGetFileName_localeNull_fileNameNotNull() {
        String ret = this.action.getFileName(null, this.message);
        Assert.assertNotNull((Object)ret);
    }

    @Test
    public void testGetFileName_localeNull_fileNameSet() {
        String ret = this.action.getFileName(null, this.message);
        Assert.assertEquals((Object)this.fileName, (Object)ret);
    }

    @Test
    public void testGetFileName_subjectNull_returnDefault() {
        Mockito.when((Object)this.message.getSubject()).thenReturn(null);
        String ret = this.action.getFileName(null, this.message);
        Assert.assertEquals((Object)this.defaultFileName, (Object)ret);
    }
}

