/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.search.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.search.AndTerm;
import com.openexchange.groupware.infostore.search.ComparablePattern;
import com.openexchange.groupware.infostore.search.ComparisonType;
import com.openexchange.groupware.infostore.search.ContentTerm;
import com.openexchange.groupware.infostore.search.DescriptionTerm;
import com.openexchange.groupware.infostore.search.FileNameTerm;
import com.openexchange.groupware.infostore.search.FileSizeTerm;
import com.openexchange.groupware.infostore.search.OrTerm;
import com.openexchange.groupware.infostore.search.impl.ToMySqlQueryVisitor;
import com.openexchange.groupware.infostore.utils.Metadata;
import java.util.ArrayList;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class ToMySqlQueryVisitorTest
extends TestCase {
    private static final Pattern WRONG_OPERATORS = Pattern.compile("AND[ \t\r\n\f]*OR|AND[ \\t\\r\\n\\f]*AND|OR[ \\t\\r\\n\\f]*OR");
    private static final Pattern MULTIPLE_WHITESPACE = Pattern.compile("[ ]{2,}");
    private final String EXPECTED1 = "SELECT field01 FROM infostore JOIN infostore_document ON infostore_document.cid = infostore.cid AND infostore_document.infostore_id = infostore.id AND infostore_document.version_number = infostore.version WHERE infostore.cid = 1 AND (infostore.folder_id=119 OR (infostore.created_by=1 AND infostore.folder_id=120)) AND UPPER(infostore_document.filename) LIKE UPPER('%test123%') LIMIT 0,5";
    private final String EXPECTED2 = "SELECT field01 FROM infostore JOIN infostore_document ON infostore_document.cid = infostore.cid AND infostore_document.infostore_id = infostore.id AND infostore_document.version_number = infostore.version WHERE infostore.cid = 1 AND (infostore.folder_id=119 OR (infostore.created_by=1 AND infostore.folder_id=120)) AND UPPER(infostore_document.filename) LIKE UPPER('%test123%') ORDER BY last_modified ASC LIMIT 0,5";

    public void testSqlPattern() {
        DescriptionTerm dtz = new DescriptionTerm("*bluber blah?foo*", true, true);
        ToMySqlQueryVisitor visitor = new ToMySqlQueryVisitor(new int[]{119}, null, 1, 1, "SELECT field01");
        visitor.visit(dtz);
        String result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)("Unexpected SQL query: " + result), (boolean)result.endsWith("UPPER(infostore_document.description) LIKE UPPER('%bluber blah_foo%')"));
        dtz = new DescriptionTerm("bluber blah?foo", false, true);
        visitor = new ToMySqlQueryVisitor(new int[]{119}, null, 1, 1, "SELECT field01");
        visitor.visit(dtz);
        result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)("Unexpected SQL query: " + result), (boolean)result.endsWith("infostore_document.description LIKE '%bluber blah_foo%'"));
        dtz = new DescriptionTerm("*bluber %blah?foo*", false, false);
        visitor = new ToMySqlQueryVisitor(new int[]{119}, null, 1, 1, "SELECT field01");
        visitor.visit(dtz);
        result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)("Unexpected SQL query: " + result), (boolean)result.endsWith("infostore_document.description LIKE '%bluber \\%blah_foo%'"));
        dtz = new DescriptionTerm("bluber_blah", false, false);
        visitor = new ToMySqlQueryVisitor(new int[]{119}, null, 1, 1, "SELECT field01");
        visitor.visit(dtz);
        result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)("Unexpected SQL query: " + result), (boolean)result.endsWith("infostore_document.description = 'bluber_blah'"));
        dtz = new DescriptionTerm("bluber_blah", false, true);
        visitor = new ToMySqlQueryVisitor(new int[]{119}, null, 1, 1, "SELECT field01");
        visitor.visit(dtz);
        result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)("Unexpected SQL query: " + result), (boolean)result.endsWith("infostore_document.description LIKE '%bluber\\_blah%'"));
        dtz = new DescriptionTerm("bluber\\blah", false, false);
        visitor = new ToMySqlQueryVisitor(new int[]{119}, null, 1, 1, "SELECT field01");
        visitor.visit(dtz);
        result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)("Unexpected SQL query: " + result), (boolean)result.endsWith("infostore_document.description = 'bluber\\\\blah'"));
    }

    public void testFolders() {
        DescriptionTerm dtz = new DescriptionTerm("*bluber blah?foo*", false, false);
        ToMySqlQueryVisitor visitor = new ToMySqlQueryVisitor(new int[]{119}, new int[]{120}, 1, 1, "SELECT field01");
        visitor.visit(dtz);
        String result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)"Unexpected SQL query", (boolean)result.endsWith("AND (infostore.folder_id=119 OR (infostore.created_by=1 AND infostore.folder_id=120)) AND infostore_document.description LIKE '%bluber blah_foo%'"));
    }

    public void testWithoutAllFolders() {
        DescriptionTerm dtz = new DescriptionTerm("*bluber blah?foo*", false, false);
        ToMySqlQueryVisitor visitor = new ToMySqlQueryVisitor(null, new int[]{120}, 1, 1, "SELECT field01");
        visitor.visit(dtz);
        String result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Invalid SQL query", (boolean)WRONG_OPERATORS.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)"Unexpected SQL query", (boolean)result.endsWith("AND ((infostore.created_by=1 AND infostore.folder_id=120)) AND infostore_document.description LIKE '%bluber blah_foo%'"));
        visitor = new ToMySqlQueryVisitor(new int[0], new int[]{120}, 1, 1, "SELECT field01");
        visitor.visit(dtz);
        result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Invalid SQL query", (boolean)WRONG_OPERATORS.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)"Unexpected SQL query", (boolean)result.endsWith("AND ((infostore.created_by=1 AND infostore.folder_id=120)) AND infostore_document.description LIKE '%bluber blah_foo%'"));
    }

    public void testWithoutOwnFolders() {
        DescriptionTerm dtz = new DescriptionTerm("*bluber blah?foo*", false, false);
        ToMySqlQueryVisitor visitor = new ToMySqlQueryVisitor(new int[]{119}, null, 1, 1, "SELECT field01");
        visitor.visit(dtz);
        String result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Invalid SQL query", (boolean)WRONG_OPERATORS.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)"Unexpected SQL query", (boolean)result.endsWith("AND (infostore.folder_id=119) AND infostore_document.description LIKE '%bluber blah_foo%'"));
        visitor = new ToMySqlQueryVisitor(new int[]{119}, new int[0], 1, 1, "SELECT field01");
        visitor.visit(dtz);
        result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Invalid SQL query", (boolean)WRONG_OPERATORS.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)"Unexpected SQL query", (boolean)result.endsWith("AND (infostore.folder_id=119) AND infostore_document.description LIKE '%bluber blah_foo%'"));
    }

    public void testWithLimit() {
        FileNameTerm term = new FileNameTerm("test123");
        ToMySqlQueryVisitor visitor = new ToMySqlQueryVisitor(new int[]{119}, new int[]{120}, 1, 1, "SELECT field01", null, -11, 0, 5);
        visitor.visit(term);
        String result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Invalid SQL query", (boolean)WRONG_OPERATORS.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)"Unexpected SQL query", (boolean)result.equals("SELECT field01 FROM infostore JOIN infostore_document ON infostore_document.cid = infostore.cid AND infostore_document.infostore_id = infostore.id AND infostore_document.version_number = infostore.version WHERE infostore.cid = 1 AND (infostore.folder_id=119 OR (infostore.created_by=1 AND infostore.folder_id=120)) AND UPPER(infostore_document.filename) LIKE UPPER('%test123%') LIMIT 0,5"));
    }

    public void testWithLimitAndOrder() {
        FileNameTerm term = new FileNameTerm("test123");
        ToMySqlQueryVisitor visitor = new ToMySqlQueryVisitor(new int[]{119}, new int[]{120}, 1, 1, "SELECT field01", Metadata.LAST_MODIFIED_LITERAL, 1, 0, 5);
        visitor.visit(term);
        String result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Invalid SQL query", (boolean)WRONG_OPERATORS.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertTrue((String)"Unexpected SQL query", (boolean)result.equals("SELECT field01 FROM infostore JOIN infostore_document ON infostore_document.cid = infostore.cid AND infostore_document.infostore_id = infostore.id AND infostore_document.version_number = infostore.version WHERE infostore.cid = 1 AND (infostore.folder_id=119 OR (infostore.created_by=1 AND infostore.folder_id=120)) AND UPPER(infostore_document.filename) LIKE UPPER('%test123%') ORDER BY last_modified ASC LIMIT 0,5"));
    }

    public void testUnsupportedTerms() throws OXException {
        ContentTerm term1 = new ContentTerm("test123", false, false);
        FileSizeTerm term2 = new FileSizeTerm((ComparablePattern)new ComparablePattern<Number>(){

            public Number getPattern() {
                return 0xA00000;
            }

            public ComparisonType getComparisonType() {
                return ComparisonType.GREATER_THAN;
            }
        });
        ArrayList<Object> terms = new ArrayList<Object>(2);
        terms.add(term1);
        terms.add(term2);
        OrTerm orTerm = new OrTerm(terms);
        AndTerm andTerm = new AndTerm(terms);
        ToMySqlQueryVisitor visitor = new ToMySqlQueryVisitor(new int[]{119}, new int[]{120}, 1, 1, "SELECT field01", Metadata.LAST_MODIFIED_LITERAL, 1, 0, 5);
        visitor.visit(andTerm);
        String result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Invalid SQL query", (boolean)WRONG_OPERATORS.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
        visitor = new ToMySqlQueryVisitor(new int[]{119}, new int[]{120}, 1, 1, "SELECT field01", Metadata.LAST_MODIFIED_LITERAL, 1, 0, 5);
        visitor.visit(orTerm);
        result = visitor.getMySqlQuery();
        ToMySqlQueryVisitorTest.assertFalse((String)"Invalid SQL query", (boolean)WRONG_OPERATORS.matcher(result).matches());
        ToMySqlQueryVisitorTest.assertFalse((String)"Unneccessary whitespaces in query", (boolean)MULTIPLE_WHITESPACE.matcher(result).matches());
    }
}

