/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.ajax.helper.ImageUtils;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.ajax.requesthandler.responseRenderers.FileResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.ImageComparingTools;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.SimConfigurationService;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.filemanagement.internal.ManagedFileManagementImpl;
import com.openexchange.html.HtmlService;
import com.openexchange.html.SimHtmlService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.images.ImageTransformationService;
import com.openexchange.tools.images.impl.JavaImageTransformationService;
import com.openexchange.tools.images.osgi.Services;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.SimServerSession;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.sim.SimHttpServletRequest;
import javax.servlet.http.sim.SimHttpServletResponse;
import javax.servlet.sim.ByteArrayServletOutputStream;
import junit.framework.TestCase;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Services.class})
@PowerMockIgnore(value={"javax.imageio.*"})
public class ImageComparingTest
extends TestCase {
    @Mock
    private SimConfigurationService simConfigurationService;
    @Mock
    private TimerService timerService;
    @Mock
    private ManagedFileManagement simManagedFileManagement;
    private final String TEST_DATA_DIR = "testconf/";

    protected void setUp() throws Exception {
        super.setUp();
        MockitoAnnotations.initMocks((Object)((Object)this));
        PowerMockito.mockStatic(Services.class, (Class[])new Class[0]);
        ServerServiceRegistry.getInstance().addService(HtmlService.class, (Object)new SimHtmlService());
        SimConfigurationService simConfigurationService = new SimConfigurationService();
        simConfigurationService.stringProperties.put("UPLOAD_DIRECTORY", "/tmp/");
        ServerServiceRegistry.getInstance().addService(ConfigurationService.class, (Object)simConfigurationService);
        this.simManagedFileManagement = new ManagedFileManagementImpl((ConfigurationService)simConfigurationService, this.timerService, (DispatcherPrefixService)new DefaultDispatcherPrefixService("/ajax/"));
        ServerServiceRegistry.getInstance().addService(ManagedFileManagement.class, (Object)this.simManagedFileManagement);
        PowerMockito.when((Object)Services.getService(TimerService.class)).thenReturn((Object)this.timerService);
    }

    protected void tearDown() throws Exception {
        ServerServiceRegistry.getInstance().removeService(HtmlService.class);
        super.tearDown();
    }

    public void testRotationSuccess_Bug26630() {
        try {
            File fileInput = new File("testconf/", "Rotate_90CW.jpg");
            FileHolder fileHolder = new FileHolder(fileInput);
            fileHolder.setContentType("image/jpg");
            fileHolder.setName(fileInput.getName());
            fileHolder.setDelivery("view");
            fileHolder.setDisposition("inline");
            AJAXRequestData requestData = new AJAXRequestData();
            requestData.setSession((ServerSession)new SimServerSession(1, 1));
            requestData.putParameter("cache", "false");
            requestData.setAction("attachment");
            requestData.putParameter("delivery", "view");
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            SimHttpServletRequest req = new SimHttpServletRequest();
            SimHttpServletResponse resp = new SimHttpServletResponse();
            requestData.setHttpServletResponse((HttpServletResponse)resp);
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            fileResponseRenderer.setScaler((ImageTransformationService)new JavaImageTransformationService());
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            byte[] bytesCurrent = servletOutputStream.toByteArray();
            ByteArrayInputStream inOutput = new ByteArrayInputStream(bytesCurrent);
            BufferedImage outputImage = ImageIO.read(inOutput);
            boolean transformed = false;
            float averageAreaTop = 0.0f;
            float averageAreaBottom = 0.0f;
            for (int i = 0; i < outputImage.getHeight(); ++i) {
                int red = new Color(outputImage.getRGB(50, i)).getRed();
                int green = new Color(outputImage.getRGB(50, i)).getGreen();
                int blue = new Color(outputImage.getRGB(50, i)).getBlue();
                if (i < 50) {
                    averageAreaTop += (float)(red + green + blue) / 3.0f;
                    continue;
                }
                averageAreaBottom += (float)(red + green + blue) / 3.0f;
            }
            averageAreaBottom /= 50.0f;
            if ((averageAreaTop /= 50.0f) < 1.0f && averageAreaBottom > 253.0f) {
                transformed = true;
            }
            ImageComparingTest.assertTrue((String)"Rotation of image not succesfull", (boolean)transformed);
        }
        catch (Exception e) {
            e.printStackTrace();
            ImageComparingTest.fail((String)e.getMessage());
        }
    }

    public void testAlphaChannelShouldNotGetTransformed_Bug28163() {
        try {
            File fileInput = new File("testconf/", "28163.jpg");
            FileHolder fileHolder = new FileHolder(fileInput);
            fileHolder.setContentType("image/jpg");
            fileHolder.setName(fileInput.getName());
            fileHolder.setDelivery("view");
            fileHolder.setDisposition("inline");
            AJAXRequestData requestData = new AJAXRequestData();
            requestData.setSession((ServerSession)new SimServerSession(1, 1));
            requestData.putParameter("cache", "false");
            requestData.putParameter("delivery", "view");
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            SimHttpServletRequest req = new SimHttpServletRequest();
            SimHttpServletResponse resp = new SimHttpServletResponse();
            requestData.setHttpServletResponse((HttpServletResponse)resp);
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            fileResponseRenderer.setScaler((ImageTransformationService)new JavaImageTransformationService());
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            byte[] bytesCurrent = servletOutputStream.toByteArray();
            FileInputStream inOriginal = new FileInputStream(fileInput);
            BufferedImage originalImage = ImageIO.read(inOriginal);
            ByteArrayInputStream inAfter = new ByteArrayInputStream(bytesCurrent);
            BufferedImage currentImage = ImageIO.read(inAfter);
            float expectedHistogramValue = ImageComparingTools.meanHistogramRGBValue(originalImage);
            float currentHistogramValue = ImageComparingTools.meanHistogramRGBValue(currentImage);
            this.assertValueInRange(currentHistogramValue, expectedHistogramValue - 0.5f, expectedHistogramValue + 0.5f);
        }
        catch (Exception e) {
            e.printStackTrace();
            ImageComparingTest.fail((String)e.getMessage());
        }
    }

    public void testGIFPictureIsAnimated_Bug29072() {
        try {
            File fileInput = new File("testconf/", "29072.gif");
            FileHolder fileHolder = new FileHolder(fileInput);
            fileHolder.setContentType("image/gif");
            fileHolder.setName(fileInput.getName());
            fileHolder.setDelivery("view");
            fileHolder.setDisposition("inline");
            AJAXRequestData requestData = new AJAXRequestData();
            requestData.setSession((ServerSession)new SimServerSession(1, 1));
            requestData.putParameter("cache", "false");
            requestData.putParameter("delivery", "view");
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            SimHttpServletRequest req = new SimHttpServletRequest();
            SimHttpServletResponse resp = new SimHttpServletResponse();
            requestData.setHttpServletResponse((HttpServletResponse)resp);
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            fileResponseRenderer.setScaler((ImageTransformationService)new JavaImageTransformationService());
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            byte[] bytesCurrent = servletOutputStream.toByteArray();
            ByteArrayInputStream inAfter = new ByteArrayInputStream(bytesCurrent);
            ImageComparingTest.assertTrue((String)"Animated GIF image not animated anymore", (boolean)ImageUtils.isAnimatedGif((InputStream)inAfter));
        }
        catch (Exception e) {
            e.printStackTrace();
            ImageComparingTest.fail((String)e.getMessage());
        }
    }

    public void testReadImageWithCMYKProfile_Bug28082() throws IOException {
        File file = new File("testconf/", "28082.jpg");
        FileHolder fileHolder = new FileHolder(file);
        fileHolder.setContentType("image/jpg");
        fileHolder.setDelivery("view");
        fileHolder.setDisposition("inline");
        fileHolder.setName(file.getName());
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        requestData.putParameter("cache", "false");
        requestData.putParameter("delivery", "view");
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        requestData.setHttpServletResponse((HttpServletResponse)resp);
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        fileResponseRenderer.setScaler((ImageTransformationService)new JavaImageTransformationService());
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        ImageComparingTest.assertNull((String)("Got exception: " + resp.getStatusMessage()), (Object)resp.getStatusMessage());
    }

    private void assertValueInRange(float value, float rangeMin, float rangeMax) {
        boolean inRange = rangeMin <= value && value <= rangeMax;
        ImageComparingTest.assertTrue((String)("Range differs too much. Expect values between: " + rangeMin + " and " + rangeMax + "--> Got: " + value), (boolean)inRange);
    }
}

