/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.ajax.parser.TaskParser;
import com.openexchange.ajax.writer.TaskWriter;
import com.openexchange.groupware.tasks.Task;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.json.JSONObject;

public class TaskLastModifiedTest
extends TestCase {
    public TaskLastModifiedTest(String name) {
        super(name);
    }

    public void testNotParsing() throws Throwable {
        TimeZone UTC = TimeZone.getTimeZone("UTC");
        Task task = new Task();
        task.setLastModified(new Date());
        JSONObject json = new JSONObject();
        new TaskWriter(UTC).writeTask(task, json);
        Task parsed = new Task();
        new TaskParser(UTC).parse(parsed, json, Locale.ENGLISH);
        TaskLastModifiedTest.assertFalse((String)"lastModified has been set but should not.", (boolean)parsed.containsLastModified());
        TaskLastModifiedTest.assertNull((String)"lastModified is not null but should.", (Object)parsed.getLastModified());
    }

    public void testParsing() throws Throwable {
        TimeZone UTC = TimeZone.getTimeZone("UTC");
        Task task = new Task();
        task.setLastModified(new Date());
        JSONObject json = new JSONObject();
        new TaskWriter(UTC).writeTask(task, json);
        Task parsed = new Task();
        new TaskParser(true, UTC).parse(parsed, json, Locale.ENGLISH);
        TaskLastModifiedTest.assertTrue((String)"lastModified has not been set but should.", (boolean)parsed.containsLastModified());
        TaskLastModifiedTest.assertNotNull((String)"lastModified is null but should not.", (Object)parsed.getLastModified());
    }
}

