/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import java.util.Collection;
import java.util.Stack;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class Tools {
    public static final Filter generateServiceFilter(BundleContext context, Class<?> ... classes) throws InvalidSyntaxException {
        if (classes.length < 2) {
            throw new IllegalArgumentException("At least the classes of 2 services must be given.");
        }
        StringBuilder sb = new StringBuilder("(|(");
        for (Class<?> clazz : classes) {
            sb.append("objectClass");
            sb.append('=');
            sb.append(clazz.getName());
            sb.append(")(");
        }
        sb.setCharAt(sb.length() - 1, ')');
        return context.createFilter(sb.toString());
    }

    public static final void open(Collection<ServiceTracker<?, ?>> trackers) {
        for (ServiceTracker<?, ?> tracker : trackers) {
            tracker.open();
        }
    }

    public static final void close(Stack<ServiceTracker<?, ?>> trackers) {
        while (!trackers.isEmpty()) {
            trackers.pop().close();
        }
    }

    public static <T> T requireService(Class<T> serviceClass, ServiceLookup serviceLookup) throws OXException {
        Object service = serviceLookup.getService(serviceClass);
        if (service == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{serviceClass.getName()});
        }
        return (T)service;
    }

    private Tools() {
    }
}

