/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HigherRankedObservator<S>
implements ServiceTrackerCustomizer<S, S> {
    private final AtomicInteger higherRankedCounter;
    private final List<HigherRankedObservatorCallback<S>> callbacks = new CopyOnWriteArrayList<HigherRankedObservatorCallback<S>>();
    private final int myRanking;
    private final BundleContext context;

    public HigherRankedObservator(int ranking, BundleContext context) {
        this.context = context;
        this.higherRankedCounter = new AtomicInteger(0);
        this.myRanking = ranking;
    }

    public HigherRankedObservator<S> addCallback(HigherRankedObservatorCallback<S> callback) {
        if (null != callback) {
            this.callbacks.add(callback);
        }
        return this;
    }

    public HigherRankedObservator<S> removeCallback(HigherRankedObservatorCallback<S> callback) {
        if (null != callback) {
            this.callbacks.remove(callback);
        }
        return this;
    }

    public S addingService(ServiceReference<S> reference) {
        if (this.getRanking(reference) > this.myRanking && 1 == this.higherRankedCounter.incrementAndGet()) {
            Object service = this.context.getService(reference);
            for (HigherRankedObservatorCallback<Object> higherRankedObservatorCallback : this.callbacks) {
                higherRankedObservatorCallback.onFirstHigherRankedAvailable(reference, service);
            }
            return (S)service;
        }
        return null;
    }

    public void modifiedService(ServiceReference<S> reference, S service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<S> reference, S service) {
        if (null == service) {
            return;
        }
        if (this.getRanking(reference) > this.myRanking && 0 == this.higherRankedCounter.decrementAndGet()) {
            try {
                for (HigherRankedObservatorCallback<S> callback : this.callbacks) {
                    callback.onLastHigherRankedDisappeared(reference, service);
                }
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }

    private int getRanking(ServiceReference<S> reference) {
        Object property = reference.getProperty("service.ranking");
        if (null == property) {
            return 0;
        }
        return (Integer)property;
    }

    public static interface HigherRankedObservatorCallback<S> {
        public void onFirstHigherRankedAvailable(ServiceReference<S> var1, S var2);

        public void onLastHigherRankedDisappeared(ServiceReference<S> var1, S var2);
    }
}

