/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.session.inspector.internal;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceSet<E>
implements NavigableSet<E>,
ServiceTrackerCustomizer<E, E> {
    private final BundleContext context;
    private final ConcurrentHashMap<E, Integer> serviceRankings;
    private final ConcurrentHashMap<E, Long> serviceIds;
    private final ConcurrentSkipListSet<E> entries;
    private volatile boolean empty;

    public ServiceSet(BundleContext context) {
        this.context = context;
        final ConcurrentHashMap serviceRankings = new ConcurrentHashMap();
        this.serviceRankings = serviceRankings;
        final ConcurrentHashMap serviceIds = new ConcurrentHashMap();
        this.serviceIds = serviceIds;
        this.empty = true;
        this.entries = new ConcurrentSkipListSet(new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                int result = this.getRanking(o1) - this.getRanking(o2);
                return 0 == result ? (int)(this.getServiceId(o1) - this.getServiceId(o2)) : result;
            }

            private int getRanking(E e) {
                Integer i = (Integer)serviceRankings.get(e);
                return null == i ? 0 : i;
            }

            private long getServiceId(E e) {
                Long l = (Long)serviceIds.get(e);
                return null == l ? 0L : l;
            }
        });
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.entries.comparator();
    }

    @Override
    public E first() {
        return this.entries.first();
    }

    @Override
    public E last() {
        return this.entries.last();
    }

    @Override
    public boolean add(E service) {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public boolean contains(Object o) {
        return this.entries.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.entries.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.entries.toArray(a);
    }

    public E addingService(ServiceReference<E> reference) {
        Object service = this.context.getService(reference);
        Integer ranking = (Integer)reference.getProperty("service.ranking");
        if (ranking != null) {
            this.serviceRankings.put(service, ranking);
        }
        Long id = (Long)reference.getProperty("service.id");
        this.serviceIds.put(service, id);
        this.entries.add(service);
        this.empty = false;
        return (E)service;
    }

    public void modifiedService(ServiceReference<E> reference, E service) {
    }

    public void removedService(ServiceReference<E> reference, E service) {
        this.empty = this.entries.isEmpty();
        this.entries.remove(service);
        this.serviceRankings.remove(service);
        this.serviceIds.remove(service);
        this.context.ungetService(reference);
    }

    @Override
    public E ceiling(E service) {
        return this.entries.ceiling(service);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.entries.descendingIterator();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return this.entries.descendingSet();
    }

    @Override
    public E floor(E service) {
        return this.entries.floor(service);
    }

    @Override
    public SortedSet<E> headSet(E service) {
        return this.entries.headSet((Object)service);
    }

    @Override
    public NavigableSet<E> headSet(E service, boolean inclusive) {
        return this.entries.headSet(service, inclusive);
    }

    @Override
    public E higher(E service) {
        return this.entries.higher(service);
    }

    @Override
    public Iterator<E> iterator() {
        return this.entries.iterator();
    }

    @Override
    public E lower(E service) {
        return this.entries.lower(service);
    }

    @Override
    public E pollFirst() {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public E pollLast() {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.entries.subSet((Object)fromElement, (Object)toElement);
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.entries.subSet(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public SortedSet<E> tailSet(E service) {
        return this.entries.tailSet((Object)service);
    }

    @Override
    public NavigableSet<E> tailSet(E service, boolean inclusive) {
        return this.entries.tailSet(service, inclusive);
    }
}

