/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.authentication;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum LoginExceptionCodes implements DisplayableOXExceptionCode
{
    ACCOUNT_LOCKED("Account \"%s\" is locked.", "The account \"%s\" is locked.", Category.CATEGORY_PERMISSION_DENIED, 1),
    ACCOUNT_NOT_READY_YET("Account \"%1$s\" is currently being created.", "Account \"%1$s\" is currently being created. This can take a while. Please try again later.", Category.CATEGORY_TRY_AGAIN, 2),
    UNKNOWN("Unknown problem: \"%s\".", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 3),
    COMMUNICATION("Login not possible at the moment.", "Login not possible at the moment. Please try again later.", Category.CATEGORY_SERVICE_DOWN, 5),
    INVALID_CREDENTIALS("Invalid credentials.", "The user name or password is incorrect.", Category.CATEGORY_USER_INPUT, 6),
    INVALID_CREDENTIALS_MISSING_USER_MAPPING("Missing user mapping for user \"%1$s\". Login failed.", "The user name or password is incorrect.", Category.CATEGORY_USER_INPUT, 6),
    INVALID_CREDENTIALS_MISSING_CONTEXT_MAPPING("Missing context mapping for context \"%1$s\". Login failed.", "The user name or password is incorrect.", Category.CATEGORY_USER_INPUT, 6),
    MISSING_PROPERTY("Missing property %1$s.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_CONFIGURATION, 9),
    DATABASE_DOWN("Database down.", "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later.", Category.CATEGORY_SERVICE_DOWN, 10),
    PASSWORD_EXPIRED("Your password has expired. In order to change it, please log in to %1$s.", "Your password has expired. In order to change it, please log in to %1$s.", Category.CATEGORY_PERMISSION_DENIED, 11),
    USER_NOT_ACTIVE("User is not activated.", "The user account is not activated.", Category.CATEGORY_PERMISSION_DENIED, 13),
    CLIENT_DENIED("Client \"%1$s\" is not activated.", "You do not have the appropriate permissions to login with client \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 14),
    UNKNOWN_HTTP_AUTHORIZATION("Method \"%1$s\" in HTTP header authorization is not supported.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 15),
    REDIRECT("%1$s", "%1$s", Category.CATEGORY_USER_INPUT, 16),
    NOT_SUPPORTED("%s does not support an auto login authentication.", "Automatic login is not supported.", Category.CATEGORY_SERVICE_DOWN, 19),
    SERVER_TOKEN_NOT_CREATED("Server side token for token login was not created.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 20),
    DONT_USER_AGENT("Value of User-Agent header must not be used as value for the client parameter. Please use a string identifying the client software.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_USER_INPUT, 21),
    LOGINS_WITHOUT_PASSWORD_EXCEEDED("You exceeded the maximum count of logins without password.", "You exceeded the maximum count of logins without password.", Category.CATEGORY_USER_INPUT, 22),
    NEW_PASSWORD_REQUIRED("A password is required to continue. Please choose one and try again.", "A password is required to continue. Please choose one and try again.", Category.CATEGORY_USER_INPUT, 23),
    AUTHENTICATION_DISABLED("Authentication via this method is disabled.", "Authentication via this method is disabled.", Category.CATEGORY_PERMISSION_DENIED, 24),
    INVALID_GUEST_PASSWORD("Invalid credentials.", "The password is incorrect.", Category.CATEGORY_USER_INPUT, 25);

    private final String message;
    private final String displayMessage;
    private final Category category;
    private final int number;

    private LoginExceptionCodes(String message, String displayMessage, Category category, int detailNumber) {
        this.message = message;
        this.displayMessage = displayMessage;
        this.category = category;
        this.number = detailNumber;
    }

    @Override
    public String getPrefix() {
        return "LGI";
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getDisplayMessage() {
        return this.displayMessage;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals(this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

