/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.search;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.search.SearchTerm;
import com.openexchange.file.storage.search.SearchTermVisitor;
import com.openexchange.java.Strings;
import java.util.Collection;
import java.util.Map;

public final class MetaTerm
implements SearchTerm<String> {
    private final String pattern;

    public MetaTerm(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void visit(SearchTermVisitor visitor) throws OXException {
        if (null != visitor) {
            visitor.visit(this);
        }
    }

    @Override
    public void addField(Collection<File.Field> col) {
        if (null != col) {
            col.add(File.Field.META);
        }
    }

    @Override
    public boolean matches(File file) throws OXException {
        if (Strings.isEmpty((String)this.pattern)) {
            return false;
        }
        Map<String, Object> meta = file.getMeta();
        if (null == meta || meta.isEmpty()) {
            return false;
        }
        return this.lookUpMap(Strings.toLowerCase((CharSequence)this.pattern), meta);
    }

    private boolean lookUpMap(String lookUp, Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (Strings.toLowerCase((CharSequence)key).indexOf(lookUp) >= 0) {
                return true;
            }
            if (!this.lookUpObject(lookUp, entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean lookUpCollection(String lookUp, Collection<Object> col) {
        if (null == col || col.isEmpty()) {
            return false;
        }
        for (Object object : col) {
            if (!this.lookUpObject(lookUp, object)) continue;
            return true;
        }
        return false;
    }

    private boolean lookUpObject(String lookUp, Object value) {
        if (value instanceof Map) {
            return this.lookUpMap(lookUp, (Map)value);
        }
        if (value instanceof Collection) {
            return this.lookUpCollection(lookUp, (Collection)value);
        }
        return Strings.toLowerCase((CharSequence)value.toString()).indexOf(lookUp) >= 0;
    }
}

