/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.search;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.search.SearchTerm;
import com.openexchange.file.storage.search.SearchTermVisitor;
import java.util.Collection;

public final class CurrentVersionTerm
implements SearchTerm<Boolean> {
    private final boolean currentVersion;

    public CurrentVersionTerm(boolean currentVersion) {
        this.currentVersion = currentVersion;
    }

    @Override
    public Boolean getPattern() {
        return this.currentVersion;
    }

    @Override
    public void visit(SearchTermVisitor visitor) throws OXException {
        if (null != visitor) {
            visitor.visit(this);
        }
    }

    @Override
    public void addField(Collection<File.Field> col) {
        if (null != col) {
            col.add(File.Field.CURRENT_VERSION);
        }
    }

    @Override
    public boolean matches(File file) throws OXException {
        return this.currentVersion ? FileStorageFileAccess.CURRENT_VERSION == file.getVersion() : FileStorageFileAccess.CURRENT_VERSION != file.getVersion();
    }
}

