/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.osgi.Services;
import com.openexchange.java.Strings;
import com.openexchange.secret.SecretExceptionCodes;
import com.openexchange.secret.SecretService;
import com.openexchange.session.Session;
import java.util.Collections;
import java.util.List;

public class SecretAwareFileStorageAccountManager
implements FileStorageAccountManager {
    private final FileStorageAccountManager manager;

    public static SecretAwareFileStorageAccountManager newInstanceFor(FileStorageAccountManager manager) {
        return null == manager ? null : new SecretAwareFileStorageAccountManager(manager);
    }

    private SecretAwareFileStorageAccountManager(FileStorageAccountManager manager) {
        this.manager = manager;
    }

    @Override
    public String addAccount(FileStorageAccount account, Session session) throws OXException {
        return this.manager.addAccount(account, session);
    }

    @Override
    public void updateAccount(FileStorageAccount account, Session session) throws OXException {
        this.manager.updateAccount(account, session);
    }

    @Override
    public void deleteAccount(FileStorageAccount account, Session session) throws OXException {
        this.manager.deleteAccount(account, session);
    }

    @Override
    public List<FileStorageAccount> getAccounts(Session session) throws OXException {
        SecretService secretService = Services.getOptionalService(SecretService.class);
        if (null != secretService && Strings.isEmpty((String)secretService.getSecret(session))) {
            return Collections.emptyList();
        }
        try {
            return this.manager.getAccounts(session);
        }
        catch (OXException e) {
            if (!SecretExceptionCodes.EMPTY_SECRET.equals(e)) {
                throw e;
            }
            return Collections.emptyList();
        }
    }

    @Override
    public FileStorageAccount getAccount(String id, Session session) throws OXException {
        return this.manager.getAccount(id, session);
    }

    @Override
    public void cleanUp(String secret, Session session) throws OXException {
        this.manager.cleanUp(secret, session);
    }

    @Override
    public void removeUnrecoverableItems(String secret, Session session) throws OXException {
        this.manager.removeUnrecoverableItems(secret, session);
    }

    @Override
    public void migrateToNewSecret(String oldSecret, String newSecret, Session session) throws OXException {
        this.manager.migrateToNewSecret(oldSecret, newSecret, session);
    }

    @Override
    public boolean hasEncryptedItems(Session session) throws OXException {
        return this.manager.hasEncryptedItems(session);
    }
}

