/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum FileStorageExceptionCodes implements DisplayableOXExceptionCode
{
    UNEXPECTED_ERROR("An error occurred: %1$s", Category.CATEGORY_ERROR, 1),
    SQL_ERROR("A SQL error occurred: %1$s", Category.CATEGORY_ERROR, 2, "Error while reading/writing data from/to the database."),
    IO_ERROR("An I/O error occurred: %1$s", Category.CATEGORY_ERROR, 3),
    PROTOCOL_ERROR("%1$s protocol error occurred: %2$s", Category.CATEGORY_ERROR, 5),
    JSON_ERROR("A JSON error occurred: %1$s", Category.CATEGORY_ERROR, 14),
    ACCOUNT_NOT_FOUND("File storage account %1$s of service \"%2$s\" could not be found for user %3$s in context %4$s.", Category.CATEGORY_USER_INPUT, 4, "The associated %2$s account does no more exist"),
    OPERATION_NOT_SUPPORTED("The operation is not supported by service %1$s.", Category.CATEGORY_ERROR, 6),
    FOLDER_NOT_FOUND("The folder \"%1$s\" cannot be found in account %2$s of service \"%3$s\" of user %4$s in context %5$s.", Category.CATEGORY_ERROR, 7, "The folder you requested does not exist."),
    INVALID_FILE_IDENTIFIER("Invalid file identifier: %1$s", Category.CATEGORY_ERROR, 8, "The file you requested does not exist."),
    INVALID_HEADER("Invalid header \"%1$s\": %2$s", Category.CATEGORY_ERROR, 9),
    UNKNOWN_ACTION("Unknown action to perform: %1$s.", Category.CATEGORY_ERROR, 10),
    FILE_ERROR("A file error occurred: %1$s", Category.CATEGORY_ERROR, 11),
    ADDRESS_ERROR("Wrongly formatted address: %1$s.", Category.CATEGORY_ERROR, 12),
    UNKNOWN_FILE_CONTENT("Unknown file content: %1$s.", Category.CATEGORY_ERROR, 15),
    UNKNOWN_FILE_STORAGE_SERVICE("Unknown file storage service: %1$s.", Category.CATEGORY_SERVICE_DOWN, 16),
    MISSING_PARAMETER("Missing parameter: %1$s.", Category.CATEGORY_USER_INPUT, 17),
    INVALID_PARAMETER("Invalid parameter: %1$s with type '%2$s'. Expected '%3$s'.", Category.CATEGORY_USER_INPUT, 18),
    READ_ONLY("File part is read-only: %1$s", Category.CATEGORY_USER_INPUT, 19),
    UNKNOWN_COLOR_LABEL("Unknown color label index: %1$s", Category.CATEGORY_USER_INPUT, 20),
    DUPLICATE_FOLDER("A duplicate folder named \"%1$s\" already exists below parent folder \"%2$s\".", Category.CATEGORY_ERROR, 21, "A folder named \"%1$s\" already exists below the parent folder \"%2$s\"."),
    NO_CREATE_ACCESS("No create access on folder %1$s.", Category.CATEGORY_PERMISSION_DENIED, 22, "You do not have the appropriate permissions to create a subfolder below the folder \"%1$s\"."),
    NOT_CONNECTED("Not connected", Category.CATEGORY_PERMISSION_DENIED, 23),
    INVALID_SORTING_COLUMN("Invalid sorting column. Cannot sort by %1$s.", Category.CATEGORY_USER_INPUT, 24),
    ATTACHMENT_NOT_FOUND("No attachment found with section identifier %1$s in file %2$s in folder %3$s.", Category.CATEGORY_USER_INPUT, 25, "The file you requested does not exist."),
    FILE_NOT_FOUND("File %1$s not found in folder %2$s.", Category.CATEGORY_USER_INPUT, 26, "The file you requested does not exist."),
    NO_ACCOUNT_MANAGER_FOR_SERVICE("No account manager could be found for service: %1$s.", Category.CATEGORY_ERROR, 27),
    INVALID_URL("Invalid URL \"%1$s\". Error: %2$s.", Category.CATEGORY_USER_INPUT, 28, "Invalid URL \"%1$s\". Please correct the value and try again."),
    NO_SUCH_FOLDER("No such folder.", Category.CATEGORY_USER_INPUT, 29, "The folder you requested does not exist."),
    LOGIN_FAILED("Authentication failed for login %1$s to server %2$s (service: %3$s).", Category.CATEGORY_CONFIGURATION, 30),
    PATTERN_NEEDS_MORE_CHARACTERS("In order to accomplish the search, %1$d or more characters are required.", CATEGORY_USER_INPUT, 602, "In order to accomplish the search, %1$d or more characters are required."),
    INVALID_FOLDER_IDENTIFIER("Invalid folder identifier: %1$s", Category.CATEGORY_ERROR, 31, "The folder you requested does not exist."),
    QUOTA_REACHED("The allowed Quota is reached", Category.CATEGORY_CAPACITY, 32, "The allowed quota is reached. Please delete some items in order to store new ones."),
    SEARCH_TERM_NOT_SUPPORTED("Search term no supported: %1$s.", Category.CATEGORY_ERROR, 33),
    ARCHIVE_MAX_SIZE_EXCEEDED(" ZIP archive exceeds max. allowed size of %1$s", Category.CATEGORY_PERMISSION_DENIED, 34, "ZIP archive exceeds max. allowed size of %1$s"),
    ACCOUNT_NOT_ACCESSIBLE("File storage account %1$s of service \"%2$s\" cannot be accessed for user %3$s in context %4$s.", Category.CATEGORY_ERROR, 35, "The file storage account is currently not accessible."),
    FOLDER_MOVE_NOT_SUPPORTED("The folder \"%1$s\" cannot be moved to \"%2$s\".", Category.CATEGORY_USER_INPUT, 36, "The folder \"%1$s\" cannot be moved to \"%2$s\"."),
    FILE_MOVE_NOT_SUPPORTED("The file \"%1$s\" cannot be moved to \"%2$s\".", Category.CATEGORY_USER_INPUT, 37, "The file \"%1$s\" cannot be moved to \"%2$s\"."),
    ADMIN_FILE_ACCESS_NOT_AVAILABLE("No administrative file access exists for service \"%1$s\"", Category.CATEGORY_ERROR, 38),
    FILE_VERSION_NOT_FOUND("File version %1$s of file %2$s not found in folder %3$s.", Category.CATEGORY_USER_INPUT, 39, "The file version you requested does not exist."),
    LOSS_OF_NOTES("Metadata of file \"%4$s\" not supported in target folder \"%5$s\"", CATEGORY_WARNING, 40, "The notes of the file \"%1$s\" in folder \"%2$s\" are lost when moving it into the account \"%3$s\"."),
    LOSS_OF_VERSIONS("Metadata of file \"%4$s\" not supported in target folder \"%5$s\"", CATEGORY_WARNING, 41, "All previous versions of the file \"%1$s\" in folder \"%2$s\" are lost when moving it into the account \"%3$s\"."),
    LOSS_OF_CATEGORIES("Metadata of file \"%4$s\" not supported in target folder \"%5$s\"", CATEGORY_WARNING, 42, "The assigned categories of the file \"%1$s\" in folder \"%2$s\" are lost when moving it into the account \"%3$s\"."),
    LOSS_OF_FILE_SHARES("Metadata of file \"%4$s\" not supported in target folder \"%5$s\"", CATEGORY_WARNING, 43, "The shared file \"%1$s\" in folder \"%2$s\" is no longer accessible by other users when moving it into the account \"%3$s\"."),
    LOSS_OF_FOLDER_SHARES("Metadata of folder \"%3$s\" not supported in target folder \"%4$s\"", CATEGORY_WARNING, 44, "The shared folder \"%1$s\" is no longer accessible by other users when moving it into the account \"%2$s\"."),
    FILE_UPDATE_ABORTED("File update aborted: %2$s", Category.CATEGORY_CONFLICT, 45, "The file \"%1$s\" was not updated due to possible data loss. Please review the warnings for details."),
    VERSIONING_NOT_SUPPORTED("Versioning not supported by '%1$s' file storage.", Category.CATEGORY_ERROR, 46, null),
    NOT_A_FILE("The %1$s URL does not denote a file: %2$s", CATEGORY_USER_INPUT, 47, "The %1$s URL does not denote a file: %1$s"),
    NOT_A_FOLDER("The %1$s URL does not denote a directory: %2$s", CATEGORY_USER_INPUT, 48, "The %1$s URL does not denote a directory: %2$s"),
    MISSING_FILE_NAME("Missing file name.", CATEGORY_USER_INPUT, 49, "Missing file name."),
    UPDATE_DENIED("Update denied for \"%1$s\" resource: %2$s", CATEGORY_USER_INPUT, 50, "Update denied for \"%1$s\" resource: %2$s"),
    DELETE_DENIED("Delete denied for \"%1$s\" resource: %2$s", CATEGORY_PERMISSION_DENIED, 51, "Delete denied for \"%1$s\" resource: %2$s"),
    INVALID_PROPERTY("Invalid property \"%1$s\". Should be \"%2$s\".", CATEGORY_ERROR, 52, null),
    INVALID_TYPE_PROPERTY("Invalid \"%1$s\" property \"%2$s\".", CATEGORY_ERROR, 53, null),
    MISSING_CONFIG("Missing configuration for %1$s account \"%2$s\".", Category.CATEGORY_CONFIGURATION, 54, "Missing configuration for %1$s account \"%2$s\"."),
    NOT_FOUND("The %1$s resource does not exist: %2$s", Category.CATEGORY_ERROR, 55, "The provided %1$s resource does not exist: %2$s"),
    AUTHENTICATION_FAILED("Authentication failed for the file storage account with identifier %1$s (service: %2$s): %3$s", Category.CATEGORY_CONFIGURATION, 56),
    NO_CONTENT("The file %1$s doesn't have any content.", Category.CATEGORY_ERROR, 57, "The file %1$s doesn't have any content."),
    NO_PERMISSION_SUPPORT("No permission support in account \"%1$s\" (folder \"%2$s\", context %3$s.)", Category.CATEGORY_ERROR, 58, "Individual permissions are not supported in account \"%1$s\"."),
    NO_NOTES_SUPPORT("Metadata of file \"%3$s\" not supported in target folder \"%4$s\"", CATEGORY_WARNING, 59, "Saving notes for file \"%1$s\" is not supported in account \"%2$s\"."),
    NO_CATEGORIES_SUPPORT("Metadata of file \"%3$s\" not supported in target folder \"%4$s\"", CATEGORY_WARNING, 60, "Assigning categories to file \"%1$s\" is not supported in account \"%2$s\"."),
    FILE_SAVE_ABORTED("File save aborted: %2$s", Category.CATEGORY_CONFLICT, 61, "The file \"%1$s\" was not saved due to possible data loss. Please review the warnings for details."),
    INVALID_OBJECT_PERMISSIONS("Invalid permissions (%1$d) for entity (%2$d) on object %3$s.", Category.CATEGORY_PERMISSION_DENIED, 62);

    public static final String PREFIX = "FILE_STORAGE";
    private final Category category;
    private final int detailNumber;
    private final String message;
    private final String displayMessage;

    private FileStorageExceptionCodes(String message, Category category, int detailNumber) {
        this(message, category, detailNumber, null);
    }

    private FileStorageExceptionCodes(String message, Category category, int detailNumber, String displayMessage) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public Category getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

