/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.internal;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AdministrativeFileStorageFileAccess;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageUtility;
import com.openexchange.file.storage.Range;
import com.openexchange.file.storage.infostore.FileMetadata;
import com.openexchange.file.storage.infostore.InfostoreFile;
import com.openexchange.file.storage.infostore.internal.FieldMapping;
import com.openexchange.file.storage.infostore.internal.InfostoreAccess;
import com.openexchange.file.storage.infostore.internal.InfostoreTimedResult;
import com.openexchange.file.storage.infostore.osgi.Services;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.user.UserService;
import com.openexchange.userconf.UserPermissionService;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AdministrativeInfostoreFileAccess
extends InfostoreAccess
implements AdministrativeFileStorageFileAccess {
    private final Context context;

    public AdministrativeInfostoreFileAccess(InfostoreFacade infostore, Context context) {
        super(infostore);
        this.context = context;
    }

    public File getFileMetadata(String folderId, String id, String version) throws OXException {
        try {
            DocumentMetadata documentMetadata = this.getInfostore(folderId).getDocumentMetadata(AdministrativeInfostoreFileAccess.ID(id), AdministrativeInfostoreFileAccess.VERSION(version), this.context);
            if (null != folderId && documentMetadata.getFolderId() > 0L && !folderId.equals(Long.toString(documentMetadata.getFolderId()))) {
                throw FileStorageExceptionCodes.FILE_NOT_FOUND.create(new Object[]{id, folderId});
            }
            return new InfostoreFile(documentMetadata);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    public void saveFileMetadata(File file, long sequenceNumber, List<File.Field> modifiedFields) throws OXException {
        if (modifiedFields.contains(File.Field.URL)) {
            FileStorageUtility.checkUrl((File)file);
        }
        this.getInfostore(file.getFolderId()).saveDocumentMetadata((DocumentMetadata)new FileMetadata(file), sequenceNumber, FieldMapping.getMatching(modifiedFields), this.context);
    }

    public void removeDocument(String folderId, String id) throws OXException {
        this.getInfostore(folderId).removeDocuments(Collections.singletonList(new FileStorageFileAccess.IDTuple(folderId, id)), this.context);
    }

    public void removeDocuments(List<FileStorageFileAccess.IDTuple> ids) throws OXException {
        HashMap<String, LinkedList<FileStorageFileAccess.IDTuple>> idsByFolder = new HashMap<String, LinkedList<FileStorageFileAccess.IDTuple>>(ids.size());
        for (FileStorageFileAccess.IDTuple iDTuple : ids) {
            String folderId = iDTuple.getFolder();
            LinkedList<FileStorageFileAccess.IDTuple> fileIds = (LinkedList<FileStorageFileAccess.IDTuple>)idsByFolder.get(folderId);
            if (fileIds == null) {
                fileIds = new LinkedList<FileStorageFileAccess.IDTuple>();
                idsByFolder.put(folderId, fileIds);
            }
            fileIds.add(iDTuple);
        }
        for (Map.Entry entry : idsByFolder.entrySet()) {
            this.getInfostore((String)entry.getKey()).removeDocuments((List)entry.getValue(), this.context);
        }
    }

    public boolean exists(String folderId, String id, String version) throws OXException {
        return this.getInfostore(folderId).exists(AdministrativeInfostoreFileAccess.ID(id), AdministrativeInfostoreFileAccess.VERSION(version), this.context);
    }

    public boolean canRead(String folderId, String id, int userId) throws OXException {
        User user = Services.getService(UserService.class).getUser(userId, this.context);
        return this.getInfostore(folderId).hasDocumentAccess(AdministrativeInfostoreFileAccess.ID(id), InfostoreFacade.AccessPermission.READ, user, this.context);
    }

    public boolean canWrite(String folderId, String id, int userId) throws OXException {
        User user = Services.getService(UserService.class).getUser(userId, this.context);
        return this.getInfostore(folderId).hasDocumentAccess(AdministrativeInfostoreFileAccess.ID(id), InfostoreFacade.AccessPermission.WRITE, user, this.context);
    }

    public boolean canDelete(String folderId, String id, int userId) throws OXException {
        User user = Services.getService(UserService.class).getUser(userId, this.context);
        return this.getInfostore(folderId).hasDocumentAccess(AdministrativeInfostoreFileAccess.ID(id), InfostoreFacade.AccessPermission.DELETE, user, this.context);
    }

    public TimedResult<File> getDocuments(String folderId, int userId, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order, Range range) throws OXException {
        User user = Services.getService(UserService.class).getUser(userId, this.context);
        UserPermissionBits permissionBits = Services.getService(UserPermissionService.class).getUserPermissionBits(userId, this.context);
        TimedResult timedResult = this.getInfostore(folderId).getDocuments((long)AdministrativeInfostoreFileAccess.ID(folderId), FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), null != range ? range.from : -1, null != range ? range.to : -1, this.context, user, permissionBits);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)timedResult);
    }
}

