/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.folder;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFileStorageFolder;
import com.openexchange.file.storage.DefaultFileStoragePermission;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderType;
import com.openexchange.file.storage.FileStoragePermission;
import com.openexchange.file.storage.TypeAware;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.type.DocumentsType;
import com.openexchange.folderstorage.type.MusicType;
import com.openexchange.folderstorage.type.PicturesType;
import com.openexchange.folderstorage.type.PublicType;
import com.openexchange.folderstorage.type.TemplatesType;
import com.openexchange.folderstorage.type.TrashType;
import com.openexchange.folderstorage.type.VideosType;
import com.openexchange.i18n.LocaleTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class UserizedFileStorageFolder
extends DefaultFileStorageFolder
implements TypeAware {
    private final UserizedFolder folder;
    private FileStorageFolderType type;

    public UserizedFileStorageFolder(UserizedFolder folder) throws OXException {
        this.folder = folder;
        this.setCreationDate(folder.getCreationDateUTC());
        this.setDefaultFolder(folder.isDefault());
        this.setExists(true);
        this.setId(folder.getID());
        this.setLastModifiedDate(folder.getLastModifiedUTC());
        String defaultName = folder.getLocalizedName(LocaleTools.DEFAULT_LOCALE, folder.isAltNames());
        this.setName(null != defaultName ? defaultName : folder.getName());
        this.setParentId(folder.getParentID());
        this.setPermissions(UserizedFileStorageFolder.parsePermission(folder.getPermissions()));
        this.setOwnPermission(UserizedFileStorageFolder.parsePermission(folder.getOwnPermission()));
        this.setRootFolder(folder.getParentID() == null);
        this.setSubscribed(folder.isSubscribed());
        String[] subfolderIDs = folder.getSubfolderIDs();
        this.setSubfolders(subfolderIDs != null && subfolderIDs.length > 0);
        FolderID folderID = new FolderID(folder.getID());
        this.setType(UserizedFileStorageFolder.getType(folder.getType()));
        this.setCreatedBy(folder.getCreatedBy());
        this.setModifiedBy(folder.getModifiedBy());
        if ("com.openexchange.infostore".equals(folderID.getService()) && "infostore".equals(folderID.getAccountId())) {
            this.setCapabilities(FileStorageFolder.ALL_CAPABILITIES);
        }
    }

    public FileStorageFolderType getType() {
        return this.type;
    }

    public void setType(FileStorageFolderType type) {
        this.type = type;
    }

    public String getLocalizedName(Locale locale) {
        return this.folder.getLocalizedName(locale, this.folder.isAltNames());
    }

    public String toString() {
        return "UserizedFileStorageFolder [id=" + this.id + ", name=" + this.name + "]";
    }

    private static FileStoragePermission parsePermission(Permission permission) throws OXException {
        if (null == permission) {
            return null;
        }
        try {
            int entity = permission.getEntity();
            DefaultFileStoragePermission oclPerm = DefaultFileStoragePermission.newInstance();
            oclPerm.setEntity(entity);
            oclPerm.setGroup(permission.isGroup());
            oclPerm.setAdmin(permission.isAdmin());
            oclPerm.setAllPermissions(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
            return oclPerm;
        }
        catch (RuntimeException e) {
            throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private static List<FileStoragePermission> parsePermission(Permission[] permissions) throws OXException {
        if (null == permissions || 0 == permissions.length) {
            return Collections.emptyList();
        }
        ArrayList<FileStoragePermission> perms = new ArrayList<FileStoragePermission>(permissions.length);
        for (Permission permission : permissions) {
            perms.add(UserizedFileStorageFolder.parsePermission(permission));
        }
        return perms;
    }

    private static FileStorageFolderType getType(Type type) {
        if (TrashType.getInstance().equals(type)) {
            return FileStorageFolderType.TRASH_FOLDER;
        }
        if (PublicType.getInstance().equals(type)) {
            return FileStorageFolderType.PUBLIC_FOLDER;
        }
        if (PicturesType.getInstance().equals(type)) {
            return FileStorageFolderType.PICTURES_FOLDER;
        }
        if (DocumentsType.getInstance().equals(type)) {
            return FileStorageFolderType.DOCUMENTS_FOLDER;
        }
        if (MusicType.getInstance().equals(type)) {
            return FileStorageFolderType.MUSIC_FOLDER;
        }
        if (VideosType.getInstance().equals(type)) {
            return FileStorageFolderType.VIDEOS_FOLDER;
        }
        if (TemplatesType.getInstance().equals(type)) {
            return FileStorageFolderType.TEMPLATES_FOLDER;
        }
        return FileStorageFolderType.NONE;
    }
}

