/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.tools.RandomString;
import com.openexchange.tools.file.internal.LocalFileStorage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(FileStorageTest.class);

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public final void testGetInstance() throws Throwable {
        File tempFile = File.createTempFile("filestorage", ".tmp");
        tempFile.delete();
        LOG.trace(tempFile.getAbsolutePath());
        LocalFileStorage storage = new LocalFileStorage(tempFile.toURI());
        FileStorageTest.rmdir(tempFile);
        FileStorageTest.assertNotNull((String)"Can't create file storage.", (Object)storage);
    }

    public final void testSaveNewFile() throws Throwable {
        File tempFile = File.createTempFile("filestorage", ".tmp");
        tempFile.delete();
        String fileContent = RandomString.generateLetter(100);
        ByteArrayInputStream baos = new ByteArrayInputStream(fileContent.getBytes(Charsets.UTF_8));
        LocalFileStorage storage = new LocalFileStorage(tempFile.toURI());
        String identifier = storage.saveNewFile((InputStream)baos);
        FileStorageTest.rmdir(tempFile);
        FileStorageTest.assertNotNull((String)"Can't create new file in file storage.", (Object)identifier);
    }

    public final void testExceptionOnUnavailableFilestore() throws Throwable {
        File tempFile = File.createTempFile("filestorage", ".tmp");
        tempFile.delete();
        String fileContent = RandomString.generateLetter(100);
        ByteArrayInputStream baos = new ByteArrayInputStream(fileContent.getBytes(Charsets.UTF_8));
        LocalFileStorage storage = new LocalFileStorage(tempFile.toURI());
        String identifier = storage.saveNewFile((InputStream)baos);
        FileStorageTest.rmdir(tempFile);
        FileStorageTest.assertFalse((boolean)tempFile.exists());
        try {
            storage.getFile(identifier);
            FileStorageTest.fail((String)"Expected IOException");
        }
        catch (OXException oXException) {
            // empty catch block
        }
        try {
            storage.saveNewFile((InputStream)baos);
            FileStorageTest.fail((String)"Expected IOException");
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }

    public final void testExceptionOnUnknown() throws Throwable {
        File tempFile = File.createTempFile("filestorage", ".tmp");
        tempFile.delete();
        LocalFileStorage storage = new LocalFileStorage(tempFile.toURI());
        try {
            storage.getFile("00/00/01");
            FileStorageTest.fail((String)"Expected IOException");
        }
        catch (OXException oXException) {
            // empty catch block
        }
        FileStorageTest.rmdir(tempFile);
    }

    public final void testDeleteFile() throws Throwable {
        ByteArrayInputStream baos = new ByteArrayInputStream(RandomString.generateLetter(100).getBytes(Charsets.UTF_8));
        File tempFile = File.createTempFile("filestorage", ".tmp");
        tempFile.delete();
        LocalFileStorage storage = new LocalFileStorage(tempFile.toURI());
        String identifier = storage.saveNewFile((InputStream)baos);
        FileStorageTest.assertTrue((boolean)storage.deleteFile(identifier));
        FileStorageTest.assertFalse((boolean)storage.deleteFile(identifier));
    }

    private static void rmdir(File tempFile) {
        if (tempFile.isDirectory()) {
            for (File f : tempFile.listFiles()) {
                FileStorageTest.rmdir(f);
            }
        }
        tempFile.delete();
    }
}

