/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.resourcecache.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.Header;
import com.openexchange.test.resourcecache.actions.AbstractResourceCacheRequest;
import com.openexchange.test.resourcecache.actions.UploadResponse;
import com.openexchange.test.resourcecache.actions.UploadResponseParser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class UploadRequest
extends AbstractResourceCacheRequest<UploadResponse> {
    private final List<AJAXRequest.FileParameter> files = new ArrayList<AJAXRequest.FileParameter>();
    private final boolean waitForAlignment;
    private String resourceId = null;

    public UploadRequest() {
        super("upload");
        this.waitForAlignment = false;
    }

    public UploadRequest(boolean waitForAlignment) {
        super("upload");
        this.waitForAlignment = waitForAlignment;
    }

    public void addFile(String fileName, String mimeType, InputStream is) {
        this.files.add(new AJAXRequest.FileParameter("resource_" + this.files.size(), fileName, is, mimeType));
    }

    public void setResourceId(String id) {
        this.resourceId = id;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.POST;
    }

    @Override
    public AJAXRequest.Parameter[] getAdditionalParameters() {
        LinkedList<AJAXRequest.Parameter> allParams = new LinkedList<AJAXRequest.Parameter>();
        allParams.addAll(this.files);
        allParams.add(new AJAXRequest.URLParameter("waitForAlignment", Boolean.toString(this.waitForAlignment)));
        if (this.resourceId != null) {
            allParams.add(new AJAXRequest.URLParameter("id", this.resourceId));
        }
        return allParams.toArray(new AJAXRequest.Parameter[0]);
    }

    public UploadResponseParser getParser() {
        return new UploadResponseParser(true);
    }

    @Override
    public Header[] getHeaders() {
        return new Header[]{new Header.SimpleHeader("Content-Type", "multipart/form-data")};
    }
}

