/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test;

import com.openexchange.ajax.contact.action.AdvancedSearchRequest;
import com.openexchange.ajax.contact.action.AllRequest;
import com.openexchange.ajax.contact.action.ContactUpdatesResponse;
import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.contact.action.ListRequest;
import com.openexchange.ajax.contact.action.SearchRequest;
import com.openexchange.ajax.contact.action.SearchResponse;
import com.openexchange.ajax.contact.action.UpdateRequest;
import com.openexchange.ajax.contact.action.UpdatesRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.CommonSearchResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.ajax.parser.ContactParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.java.Streams;
import com.openexchange.java.UnsynchronizedByteArrayOutputStream;
import com.openexchange.test.ContactMapping;
import com.openexchange.test.TestManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.xml.sax.SAXException;

public class ContactTestManager
implements TestManager {
    protected boolean failOnError;
    protected List<Contact> createdEntities;
    protected AJAXClient client;
    protected ContactParser contactParser;
    protected TimeZone timeZone;
    protected Throwable lastException;
    protected AbstractAJAXResponse lastResponse;
    private int sleep = 0;

    @Override
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public boolean getFailOnError() {
        return this.failOnError;
    }

    public void setCreatedEntities(List<Contact> createdEntities) {
        this.createdEntities = createdEntities;
    }

    public List<Contact> getCreatedEntities() {
        return this.createdEntities;
    }

    public void setClient(AJAXClient client) {
        this.client = client;
    }

    public AJAXClient getClient() {
        return this.client;
    }

    private void setTimeZone(TimeZone timezone) {
        this.timeZone = timezone;
    }

    private TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setContactParser(ContactParser contactParser) {
        this.contactParser = contactParser;
    }

    public ContactParser getContactParser() {
        return this.contactParser;
    }

    public ContactTestManager(AJAXClient client) throws OXException, IOException, SAXException, JSONException {
        this.setClient(client);
        this.setTimeZone(client.getValues().getTimeZone());
        this.setCreatedEntities(new LinkedList<Contact>());
        this.setContactParser(new ContactParser(true, this.timeZone));
    }

    public static Contact generateContact() {
        Contact contact = ContactTestManager.generateContact(666);
        contact.removeParentFolderID();
        return contact;
    }

    public static Contact generateContact(int folderId) {
        return ContactTestManager.generateContact(folderId, "surname");
    }

    public static Contact generateContact(int folderId, String lastname) {
        Contact contact = new Contact();
        contact.setGivenName("givenname");
        contact.setSurName(lastname);
        contact.setMiddleName("middlename");
        contact.setSuffix("suffix");
        contact.setEmail1("email1@ox.invalid");
        contact.setEmail2("email2@ox.invalid");
        contact.setEmail3("email3@ox.invalid");
        contact.setDisplayName("displayname");
        contact.setPosition("position");
        contact.setTitle("title");
        contact.setCompany("company");
        contact.setParentFolderID(folderId);
        return contact;
    }

    public static Contact generateFullContact(int folderID) {
        Contact contact = new Contact();
        for (int field : Contact.ALL_COLUMNS) {
            try {
                contact.set(field, (Object)new Integer(field));
            }
            catch (ClassCastException e1) {
                try {
                    contact.set(field, (Object)String.valueOf(field));
                }
                catch (ClassCastException e2) {
                    try {
                        contact.set(field, (Object)new Date(field));
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        }
        contact.setEmail1("email1@hostinvalid");
        contact.setEmail2("email2@hostinvalid");
        contact.setEmail3("email3@hostinvalid");
        contact.removeObjectID();
        contact.setParentFolderID(folderID);
        return contact;
    }

    public Contact newAction(Contact contactToCreate) {
        InsertRequest request = new InsertRequest(contactToCreate, this.getFailOnError());
        InsertResponse response = null;
        try {
            response = this.getClient().execute(request, this.getSleep());
            response.fillObject((DataObject)contactToCreate);
            this.lastResponse = response;
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "NewRequest");
        }
        this.getCreatedEntities().add(contactToCreate);
        return contactToCreate;
    }

    public void newAction(Contact ... contacts) {
        for (int i = 0; i < contacts.length; ++i) {
            this.newAction(contacts[i]);
        }
    }

    public void newActionMultiple(Contact ... contacts) {
        int i;
        InsertRequest[] requests = new InsertRequest[contacts.length];
        for (i = 0; i < requests.length; ++i) {
            requests[i] = new InsertRequest(contacts[i], this.getFailOnError());
        }
        try {
            MultipleRequest request = MultipleRequest.create(requests);
            MultipleResponse responses = (MultipleResponse)this.getClient().execute(request, this.getSleep());
            this.lastResponse = responses;
            Iterator it = responses.iterator();
            i = 0;
            while (it.hasNext()) {
                InsertResponse response = (InsertResponse)((Object)it.next());
                response.fillObject((DataObject)contacts[i]);
                this.getCreatedEntities().add(contacts[i]);
                ++i;
            }
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "NewRequest");
        }
    }

    public Contact updateAction(Contact contact) {
        return this.updateAction(contact.getParentFolderID(), contact);
    }

    public Contact updateAction(int inFolder, Contact contact) {
        UpdateRequest request = new UpdateRequest(inFolder, contact, true);
        try {
            this.lastResponse = this.getClient().execute(request, this.getSleep());
            contact.setLastModified(this.lastResponse.getTimestamp());
            this.remember(contact);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "UpdateRequest for folder " + contact.getParentFolderID() + " and object " + contact.getObjectID());
        }
        return contact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAction(Contact contactToDelete) {
        boolean oldValue = this.getFailOnError();
        this.setFailOnError(this.failOnError);
        try {
            contactToDelete.setLastModified(new Date(Long.MAX_VALUE));
            DeleteRequest request = new DeleteRequest(contactToDelete, this.getFailOnError());
            this.lastResponse = this.getClient().execute(request, this.getSleep());
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "DeleteRequest for folder " + contactToDelete.getParentFolderID() + " and object " + contactToDelete.getObjectID());
        }
        finally {
            this.setFailOnError(oldValue);
        }
        this.getCreatedEntities().remove(contactToDelete);
    }

    public Contact getAction(Contact contact) {
        return this.getAction(contact.getParentFolderID(), contact.getObjectID());
    }

    public Contact getAction(int folderId, int objectId) {
        Contact returnedContact = null;
        GetRequest request = new GetRequest(folderId, objectId, this.getTimeZone(), false);
        GetResponse response = null;
        try {
            response = this.getClient().execute(request, this.getSleep());
            this.lastResponse = response;
            if (response.hasError() && this.getFailOnError()) {
                throw response.getException();
            }
            returnedContact = response.getContact();
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "GetRequest for folder " + folderId + " and object " + objectId);
            return null;
        }
        return returnedContact;
    }

    @Override
    public void cleanUp() {
        for (Contact contact : new Vector<Contact>(this.getCreatedEntities())) {
            boolean old = this.getFailOnError();
            this.setFailOnError(false);
            this.deleteAction(contact);
            this.setFailOnError(old);
        }
    }

    public Contact[] allAction(int folderId, int[] columns, int orderBy, Order order, String collation) {
        List<Object> allContacts = new LinkedList();
        AllRequest request = new AllRequest(folderId, columns, orderBy, order, collation);
        try {
            CommonAllResponse response = this.getClient().execute(request, this.getSleep());
            this.lastResponse = response;
            JSONArray data = (JSONArray)response.getResponse().getData();
            allContacts = this.transform(data, columns);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "AllRequest for folder " + folderId);
        }
        return allContacts.toArray(new Contact[0]);
    }

    public Contact[] allAction(int folderId, int[] columns) {
        List<Object> allContacts = new LinkedList();
        AllRequest request = new AllRequest(folderId, columns);
        try {
            CommonAllResponse response = this.getClient().execute(request, this.getSleep());
            this.lastResponse = response;
            JSONArray data = (JSONArray)response.getResponse().getData();
            allContacts = this.transform(data, columns);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "AllRequest for folder " + folderId);
        }
        return allContacts.toArray(new Contact[0]);
    }

    public Contact[] allAction(int folderId) {
        return this.allAction(folderId, Contact.ALL_COLUMNS);
    }

    public Contact[] listAction(int[] ... folderAndObjectIds) {
        List<Object> allContacts = new LinkedList();
        ListRequest request = new ListRequest(ListIDs.l(folderAndObjectIds), Contact.ALL_COLUMNS, true);
        try {
            CommonListResponse response = this.getClient().execute(request, this.getSleep());
            this.lastResponse = response;
            JSONArray data = (JSONArray)response.getResponse().getData();
            allContacts = this.transform(data);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "ListRequest");
        }
        return allContacts.toArray(new Contact[0]);
    }

    public Contact[] searchAction(String pattern, int folderId) {
        return this.searchAction(pattern, folderId, Contact.ALL_COLUMNS);
    }

    public Contact[] searchAction(String pattern, int folderId, int ... columns) {
        return this.searchAction(pattern, folderId, -1, null, null, Contact.ALL_COLUMNS);
    }

    public Contact[] searchAction(String pattern, int folderId, int orderBy, Order order, String collation, int ... columns) {
        List<Object> allContacts = new LinkedList();
        String orderDir = order == null ? "ASC" : (order.equals((Object)Order.ASCENDING) ? "ASC" : "DESC");
        SearchRequest request = new SearchRequest(pattern, false, folderId, columns, orderBy, orderDir, collation, this.failOnError);
        try {
            SearchResponse response = this.getClient().execute(request, this.getSleep());
            this.lastResponse = response;
            JSONArray data = (JSONArray)response.getResponse().getData();
            allContacts = this.transform(data, columns);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "searching for contacts with pattern: " + pattern + ", in folder: " + Integer.toString(folderId) + e.getMessage());
        }
        return allContacts.toArray(new Contact[0]);
    }

    public Contact[] searchFirstletterAction(String firstLetter, int folderId) {
        List<Object> allContacts = new LinkedList();
        SearchRequest request = new SearchRequest(firstLetter, true, folderId, Contact.ALL_COLUMNS, -1, null, true);
        try {
            SearchResponse response = this.getClient().execute(request, this.getSleep());
            this.lastResponse = response;
            JSONArray data = (JSONArray)response.getResponse().getData();
            allContacts = this.transform(data);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "searching for contacts with first letter: " + firstLetter + ", in folder: " + Integer.toString(folderId) + e.getMessage());
        }
        return allContacts.toArray(new Contact[0]);
    }

    public Contact[] searchAction(ContactSearchObject search) {
        return this.searchAction(search, Contact.ALL_COLUMNS);
    }

    public Contact[] searchAction(ContactSearchObject search, int[] columns) {
        return this.searchAction(search, columns, -1, null, null);
    }

    public Contact[] searchAction(ContactSearchObject search, int[] columns, int orderBy, Order order, String collation) {
        List<Object> allContacts = new LinkedList();
        SearchRequest request = new SearchRequest(search, columns, orderBy, order, collation, this.getFailOnError());
        try {
            SearchResponse response = this.getClient().execute(request, this.getSleep());
            this.lastResponse = response;
            JSONArray data = (JSONArray)response.getResponse().getData();
            allContacts = this.transform(data, columns);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "searching for contacts with search-object: " + search + ": " + e.getMessage());
        }
        return allContacts.toArray(new Contact[0]);
    }

    public Contact[] searchAction(String pattern, int folderId, boolean initialSearch) {
        List<Object> allContacts = new LinkedList();
        SearchRequest request = new SearchRequest(pattern, folderId, Contact.ALL_COLUMNS, true);
        try {
            SearchResponse response = this.getClient().execute(request, this.getSleep());
            this.lastResponse = response;
            JSONArray data = (JSONArray)response.getResponse().getData();
            allContacts = this.transform(data);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "searching for contacts with pattern: " + pattern + ", in folder: " + Integer.toString(folderId) + e.getMessage());
        }
        return allContacts.toArray(new Contact[0]);
    }

    public Contact[] searchAction(JSONObject filter, int[] columns, int orderBy, Order order) {
        List<Object> contacts = new LinkedList();
        AdvancedSearchRequest request = new AdvancedSearchRequest(filter, columns, orderBy, order == Order.DESCENDING ? "DESC" : "ASC");
        try {
            CommonSearchResponse response = this.getClient().execute(request, this.getSleep());
            this.lastResponse = response;
            JSONArray data = (JSONArray)response.getResponse().getData();
            contacts = this.transform(data, columns);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "searching for contacts with term: \n" + filter.toString());
        }
        return contacts.toArray(new Contact[0]);
    }

    public Contact[] updatesAction(int folderId, Date lastModified) {
        List<Object> allContacts = new LinkedList();
        UpdatesRequest request = new UpdatesRequest(folderId, Contact.ALL_COLUMNS, -1, null, lastModified);
        try {
            ContactUpdatesResponse response = this.getClient().execute(request, this.getSleep());
            this.lastResponse = response;
            JSONArray data = (JSONArray)response.getResponse().getData();
            allContacts = this.transform(data);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "UpdateRequest");
        }
        return allContacts.toArray(new Contact[0]);
    }

    protected void doExceptionHandling(Exception exception, String action) {
        block10: {
            try {
                this.lastException = exception;
                throw exception;
            }
            catch (OXException e) {
                if (this.getFailOnError()) {
                    e.printStackTrace();
                    Assert.fail((String)("AjaxException occured during " + action + ": " + e.getMessage()));
                }
            }
            catch (IOException e) {
                if (this.getFailOnError()) {
                    e.printStackTrace();
                    Assert.fail((String)("IOException occured during " + action + ": " + e.getMessage()));
                }
            }
            catch (SAXException e) {
                if (this.getFailOnError()) {
                    e.printStackTrace();
                    Assert.fail((String)("SAXException occured during " + action + ": " + e.getMessage()));
                }
            }
            catch (JSONException e) {
                if (this.getFailOnError()) {
                    e.printStackTrace();
                    Assert.fail((String)("JSONException occured during " + action + ": " + e.getMessage()));
                }
            }
            catch (Exception e) {
                if (!this.getFailOnError()) break block10;
                e.printStackTrace();
                Assert.fail((String)("Unexpected exception occured during " + action + ": " + e.getMessage()));
            }
        }
    }

    protected void doJanitorialTasks(AbstractAJAXResponse response) throws OXException {
        this.lastResponse = response;
        if (response.hasError() && this.failOnError) {
            throw response.getException();
        }
    }

    private void remember(Contact contact) {
        for (Contact tempContact : this.getCreatedEntities()) {
            if (tempContact.getObjectID() == contact.getObjectID()) {
                this.getCreatedEntities().set(this.getCreatedEntities().indexOf(tempContact), contact);
                continue;
            }
            this.getCreatedEntities().add(contact);
        }
    }

    public List<Contact> transform(JSONArray data) throws JSONException, OXException, IOException {
        return this.transform(data, Contact.ALL_COLUMNS);
    }

    public List<Contact> transform(JSONArray data, int[] columns) throws JSONException, OXException, IOException {
        LinkedList<Contact> contacts = new LinkedList<Contact>();
        for (int i = 0; i < data.length(); ++i) {
            String image1;
            JSONArray jsonArray = data.getJSONArray(i);
            JSONObject jsonObject = new JSONObject();
            for (int a = 0; a < jsonArray.length(); ++a) {
                String fieldname;
                if ("null".equals(jsonArray.getString(a)) || (fieldname = ContactMapping.columnToFieldName(columns[a])) == null) continue;
                jsonObject.put(fieldname, jsonArray.get(a));
            }
            Contact contactObject = new Contact();
            this.getContactParser().parse(contactObject, jsonObject);
            if (null != contactObject.getImage1() && 0 < (image1 = new String(contactObject.getImage1())).length() && image1.contains("image")) {
                String url = image1 + "&compress=false&rotate=false";
                try {
                    contactObject.setImage1(this.loadImage(url));
                    contactObject.setNumberOfImages(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            contacts.add(contactObject);
        }
        return contacts;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadImage(String imageURL) throws OXException {
        byte[] byArray;
        InputStream inputStream = null;
        UnsynchronizedByteArrayOutputStream outputStream = null;
        try {
            int read;
            AJAXSession ajaxSession = this.getClient().getSession();
            HttpGet httpRequest = new HttpGet(this.getClient().getProtocol() + "://" + this.getClient().getHostname() + imageURL);
            HttpResponse httpResponse = ajaxSession.getHttpClient().execute((HttpUriRequest)httpRequest);
            inputStream = httpResponse.getEntity().getContent();
            int len = 8192;
            byte[] buf = new byte[len];
            outputStream = new UnsynchronizedByteArrayOutputStream(len << 2);
            while ((read = inputStream.read(buf, 0, len)) > 0) {
                outputStream.write(buf, 0, read);
            }
            byArray = outputStream.toByteArray();
        }
        catch (ClientProtocolException e) {
            try {
                throw new OXException((Throwable)e);
                catch (IOException e2) {
                    throw new OXException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{inputStream, outputStream});
                throw throwable;
            }
        }
        Streams.close((Closeable[])new Closeable[]{inputStream, outputStream});
        return byArray;
    }

    @Override
    public boolean doesFailOnError() {
        return this.getFailOnError();
    }

    @Override
    public Throwable getLastException() {
        return this.lastException;
    }

    @Override
    public AbstractAJAXResponse getLastResponse() {
        return this.lastResponse;
    }

    @Override
    public boolean hasLastException() {
        return this.lastException != null;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public int getSleep() {
        return this.sleep;
    }
}

