/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.push.udp;

import com.clarkware.junitperf.TimedTest;
import com.meterware.httpunit.WebConversation;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.push.udp.PushResponseTest;
import com.openexchange.push.udp.RegisterTest;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.FolderTest;
import com.openexchange.webdav.xml.GroupUserTest;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;

public class PushTestSuite
extends TestSuite {
    protected static final String localAddress = "localhost";
    protected static final int localPort = 33890;

    public static Test suite() throws Exception {
        WebConversation webConversation = new WebConversation();
        int userId = GroupUserTest.getUserId(webConversation, localAddress, "offspring", "netline", "defaultcontext");
        int contextId = GroupUserTest.getContextId(webConversation, localAddress, "offspring", "netline", "defaultcontext");
        int appointmentFolderId = FolderTest.getAppointmentDefaultFolder(webConversation, localAddress, "offspring", "netline", "defaultcontext").getObjectID();
        long maxElapsedTime = 10000L;
        DatagramSocket datagramSocket = new DatagramSocket(33890, InetAddress.getByName(localAddress));
        RegisterTest registerTest = new RegisterTest("testRegister", datagramSocket, userId, contextId);
        TimedTest registerTimedTest = new TimedTest((Test)registerTest, 10000L, false);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("pushTestSuite");
        appointmentObj.setStartDate(new Date());
        appointmentObj.setEndDate(new Date());
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setShownAs(3);
        AppointmentTest.insertAppointment(webConversation, appointmentObj, localAddress, "offspring", "netline", "defaultcontext");
        long maxResponseTime = 20000L;
        PushResponseTest pushTest = new PushResponseTest("testPushResponse", datagramSocket, appointmentFolderId, contextId);
        TimedTest pushTimedTest = new TimedTest((Test)pushTest, 20000L, false);
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)registerTimedTest);
        testSuite.addTest((Test)pushTimedTest);
        return testSuite;
    }
}

