/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.messagestorage;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.messagestorage.MessageStorageTest;

public final class MailFlagsTest
extends MessageStorageTest {
    private static final MailField[] FIELDS_ID_AND_FLAGS = new MailField[]{MailField.ID, MailField.FLAGS};

    public void testMailFlagsNonExistingIds() throws OXException {
        try {
            long currentTimeMillis = System.currentTimeMillis();
            String[] nonexistingids = new String[]{String.valueOf(currentTimeMillis), String.valueOf(currentTimeMillis + 1L)};
            this.mailAccess.getMessageStorage().updateMessageFlags("INBOX", nonexistingids, 32, true);
        }
        catch (Exception e) {
            MailFlagsTest.fail((String)("No Exception should be thrown here but was " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailFlagsNonExistingIdsMixed() throws OXException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            long currentTimeMillis = System.currentTimeMillis();
            String[] fetchIds = new String[]{uids[0]};
            String[] mixednonexistingids = new String[]{String.valueOf(currentTimeMillis), uids[0]};
            this.mailAccess.getMessageStorage().updateMessageFlags("INBOX", mixednonexistingids, 32, true);
            MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", fetchIds, FIELDS_ID_AND_FLAGS);
            MailFlagsTest.assertTrue((String)"Mail is not marked as \\Seen", (boolean)fetchedMails[0].isSeen());
            this.mailAccess.getMessageStorage().updateMessageFlags("INBOX", mixednonexistingids, 1, true);
            fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", fetchIds, FIELDS_ID_AND_FLAGS);
            MailFlagsTest.assertTrue((String)"Mail is not marked as \\Answered", (boolean)fetchedMails[0].isAnswered());
        }
        catch (Exception e) {
            MailFlagsTest.fail((String)("No Exception should be thrown here but was " + e.getMessage()));
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailFlagsNotExistingFolder() throws OXException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            try {
                this.mailAccess.getMessageStorage().updateMessageFlags("MichGibtEsNicht1337", uids, 32, true);
            }
            catch (OXException e) {
                MailFlagsTest.assertTrue((String)"Wrong Exception is thrown.", (boolean)e.getErrorCode().endsWith("-1002"));
            }
            try {
                this.mailAccess.getMessageStorage().updateMessageFlags("MichGibtEsNicht1337", uids, 1, true);
            }
            catch (OXException e) {
                MailFlagsTest.assertTrue((String)"Wrong Exception is thrown.", (boolean)e.getErrorCode().endsWith("-1002"));
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailFlags() throws OXException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            int i;
            this.mailAccess.getMessageStorage().updateMessageFlags("INBOX", uids, 32, true);
            MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_ID_AND_FLAGS);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailFlagsTest.assertTrue((String)"Mail is not marked as \\Seen", (boolean)fetchedMails[i].isSeen());
            }
            this.mailAccess.getMessageStorage().updateMessageFlags("INBOX", uids, 1, true);
            fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_ID_AND_FLAGS);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailFlagsTest.assertTrue((String)"Mail is not marked as \\Answered", (boolean)fetchedMails[i].isAnswered());
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailFlagsUserFlags() throws OXException {
        if (!this.mailAccess.getFolderStorage().getFolder("INBOX").isSupportsUserFlags()) {
            System.err.println("User flags not supported. Skipping test for user flag $Forwarded...");
            return;
        }
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            int i;
            this.mailAccess.getMessageStorage().updateMessageFlags("INBOX", uids, 256, true);
            MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_ID_AND_FLAGS);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailFlagsTest.assertTrue((String)"Mail is not marked as $Forwarded", (boolean)fetchedMails[i].isForwarded());
            }
            this.mailAccess.getMessageStorage().updateMessageFlags("INBOX", uids, 512, true);
            fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_ID_AND_FLAGS);
            for (i = 0; i < fetchedMails.length; ++i) {
                MailFlagsTest.assertTrue((String)"Mail is not marked as $MDNSent", (boolean)fetchedMails[i].isReadAcknowledgment());
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailFlagsWith268() throws OXException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            this.mailAccess.getMessageStorage().updateMessageFlags("INBOX", uids, 268, true);
            MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_ID_AND_FLAGS);
            boolean checkForwarded = this.mailAccess.getFolderStorage().getFolder("INBOX").isSupportsUserFlags();
            for (int i = 0; i < fetchedMails.length; ++i) {
                if (checkForwarded) {
                    MailFlagsTest.assertTrue((String)"Mail is not marked as $Forwarded", (boolean)fetchedMails[i].isForwarded());
                }
                MailFlagsTest.assertTrue((String)"Mail is not marked as \\Draft", (boolean)fetchedMails[i].isDraft());
                MailFlagsTest.assertTrue((String)"Mail is not marked as \\Flagged", (boolean)fetchedMails[i].isFlagged());
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }
}

