/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import java.util.ArrayList;

public final class MailMessageTest
extends AbstractMailTest {
    private static final MailField[] COMMON_LIST_FIELDS = new MailField[]{MailField.ID, MailField.FOLDER_ID, MailField.FROM, MailField.TO, MailField.RECEIVED_DATE, MailField.SENT_DATE, MailField.SUBJECT, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.PRIORITY, MailField.COLOR_LABEL};
    private static final String TEMPL = "Missing field %s in message %d in folder %s";

    public MailMessageTest() {
    }

    public MailMessageTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetMessages() {
        try {
            SessionObject session = this.getSession();
            MailAccess mailConnection = MailAccess.getInstance((Session)session);
            mailConnection.connect();
            try {
                int i;
                MailFolder inboxFolder = mailConnection.getFolderStorage().getFolder("INBOX");
                MailMessage[] msgs = mailConnection.getMessageStorage().searchMessages(inboxFolder.getFullname(), null, MailSortField.RECEIVED_DATE, OrderDirection.DESC, null, COMMON_LIST_FIELDS);
                MailMessageTest.assertTrue((String)"No messages returned!", (msgs != null && msgs.length > 0 ? 1 : 0) != 0);
                if (msgs == null) {
                    return;
                }
                MailMessageTest.assertTrue((String)"No not all messages returned!", (msgs.length == inboxFolder.getMessageCount() ? 1 : 0) != 0);
                boolean cached = msgs.length < MailProperties.getInstance().getMailFetchLimit();
                String[] uids = null;
                ArrayList<String> sla = new ArrayList<String>(msgs.length);
                for (i = 0; i < msgs.length; ++i) {
                    MailMessageTest.assertTrue((String)"Missing UID", (msgs[i].getMailId() != null ? 1 : 0) != 0);
                    sla.add(msgs[i].getMailId());
                    MailMessageTest.assertTrue((String)"Missing Subject", (boolean)msgs[i].containsSubject());
                    MailMessageTest.assertTrue((String)"Missing Priority", (boolean)msgs[i].containsPriority());
                    MailMessageTest.assertTrue((String)"Missing To", (boolean)msgs[i].containsTo());
                    MailMessageTest.assertTrue((String)"Missing Flags", (boolean)msgs[i].containsFlags());
                    MailMessageTest.assertTrue((String)"Missing User Flags", (boolean)msgs[i].containsUserFlags());
                    if (cached) continue;
                    MailMessageTest.assertFalse((String)"Non-Requested field size is present", (boolean)msgs[i].containsSize());
                }
                uids = sla.toArray(new String[sla.size()]);
                if (cached) {
                    MailMessage[] mails = mailConnection.getMessageStorage().getMessages(inboxFolder.getFullname(), uids, new MailField[]{MailField.SIZE});
                    for (i = 0; i < mails.length; ++i) {
                        MailMessageTest.assertTrue((String)"Cached message does not contain size!", (boolean)mails[i].containsSize());
                    }
                    String[] newUids = new String[50];
                    System.arraycopy(uids, 0, newUids, 0, newUids.length);
                    mailConnection.getMessageStorage().updateMessageFlags(inboxFolder.getFullname(), newUids, 32, false);
                }
            }
            finally {
                mailConnection.close(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailMessageTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notestGetAllMessages() {
        try {
            SessionObject session = this.getSession();
            MailAccess mailConnection = MailAccess.getInstance((Session)session);
            mailConnection.connect();
            try {
                MailFolder inboxFolder = mailConnection.getFolderStorage().getFolder("INBOX");
                this.checkSubfolders(inboxFolder, mailConnection);
            }
            finally {
                mailConnection.close(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailMessageTest.fail((String)e.getMessage());
        }
    }

    private void checkSubfolders(MailFolder parent, MailAccess<?, ?> mailConnection) throws OXException {
        this.checkMessages(parent, mailConnection);
        MailFolder[] subfolders = mailConnection.getFolderStorage().getSubfolders(parent.getFullname(), true);
        MailMessageTest.assertTrue((String)"Has Subfolders is wrong!", (boolean)(parent.hasSubfolders() ? subfolders != null && subfolders.length > 0 : subfolders == null || subfolders.length <= 0));
        for (int i = 0; i < subfolders.length; ++i) {
            this.checkSubfolders(subfolders[i], mailConnection);
        }
    }

    private void checkMessages(MailFolder folder, MailAccess<?, ?> mailConnection) {
        MailMessage[] msgs = null;
        try {
            msgs = mailConnection.getMessageStorage().searchMessages(folder.getFullname(), null, MailSortField.RECEIVED_DATE, OrderDirection.DESC, null, COMMON_LIST_FIELDS);
        }
        catch (OXException e) {
            MailMessageTest.assertTrue((String)("Error during fetching messages: " + e.getMessage()), (boolean)e.getCategory().equals(Category.CATEGORY_PERMISSION_DENIED));
            return;
        }
        if (msgs == null) {
            MailMessageTest.fail((String)("Not all messages returned! Got none, expected: " + folder.getMessageCount()));
            return;
        }
        MailMessageTest.assertTrue((String)"No not all messages returned!", (msgs.length == folder.getMessageCount() ? 1 : 0) != 0);
        for (int i = 0; i < msgs.length; ++i) {
            MailMessageTest.assertTrue((String)String.format(TEMPL, "UID", -1L, folder.getFullname()), (msgs[i].getMailId() != null ? 1 : 0) != 0);
            MailMessageTest.assertTrue((String)String.format(TEMPL, "Subject", Long.valueOf(msgs[i].getMailId()), folder.getFullname()), (boolean)msgs[i].containsSubject());
            MailMessageTest.assertTrue((String)String.format(TEMPL, "Priority", Long.valueOf(msgs[i].getMailId()), folder.getFullname()), (boolean)msgs[i].containsPriority());
            MailMessageTest.assertTrue((String)String.format(TEMPL, "To", Long.valueOf(msgs[i].getMailId()), folder.getFullname()), (boolean)msgs[i].containsTo());
            MailMessageTest.assertTrue((String)String.format(TEMPL, "Flags", Long.valueOf(msgs[i].getMailId()), folder.getFullname()), (boolean)msgs[i].containsFlags());
            MailMessageTest.assertTrue((String)String.format(TEMPL, "User Flags", Long.valueOf(msgs[i].getMailId()), folder.getFullname()), (boolean)msgs[i].containsUserFlags());
        }
    }
}

