/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.List;
import java.util.Map;

public class Bug37172Test
extends CardDAVTest {
    public Bug37172Test(String name) {
        super(name);
    }

    public void testNotLosingPhoneNumbers() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug37172Test.randomUID();
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:;Test;;;\r\nUID:" + uid + "\r\n" + "REV:2015-03-09T23:04:44+00:00\r\n" + "FN:Test\r\n" + "PRODID:-//ownCloud//NONSGML Contacts 0.3.0.18//EN\r\n" + "EMAIL;TYPE=WORK:test@abc123.de\r\n" + "TEL;TYPE=CELL:0151 123456789\r\n" + "TEL;TYPE=HOME:0911 9876543\r\n" + "TEL;TYPE=HOME:0160 123456\r\n" + "IMPP;X-SERVICE-TYPE=jabber:xmpp:87654321\r\n" + "TEL;TYPE=WORK:0912 12345678\r\n" + "END:VCARD\r\n";
        Bug37172Test.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Bug37172Test.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        Bug37172Test.assertEquals((String)"firstname wrong", (String)"Test", (String)contact.getGivenName());
        Bug37172Test.assertEquals((String)"lastname wrong", null, (String)contact.getSurName());
        Bug37172Test.assertEquals((String)"cellular phone wrong", (String)"0151 123456789", (String)contact.getCellularTelephone1());
        Bug37172Test.assertEquals((String)"home phone wrong", (String)"0911 9876543", (String)contact.getTelephoneHome1());
        Bug37172Test.assertEquals((String)"home phone alternative wrong", (String)"0160 123456", (String)contact.getTelephoneHome2());
        Bug37172Test.assertEquals((String)"company phone wrong", (String)"0912 12345678", (String)contact.getTelephoneBusiness1());
        Bug37172Test.assertEquals((String)"xmpp jabber wrong", (String)"xmpp:87654321", (String)contact.getInstantMessenger2());
        Bug37172Test.assertEquals((String)"email wrong", (String)"test@abc123.de", (String)contact.getEmail1());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Bug37172Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug37172Test.assertContains(uid, addressData);
        Bug37172Test.assertEquals((String)"N wrong", (String)"Test", (String)card.getGivenName());
        Bug37172Test.assertEquals((String)"FN wrong", (String)"Test", (String)card.getFN());
    }

    public void testNotLosingPhoneNumbersAlt() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug37172Test.randomUID();
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:;Test;;;\r\nUID:" + uid + "\r\n" + "REV:2015-03-09T23:04:44+00:00\r\n" + "FN:Test\r\n" + "PRODID:-//ownCloud//NONSGML Contacts 0.3.0.18//EN\r\n" + "EMAIL;TYPE=WORK:test@abc123.de\r\n" + "TEL;TYPE=CELL:0151 123456789\r\n" + "TEL;TYPE=home,voice:0911 9876543\r\n" + "TEL;TYPE=home,voice:0160 123456\r\n" + "IMPP;X-SERVICE-TYPE=jabber:xmpp:87654321\r\n" + "TEL;TYPE=WORK,voice:0912 12345678\r\n" + "END:VCARD\r\n";
        Bug37172Test.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Bug37172Test.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        Bug37172Test.assertEquals((String)"firstname wrong", (String)"Test", (String)contact.getGivenName());
        Bug37172Test.assertEquals((String)"lastname wrong", null, (String)contact.getSurName());
        Bug37172Test.assertEquals((String)"cellular phone wrong", (String)"0151 123456789", (String)contact.getCellularTelephone1());
        Bug37172Test.assertEquals((String)"home phone wrong", (String)"0911 9876543", (String)contact.getTelephoneHome1());
        Bug37172Test.assertEquals((String)"home phone alternative wrong", (String)"0160 123456", (String)contact.getTelephoneHome2());
        Bug37172Test.assertEquals((String)"company phone wrong", (String)"0912 12345678", (String)contact.getTelephoneBusiness1());
        Bug37172Test.assertEquals((String)"xmpp jabber wrong", (String)"xmpp:87654321", (String)contact.getInstantMessenger2());
        Bug37172Test.assertEquals((String)"email wrong", (String)"test@abc123.de", (String)contact.getEmail1());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Bug37172Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug37172Test.assertContains(uid, addressData);
        Bug37172Test.assertEquals((String)"N wrong", (String)"Test", (String)card.getGivenName());
        Bug37172Test.assertEquals((String)"FN wrong", (String)"Test", (String)card.getFN());
    }
}

