/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Bug36943Test
extends CardDAVTest {
    public Bug36943Test(String name) {
        super(name);
    }

    public void testAddAstralSymbols() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug36943Test.randomUID();
        String firstName = "Pile of \ud83d\udca9 poo";
        String lastName = "test";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "UID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        Bug36943Test.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        String expectedFirstName = firstName.replaceAll("\ud83d\udca9", "");
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Bug36943Test.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        Bug36943Test.assertEquals((String)"firstname wrong", (String)expectedFirstName, (String)contact.getGivenName());
        Bug36943Test.assertEquals((String)"lastname wrong", (String)lastName, (String)contact.getSurName());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Bug36943Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug36943Test.assertContains(uid, addressData);
        Bug36943Test.assertEquals((String)"N wrong", (String)expectedFirstName, (String)card.getGivenName());
        Bug36943Test.assertEquals((String)"N wrong", (String)lastName, (String)card.getFamilyName());
        Bug36943Test.assertEquals((String)"FN wrong", (String)(expectedFirstName + " " + lastName), (String)card.getFN());
    }
}

