/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cardme.engine.VCardEngine;
import net.sourceforge.cardme.io.CompatibilityMode;
import net.sourceforge.cardme.io.VCardWriter;
import net.sourceforge.cardme.vcard.VCard;
import net.sourceforge.cardme.vcard.arch.VCardVersion;
import net.sourceforge.cardme.vcard.exceptions.VCardBuildException;
import net.sourceforge.cardme.vcard.exceptions.VCardParseException;
import net.sourceforge.cardme.vcard.features.ExtendedFeature;
import net.sourceforge.cardme.vcard.types.ExtendedType;
import net.sourceforge.cardme.vcard.types.FNType;
import net.sourceforge.cardme.vcard.types.NType;
import net.sourceforge.cardme.vcard.types.UidType;

public class VCardResource {
    private static final VCardEngine PARSER = new VCardEngine(CompatibilityMode.MAC_ADDRESS_BOOK);
    private static final VCardWriter WRITER = new VCardWriter(VCardVersion.V3_0, CompatibilityMode.MAC_ADDRESS_BOOK);
    private final String eTag;
    private final String href;
    private final VCard vCard;

    public VCardResource(String vCardString, String href, String eTag) throws IOException, VCardParseException {
        this.vCard = PARSER.parse(vCardString);
        this.href = href;
        this.eTag = eTag;
    }

    public String getUID() {
        UidType uidFeature = this.vCard.getUid();
        return null != uidFeature ? uidFeature.getUid() : null;
    }

    public String getFN() {
        FNType formattedName = this.vCard.getFN();
        return null != formattedName ? formattedName.getFormattedName() : null;
    }

    public String getGivenName() {
        NType n = this.vCard.getN();
        return null != n ? n.getGivenName() : null;
    }

    public String getFamilyName() {
        NType n = this.vCard.getN();
        return null != n ? n.getFamilyName() : null;
    }

    public List<ExtendedType> getExtendedTypes(String extendedName) {
        ArrayList<ExtendedType> xTypes = new ArrayList<ExtendedType>();
        List extendedTypes = this.vCard.getExtendedTypes();
        if (null != extendedTypes) {
            for (ExtendedType xType : extendedTypes) {
                if (!extendedName.equals(xType.getExtendedName())) continue;
                xTypes.add(xType);
            }
        }
        return xTypes;
    }

    public String getETag() {
        return this.eTag;
    }

    public String getHref() {
        return this.href;
    }

    public VCard getVCard() {
        return this.vCard;
    }

    public boolean isGroup() {
        List<ExtendedType> xFeatures = this.getExtendedTypes("X-ADDRESSBOOKSERVER-KIND");
        return null != xFeatures && 0 < xFeatures.size() && "group".equals(xFeatures.get(0).getExtendedValue());
    }

    public List<String> getMemberUIDs() {
        List<ExtendedType> members = this.getExtendedTypes("X-ADDRESSBOOKSERVER-MEMBER");
        if (null == members) {
            return null;
        }
        ArrayList<String> uids = new ArrayList<String>();
        for (ExtendedType memberType : members) {
            uids.add(memberType.getExtendedValue().substring(9));
        }
        return uids;
    }

    public ExtendedFeature getMemberXFeature(String uid) {
        List<ExtendedType> members = this.getExtendedTypes("X-ADDRESSBOOKSERVER-MEMBER");
        if (null == members) {
            return null;
        }
        for (ExtendedType memberType : members) {
            if (!uid.equals(memberType.getExtendedValue().substring(9))) continue;
            return memberType;
        }
        return null;
    }

    public String toString() {
        WRITER.setVCard(this.vCard);
        try {
            return WRITER.buildVCardString();
        }
        catch (VCardBuildException e) {
            e.printStackTrace();
            return null;
        }
    }
}

